/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.review.create;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.space.actions.SpaceActionUtils;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.stats.SpaceStatsCounterCollector;
import com.intellij.space.vcs.SpaceProjectContextKt;
import com.intellij.space.vcs.review.SpaceReviewTabController;
import com.intellij.space.vcs.review.create.CommitsData;
import com.intellij.space.vcs.review.create.SpaceCreateReviewActionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/space/vcs/review/create/SpaceCreateCommitSetReviewAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.space.vcs"})
public final class SpaceCreateCommitSetReviewAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"e.project ?: return");
        Project project3 = project2;
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        Presentation presentation3 = presentation2;
        if (!SpaceProjectContextKt.isSpaceProject(project3)) {
            presentation3.setEnabledAndVisible(false);
            return;
        }
        SpaceActionUtils.INSTANCE.showIconInActionSearch(e);
        SpaceReviewTabController spaceReviewTabController = SpaceCreateReviewActionsKt.access$getReviewTabController(e);
        if (spaceReviewTabController == null) {
            return;
        }
        SpaceReviewTabController reviewTabController = spaceReviewTabController;
        presentation3.setEnabledAndVisible(true);
        switch (e.getPlace()) {
            case "ToolwindowTitle": {
                presentation3.setEnabledAndVisible(!reviewTabController.isInCreatingState());
                break;
            }
            case "Vcs.Log.ContextMenu": {
                boolean isCommitsSuitable = SpaceCreateReviewActionsKt.access$isCommitsSuitableForCodeReview(e, reviewTabController.getSpaceProjectInfo());
                presentation3.setEnabled(isCommitsSuitable);
                if (!isCommitsSuitable) {
                    presentation3.setDescription(SpaceBundle.message("review.create.code.review.action.description.error", new Object[0]));
                } else {
                    presentation3.setDescription(SpaceBundle.message("review.create.code.review.action.description.for.selected.commits", new Object[0]));
                }
                presentation3.setVisible(true);
            }
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        block1: {
            ToolWindow toolWindow;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project2 = e.getProject();
            if (project2 == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"e.project ?: return");
            Project project3 = project2;
            SpaceStatsCounterCollector.CREATE_REVIEW_OPENED.log((Object)SpaceStatsCounterCollector.CreateReviewType.CODE_REVIEW, (Object)e.getPlace());
            ToolWindow toolWindow2 = SpaceCreateReviewActionsKt.access$getReviewToolWindow(project3);
            if (toolWindow2 == null) break block1;
            ToolWindow it = toolWindow = toolWindow2;
            boolean bl = false;
            it.activate(new Runnable(it, project3, e){
                final /* synthetic */ ToolWindow $it;
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ AnActionEvent $e$inlined;
                {
                    this.$it = toolWindow;
                    this.$project$inlined = project2;
                    this.$e$inlined = anActionEvent;
                }

                public final void run() {
                    SpaceReviewTabController spaceReviewTabController = SpaceCreateReviewActionsKt.access$getReviewTabController(this.$it);
                    if (spaceReviewTabController == null) {
                        return;
                    }
                    SpaceReviewTabController reviewTabController = spaceReviewTabController;
                    CommitsData commitsData = SpaceCreateReviewActionsKt.findCommits$default(this.$project$inlined, this.$e$inlined, reviewTabController.getSpaceProjectInfo(), false, 8, null);
                    if (Intrinsics.areEqual((Object)commitsData, (Object)CommitsData.Empty.INSTANCE)) {
                        SpaceReviewTabController.createCodeReview$default(reviewTabController, null, null, 3, null);
                    } else if (commitsData instanceof CommitsData.RepoAndCommits) {
                        reviewTabController.createCodeReview(((CommitsData.RepoAndCommits)commitsData).getCommits(), ((CommitsData.RepoAndCommits)commitsData).getSpaceRepoInfo());
                    }
                }
            });
        }
    }

    public SpaceCreateCommitSetReviewAction() {
        super(SpaceBundle.messagePointer("review.create.code.review.text", new Object[0]));
    }
}

