/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.ivy.core.cache.CacheResourceOptions;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.osgi.repo.RelativeURLRepository;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.url.ChainedRepository;
import org.apache.ivy.plugins.repository.url.URLRepository;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.plugins.resolver.RepositoryResolver;
import org.apache.ivy.util.Message;

public class MirroredURLResolver
extends RepositoryResolver {
    private URL mirrorListUrl;

    public MirroredURLResolver() {
        this.setRepository(new ChainedRepository());
    }

    public void setMirrorListUrl(URL mirrorListUrl) {
        this.mirrorListUrl = mirrorListUrl;
    }

    private void setupMirrors() {
        List<String> mirrorBaseUrls;
        File mirrorListFile = this.downloadMirrorList();
        try {
            mirrorBaseUrls = this.readMirrorList(mirrorListFile);
        }
        catch (IOException e) {
            throw new IllegalStateException("The mirror list could not be read from " + this.mirrorListUrl + " (" + e.getMessage() + ")");
        }
        ArrayList<Repository> repositories2 = new ArrayList<Repository>();
        for (String baseUrl : mirrorBaseUrls) {
            URL url2 = null;
            try {
                url2 = new URL(baseUrl);
            }
            catch (MalformedURLException e) {
                Message.warn("In the mirror list from " + this.mirrorListUrl + ", an incorrect url has been found and will then not be used: " + baseUrl);
            }
            if (url2 == null) continue;
            RelativeURLRepository repo = new RelativeURLRepository(url2, this.getTimeoutConstraint());
            repositories2.add(repo);
        }
        ((ChainedRepository)this.getRepository()).setRepositories(repositories2);
    }

    private File downloadMirrorList() {
        URLRepository urlRepository = new URLRepository(this.getTimeoutConstraint());
        if (this.getEventManager() != null) {
            urlRepository.addTransferListener(this.getEventManager());
        }
        URLResource mirrorResource = new URLResource(this.mirrorListUrl, this.getTimeoutConstraint());
        CacheResourceOptions options2 = new CacheResourceOptions();
        ArtifactDownloadReport report2 = this.getRepositoryCacheManager().downloadRepositoryResource(mirrorResource, "mirrorlist", "text", "txt", options2, urlRepository);
        return report2.getLocalFile();
    }

    private List<String> readMirrorList(File mirrorListFile) throws IOException {
        ArrayList<String> list2 = new ArrayList<String>();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(mirrorListFile)));){
            String line = in.readLine();
            while (line != null) {
                list2.add(line);
                line = in.readLine();
            }
        }
        return list2;
    }

    @Override
    public String getTypeName() {
        return "mirroredurl";
    }

    @Override
    public void validate() {
        super.validate();
        this.setupMirrors();
    }
}

