/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.concurrency;

import com.android.tools.idea.concurrency.ComputationResult;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u0013\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0002J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0004J\u0014\u0010\u0017\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00018\u00008\u00000\u0018J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0002J\u000b\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bR2\u0010\u0006\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00018\u00008\u0000 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00018\u00008\u0000\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/concurrency/Computation;", "V", "", "modificationCountWhenScheduled", "", "(J)V", "future", "Lcom/google/common/util/concurrent/SettableFuture;", "kotlin.jvm.PlatformType", "getModificationCountWhenScheduled", "()J", "result", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/android/tools/idea/concurrency/ComputationResult;", "broadcastResult", "", "cancel", "complete", "(Ljava/lang/Object;)V", "completeExceptionally", "error", "", "getCompletionTimestamp", "getResult", "Lcom/google/common/util/concurrent/ListenableFuture;", "getResultAndCheckComplete", "getResultNow", "()Ljava/lang/Object;", "intellij.android.common"})
final class Computation<V> {
    private final AtomicReference<ComputationResult<V>> result;
    private final SettableFuture<V> future;
    private final long modificationCountWhenScheduled;

    private final ComputationResult<V> getResultAndCheckComplete() {
        ComputationResult<V> computationResult = this.result.get();
        if (computationResult == null) {
            throw (Throwable)new IllegalStateException("This Computation hasn't been executed yet.");
        }
        return computationResult;
    }

    private final void complete(ComputationResult<V> result) {
        boolean bl = this.result.compareAndSet(null, result);
        if (!bl) {
            boolean bl2 = false;
            String string = "This Computation has already been executed.";
            throw new IllegalStateException(string.toString());
        }
    }

    public final void complete(V result) {
        this.complete((V)new ComputationResult.Value<V>(result));
    }

    public final void completeExceptionally(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.complete((V)new ComputationResult.Error(error));
    }

    public final void broadcastResult() {
        ComputationResult<V> result = this.getResultAndCheckComplete();
        if (result instanceof ComputationResult.Value) {
            this.future.set(((ComputationResult.Value)result).getValue());
        } else {
            ComputationResult<V> computationResult = result;
            if (computationResult == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.android.tools.idea.concurrency.ComputationResult.Error<V>");
            }
            this.future.setException(((ComputationResult.Error)computationResult).getError());
        }
    }

    public final void cancel() {
        this.future.cancel(false);
    }

    @NotNull
    public final ListenableFuture<V> getResult() {
        ListenableFuture listenableFuture = Futures.nonCancellationPropagating((ListenableFuture)((ListenableFuture)this.future));
        Intrinsics.checkNotNull((Object)listenableFuture);
        return listenableFuture;
    }

    public final V getResultNow() {
        ComputationResult<V> result = this.getResultAndCheckComplete();
        if (result instanceof ComputationResult.Value) {
            return ((ComputationResult.Value)result).getValue();
        }
        ComputationResult<V> computationResult = result;
        if (computationResult == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.android.tools.idea.concurrency.ComputationResult.Error<V>");
        }
        throw (Throwable)new IllegalStateException("This Computation completed exceptionally.", ((ComputationResult.Error)computationResult).getError());
    }

    public final long getCompletionTimestamp() {
        return this.getResultAndCheckComplete().getTimestampMs();
    }

    public final long getModificationCountWhenScheduled() {
        return this.modificationCountWhenScheduled;
    }

    public Computation(long modificationCountWhenScheduled) {
        this.modificationCountWhenScheduled = modificationCountWhenScheduled;
        this.result = new AtomicReference<Object>(null);
        this.future = SettableFuture.create();
    }
}

