/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.flags;

import com.android.flags.Flag;
import com.android.flags.FlagGroup;
import com.android.flags.FlagOverrides;
import com.android.flags.Flags;
import com.android.flags.ImmutableFlagOverrides;
import com.android.flags.overrides.DefaultFlagOverrides;
import com.android.flags.overrides.PropertyOverrides;
import com.android.tools.idea.flags.StudioFlagSettings;
import com.android.tools.idea.flags.overrides.ServerFlagOverrides;
import com.android.tools.idea.util.StudioPathManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import org.jetbrains.annotations.NotNull;

public final class StudioFlags {
    private static final Flags FLAGS = StudioFlags.createFlags();
    private static final FlagGroup NPW = new FlagGroup(FLAGS, "npw", "New Project Wizard");
    public static final Flag<Boolean> NPW_FIRST_RUN_WIZARD = Flag.create((FlagGroup)NPW, (String)"first.run.wizard", (String)"Show new Welcome Wizard", (String)"Show new version of the Welcome Wizard when Studio starts", (boolean)false);
    public static final Flag<Boolean> NPW_FIRST_RUN_SHOW = Flag.create((FlagGroup)NPW, (String)"first.run.wizard.show", (String)"Show Welcome Wizard always", (String)"Show the Welcome Wizard when Studio starts", (boolean)false);
    public static final Flag<Boolean> NPW_SHOW_JDK_STEP = Flag.create((FlagGroup)NPW, (String)"first.run.jdk.step", (String)"Show JDK setup step", (String)"Show JDK Setup Step in Welcome Wizard", (boolean)true);
    public static final Flag<Boolean> NPW_SHOW_FRAGMENT_GALLERY = Flag.create((FlagGroup)NPW, (String)"show.fragment.gallery", (String)"Show fragment gallery", (String)"Show fragment gallery which contains fragment based templates", (boolean)true);
    public static final Flag<Boolean> NPW_SHOW_GRADLE_KTS_OPTION = Flag.create((FlagGroup)NPW, (String)"show.gradle.kts.option", (String)"Show gradle kts option", (String)"Shows an option on new Project/Module to allow the use of Kotlin script", (boolean)false);
    public static final Flag<Boolean> NPW_NEW_NATIVE_MODULE = Flag.create((FlagGroup)NPW, (String)"new.native.module", (String)"New Android Native Module", (String)"Show template to create a new Android Native module in the new module wizard.", (boolean)true);
    private static final FlagGroup PROFILER = new FlagGroup(FLAGS, "profiler", "Android Profiler");
    public static final Flag<Boolean> PROFILER_CPU_CAPTURE_STAGE = Flag.create((FlagGroup)PROFILER, (String)"cpu.capture.stage", (String)"Enable new capture stage", (String)"With the new System Trace design we have a cpu capture stage. This flag uses that flow instead of the legacy CpuProfilerStageView flow.", (boolean)true);
    public static final Flag<Boolean> PROFILER_ENABLE_NATIVE_SAMPLE = Flag.create((FlagGroup)PROFILER, (String)"memory.heapprofd", (String)"Enable heapprofd captures in the memory profiler.", (String)"Toggles if users can capture heapprofd recordings in the memory profiler. This gates mostly the UI and importing of traces. The perfd functionality is not gated. This feature has a dependency on the trace processor.", (boolean)true);
    public static final Flag<Boolean> PROFILER_UNIFIED_PIPELINE = Flag.create((FlagGroup)PROFILER, (String)"unified.pipeline", (String)"Enables new event pipeline to be used for core components.", (String)"Toggles usage of gRPC apis to fetch data from perfd and the datastore.", (boolean)true);
    public static final Flag<Boolean> PROFILER_ENERGY_PROFILER_ENABLED = Flag.create((FlagGroup)PROFILER, (String)"energy", (String)"Enable Energy profiling", (String)"Enable the new energy profiler. It monitors battery usage of the selected app.", (boolean)true);
    public static final Flag<Boolean> PROFILER_STARTUP_CPU_PROFILING = Flag.create((FlagGroup)PROFILER, (String)"startup.cpu.profiling", (String)"Enable startup CPU Profiling", (String)"Record a method trace on startup by enabling it in the Profiler tab of Run/Debug configuration.", (boolean)true);
    public static final Flag<Boolean> PROFILER_USE_LIVE_ALLOCATIONS = Flag.create((FlagGroup)PROFILER, (String)"livealloc", (String)"Enable JVMTI-based live allocation tracking", (String)"For Android O or newer, allocations are tracked all the time while inside the Memory Profiler.", (boolean)true);
    public static final Flag<Boolean> PROFILER_MEMORY_SNAPSHOT = Flag.create((FlagGroup)PROFILER, (String)"memory.livealloc.snapshot", (String)"Enable Memory Class Histogram Display", (String)"For Android O or newer, supports single-point selection which shows a snapshot of the heap at the specific time.", (boolean)true);
    public static final Flag<Boolean> PROFILER_MEMORY_CSV_EXPORT = Flag.create((FlagGroup)PROFILER, (String)"memory.csv", (String)"Allow exporting entries in memory profiler", (String)"Allow exporting entries in the views for heap dump and native/JVM recordings in CSV format.", (boolean)false);
    public static final Flag<Boolean> PROFILER_SAMPLE_LIVE_ALLOCATIONS = Flag.create((FlagGroup)PROFILER, (String)"memory.livealloc.sampled", (String)"Enable Sampled Live Allocation Tracking", (String)"For Android O or newer, allows users to configure the sampling mode of live allocation tracking", (boolean)true);
    public static final Flag<Boolean> PROFILER_TRACK_JNI_REFS = Flag.create((FlagGroup)PROFILER, (String)"jni", (String)"Enable JVMTI-based JNI reference tracking.", (String)"For Android O or newer, JNI references are tracked in Memory Profiler and shown in JNI heap.", (boolean)true);
    public static final Flag<Boolean> PROFILER_PERFORMANCE_MONITORING = Flag.create((FlagGroup)PROFILER, (String)"performance.monitoring", (String)"Enable Profiler Performance Monitoring Options", (String)"Toggles if profiler performance metrics options are enabled.", (boolean)false);
    public static final Flag<Boolean> PROFILER_CPU_NEW_RECORDING_WORKFLOW = Flag.create((FlagGroup)PROFILER, (String)"cpu.new.recording.workflow", (String)"Enable new CPU recording workflow", (String)"Shows recording options and status of the ongoing recording in the method trace pane.", (boolean)true);
    public static final Flag<Boolean> PROFILER_CUSTOM_EVENT_VISUALIZATION = Flag.create((FlagGroup)PROFILER, (String)"custom.event.visualization", (String)"Enable Profiler Custom Event Visualization", (String)"When enabled, profiler will track and display events defined through developer APIs", (boolean)false);
    public static final Flag<Boolean> PROFILER_USE_TRACEPROCESSOR = Flag.create((FlagGroup)PROFILER, (String)"perfetto.traceprocessor", (String)"Enable TraceProcessorDaemon", (String)"Use TraceProcessor to parse Perfetto captures instead of Trebuchet/Atrace backend.", (boolean)true);
    public static final Flag<Boolean> PROFILEABLE = Flag.create((FlagGroup)PROFILER, (String)"profileable", (String)"Support profileable processes on S+", (String)"Show profileable processes on S and later", (boolean)false);
    public static final Flag<Boolean> PROFILEABLE_IN_QR;
    private static final FlagGroup ML;
    public static final Flag<Boolean> ML_MODEL_BINDING;
    private static final FlagGroup ASSET;
    public static final Flag<Boolean> ASSET_COPY_MATERIAL_ICONS;
    public static final Flag<Boolean> ASSET_DOWNLOAD_MATERIAL_ICONS;
    private static final FlagGroup NELE;
    public static final Flag<Boolean> NELE_ANIMATIONS_PREVIEW;
    public static final Flag<Boolean> NELE_ANIMATED_SELECTOR_PREVIEW;
    public static final Flag<Boolean> NELE_MOTION_LAYOUT_ANIMATIONS;
    public static final Flag<Boolean> NELE_MOTION_LAYOUT_EDITOR;
    public static final Flag<Boolean> NELE_CONSTRAINT_SELECTOR;
    public static final Flag<Boolean> NELE_MOTION_HORIZONTAL;
    public static final Flag<Boolean> NELE_MOCKUP_EDITOR;
    public static final Flag<Boolean> NELE_CONVERT_VIEW;
    public static final Flag<Boolean> NELE_RENDER_DIAGNOSTICS;
    public static final Flag<Boolean> NELE_COLOR_RESOURCE_PICKER_FOR_FILE_EDITORS;
    public static final Flag<Boolean> NELE_DRAWABLE_POPUP_PICKER;
    public static final Flag<Boolean> NELE_LOG_ANDROID_FRAMEWORK;
    public static final Flag<Boolean> NELE_SCENEVIEW_TOP_TOOLBAR;
    public static final Flag<Boolean> NELE_SCENEVIEW_BOTTOM_BAR;
    public static final Flag<Boolean> NELE_SCENEVIEW_LEFT_BAR;
    public static final Flag<Boolean> NELE_SHOW_LAYOUTLIB_LEGACY;
    private static final FlagGroup ASSISTANT;
    public static final Flag<Boolean> CONNECTION_ASSISTANT_ENABLED;
    public static final Flag<Boolean> NELE_CONSTRAINT_LAYOUT_ASSISTANT;
    public static final Flag<Boolean> NELE_MOTION_LAYOUT_ASSISTANT;
    public static final Flag<Boolean> NELE_NAV_EDITOR_ASSISTANT;
    public static final Flag<Boolean> NELE_DRAG_PLACEHOLDER;
    public static final Flag<Boolean> NELE_PROPERTY_PANEL_ACTIONBAR;
    public static final Flag<Boolean> NELE_VISUALIZATION_LOCALE_MODE;
    public static final Flag<Boolean> NELE_VISUALIZATION_APPLY_CONFIG_TO_LAYOUT_EDITOR;
    public static final Flag<Boolean> NELE_SOURCE_CODE_EDITOR;
    public static final Flag<Boolean> NELE_TOGGLE_TOOLS_ATTRIBUTES_IN_PREVIEW;
    public static final Flag<Boolean> NELE_SHOW_RECYCLER_VIEW_SETUP_WIZARD;
    public static final Flag<Boolean> NELE_CUSTOM_SHORTCUT_KEYMAP;
    public static final Flag<Boolean> NELE_LAYOUT_SCANNER_IN_EDITOR;
    public static final Flag<Boolean> NELE_LAYOUT_SCANNER_ADD_INCLUDE;
    public static final Flag<Boolean> NELE_TRANSFORM_PANEL;
    public static final Flag<Boolean> NELE_TRANSITION_PANEL;
    public static final Flag<Boolean> NELE_OVERLAY_PROVIDER;
    public static final Flag<Boolean> NELE_CLASS_BINARY_CACHE;
    public static final Flag<Boolean> NELE_STATE_LIST_PICKER;
    public static final Flag<Boolean> NELE_ASSET_REPOSITORY_INCLUDE_AARS_THROUGH_PROJECT_SYSTEM;
    public static final Flag<Boolean> NELE_VISUAL_LINT;
    public static final Flag<Boolean> NELE_WARN_NEW_THREADS;
    private static final FlagGroup NAV_EDITOR;
    public static final Flag<Boolean> NAV_SAFE_ARGS_SUPPORT;
    private static final FlagGroup RES_MANAGER;
    public static final Flag<Boolean> EXTENDED_TYPE_FILTERS;
    public static final Flag<Boolean> NAVIGATION_PREVIEW;
    private static final FlagGroup RESOURCE_REPOSITORY;
    public static final Flag<Boolean> RESOURCE_REPOSITORY_TRACE_UPDATES;
    public static final Flag<Integer> RESOURCE_REPOSITORY_TRACE_SIZE;
    private static final FlagGroup RUNDEBUG;
    public static final Flag<Boolean> RUNDEBUG_LOGCAT_CONSOLE_OUTPUT_ENABLED;
    public static final Flag<Boolean> RUNDEBUG_ANDROID_BUILD_BUNDLE_ENABLED;
    public static final Flag<Boolean> DELTA_INSTALL;
    public static final Flag<Boolean> APPLY_CHANGES_OPTIMISTIC_SWAP;
    public static final Flag<Boolean> APPLY_CHANGES_OPTIMISTIC_RESOURCE_SWAP;
    public static final Flag<OptimisticInstallSupportLevel> OPTIMISTIC_INSTALL_SUPPORT_LEVEL;
    public static final Flag<Boolean> APPLY_CHANGES_STRUCTURAL_DEFINITION;
    public static final Flag<Boolean> APPLY_CHANGES_VARIABLE_REINITIALIZATION;
    public static final Flag<Boolean> APPLY_CHANGES_FAST_RESTART_ON_SWAP_FAIL;
    public static final Flag<Boolean> APPLY_CHANGES_KEEP_CONNECTION_ALIVE;
    public static final Flag<Boolean> SELECT_DEVICE_SNAPSHOT_COMBO_BOX_SNAPSHOTS_ENABLED;
    public static final Flag<Boolean> RUN_ON_MULTIPLE_DEVICES_ACTION_ENABLED;
    public static final Flag<Boolean> ADB_CONNECTION_STATUS_WIDGET_ENABLED;
    public static final Flag<Boolean> ADB_WIRELESS_PAIRING_ENABLED;
    public static final Flag<Boolean> WEAR_DEVICE_PAIRING_ENABLED;
    public static final Flag<Boolean> ADB_SERVER_MANAGEMENT_MODE_SETTINGS_VISIBLE;
    public static final Flag<DefaultActivityLocatorStrategy> DEFAULT_ACTIVITY_LOCATOR_STRATEGY;
    public static final Flag<Boolean> DEFAULT_ACTIVITY_LOCATOR_FROM_APKS;
    public static final Flag<Boolean> SUPPORT_FEATURE_ON_FEATURE_DEPS;
    public static final Flag<Boolean> COROUTINE_DEBUGGER_ENABLE;
    private static final FlagGroup GRADLE_IDE;
    public static final Flag<Boolean> FIX_ANDROID_RUN_CONFIGURATIONS_ENABLED;
    public static final Flag<Boolean> NEW_PSD_ENABLED;
    public static final Flag<Boolean> USE_DEVELOPMENT_OFFLINE_REPOS;
    public static final Flag<Boolean> BUILD_ATTRIBUTION_ENABLED;
    public static final Flag<Boolean> AGP_UPGRADE_ASSISTANT;
    public static final Flag<Boolean> AGP_UPGRADE_ASSISTANT_TOOL_WINDOW;
    public static final Flag<Boolean> DISABLE_FORCED_UPGRADES;
    public static final Flag<Boolean> USE_MODULE_PER_SOURCE_SET;
    public static final Flag<Boolean> GRADLE_SYNC_PARALLEL_SYNC_ENABLED;
    public static final Flag<Boolean> GRADLE_SYNC_PARALLEL_SYNC_PREFETCH_VARIANTS;
    public static final Flag<Boolean> GRADLE_SYNC_ENABLE_CACHED_VARIANTS;
    public static final Flag<Boolean> ALLOW_DIFFERENT_JDK_VERSION;
    public static final Flag<Boolean> GRADLE_SYNC_USE_V2_MODEL;
    public static final Flag<Boolean> GRADLE_SYNC_RECREATE_JDK;
    private static final FlagGroup DATABASE_INSPECTOR;
    public static final Flag<Boolean> DATABASE_INSPECTOR_ENABLED;
    public static final Flag<Boolean> DATABASE_INSPECTOR_OPEN_FILES_ENABLED;
    public static final Flag<Boolean> DATABASE_INSPECTOR_OFFLINE_MODE_ENABLED;
    public static final Flag<Boolean> DATABASE_INSPECTOR_EXPORT_TO_FILE_ENABLED;
    private static final FlagGroup LAYOUT_INSPECTOR;
    public static final Flag<Boolean> LAYOUT_INSPECTOR_LOAD_OVERLAY_ENABLED;
    public static final Flag<Boolean> LAYOUT_INSPECTOR_SUB_VIEW_ENABLED;
    public static final Flag<Boolean> LAYOUT_INSPECTOR_V2_PROTOCOL_ENABLED;
    public static final Flag<Boolean> LAYOUT_INSPECTOR_EDITING_ENABLED;
    public static final Flag<Boolean> DYNAMIC_LAYOUT_INSPECTOR_ENABLED;
    public static final Flag<Boolean> DYNAMIC_LAYOUT_INSPECTOR_EDITING_ENABLED;
    public static final Flag<Boolean> DYNAMIC_LAYOUT_INSPECTOR_USE_DEVBUILD_SKIA_SERVER;
    public static final Flag<Boolean> DYNAMIC_LAYOUT_INSPECTOR_ENABLE_COMPOSE_SUPPORT;
    public static final Flag<Boolean> DYNAMIC_LAYOUT_INSPECTOR_USE_INSPECTION;
    public static final Flag<Boolean> DYNAMIC_LAYOUT_INSPECTOR_SHOW_SEMANTICS;
    private static final FlagGroup EMBEDDED_EMULATOR;
    public static final Flag<Boolean> EMBEDDED_EMULATOR_SCREENSHOT_STATISTICS;
    public static final Flag<Boolean> EMBEDDED_EMULATOR_TRACE_GRPC_CALLS;
    public static final Flag<Boolean> EMBEDDED_EMULATOR_TRACE_HIGH_VOLUME_GRPC_CALLS;
    public static final Flag<Boolean> EMBEDDED_EMULATOR_TRACE_SCREENSHOTS;
    public static final Flag<Boolean> EMBEDDED_EMULATOR_TRACE_NOTIFICATIONS;
    public static final Flag<Boolean> EMBEDDED_EMULATOR_TRACE_DISCOVERY;
    private static final FlagGroup REFACTORINGS;
    public static final Flag<Boolean> MIGRATE_TO_RESOURCE_NAMESPACES_REFACTORING_ENABLED;
    public static final Flag<Boolean> MIGRATE_TO_NON_TRANSITIVE_R_CLASSES_REFACTORING_ENABLED;
    private static final FlagGroup IOT;
    public static final Flag<Boolean> UNINSTALL_LAUNCHER_APPS_ENABLED;
    private static final FlagGroup NDK;
    public static final Flag<Boolean> CMAKE_ENABLE_FEATURES_FROM_CLION;
    public static final Flag<Boolean> APK_DEBUG_BUILD_ID_CHECK;
    public static final Flag<Boolean> APK_DEBUG_RELOAD;
    private static final FlagGroup NDK_SIDE_BY_SIDE;
    public static final Flag<Boolean> NDK_SIDE_BY_SIDE_ENABLED;
    public static final Flag<Boolean> USE_CONTENT_ROOTS_FOR_NATIVE_PROJECT_VIEW;
    public static final Flag<Boolean> ENABLE_SHOW_FILES_UNKNOWN_TO_CMAKE;
    public static final Flag<Boolean> ENABLE_LLDB_NATVIS;
    private static final FlagGroup EDITOR;
    public static final Flag<Boolean> COLLAPSE_ANDROID_NAMESPACE;
    public static final Flag<Boolean> ADVANCED_JNI_ASSISTANCE;
    public static final Flag<Boolean> CUSTOM_JAVA_NEW_CLASS_DIALOG;
    public static final Flag<Boolean> INCREMENTAL_RESOURCE_REPOSITORIES;
    public static final Flag<Boolean> TWEAK_COLOR_SCHEME;
    public static final Flag<Boolean> SAMPLES_SUPPORT_ENABLED;
    public static final Flag<Boolean> DAGGER_SUPPORT_ENABLED;
    private static final FlagGroup UAB;
    public static final Flag<Boolean> UAB_ENABLE_NEW_INSTANT_APP_RUN_CONFIGURATIONS;
    private static final FlagGroup TESTING;
    public static final Flag<Boolean> PRINT_INSTRUMENTATION_STATUS;
    public static final Flag<Boolean> MULTIDEVICE_INSTRUMENTATION_TESTS;
    public static final Flag<Boolean> UTP_TEST_RESULT_SUPPORT;
    public static final Flag<Boolean> UTP_INSTRUMENTATION_TESTING;
    private static final FlagGroup MEMORY_SETTINGS;
    public static final Flag<Boolean> LOW_IDE_XMX_CAP;
    private static final FlagGroup SYSTEM_HEALTH;
    public static final Flag<Boolean> WINDOWS_UCRT_CHECK_ENABLED;
    public static final Flag<Boolean> ANTIVIRUS_NOTIFICATION_ENABLED;
    public static final Flag<Boolean> ANTIVIRUS_METRICS_ENABLED;
    public static final Flag<Boolean> ANTIVIRUS_CHECK_USE_REGISTRY;
    private static final FlagGroup COMPOSE;
    public static final Flag<Boolean> COMPOSE_PREVIEW;
    public static final Flag<Boolean> COMPOSE_PREVIEW_ONLY_KOTLIN_BUILD;
    public static final Flag<Boolean> COMPOSE_PREVIEW_BUILD_ON_SAVE;
    public static final Flag<Boolean> COMPOSE_PREVIEW_RUN_CONFIGURATION;
    public static final Flag<Boolean> COMPOSE_PREVIEW_DOUBLE_RENDER;
    public static final Flag<Boolean> COMPOSE_PREVIEW_SCROLL_ON_CARET_MOVE;
    public static final Flag<Boolean> COMPOSE_PREVIEW_INTERRUPTIBLE;
    public static final Flag<Boolean> COMPOSE_EDITOR_SUPPORT;
    public static final Flag<Boolean> COMPOSE_COMPLETION_PRESENTATION;
    public static final Flag<Boolean> COMPOSE_COMPLETION_WEIGHER;
    public static final Flag<Boolean> COMPOSE_COMPLETION_INSERT_HANDLER;
    public static final Flag<Boolean> COMPOSE_AUTO_DOCUMENTATION;
    public static final Flag<Boolean> COMPOSE_RENDER_SAMPLE_IN_DOCUMENTATION;
    public static final Flag<Boolean> COMPOSE_RENDER_SAMPLE_IN_DOCUMENTATION_SLOW;
    public static final Flag<Boolean> COMPOSE_FUNCTION_EXTRACTION;
    public static final Flag<Boolean> COMPOSE_WIZARD_TEMPLATES;
    public static final Flag<Boolean> COMPOSE_ANIMATED_PREVIEW;
    public static final Flag<Boolean> COMPOSE_ANIMATED_PREVIEW_SHOW_CLICK;
    public static final Flag<Boolean> COMPOSE_ANIMATION_INSPECTOR;
    public static final Flag<Boolean> COMPOSE_ANIMATION_PREVIEW_LABEL_INSPECTION;
    public static final Flag<Boolean> COMPOSE_LIVE_LITERALS;
    public static final Flag<Boolean> COMPOSE_DEPLOY_LIVE_LITERALS;
    public static final Flag<Integer> COMPOSE_LIVE_LITERALS_UPDATE_RATE;
    public static final Flag<Boolean> COMPOSE_DEBUG_BOUNDS;
    public static final Flag<Boolean> COMPOSE_PREVIEW_ELEMENT_PICKER;
    public static final Flag<Boolean> COMPOSE_BLUEPRINT_MODE;
    public static final Flag<Boolean> COMPOSE_QUICK_ANIMATED_PREVIEW;
    public static final Flag<Boolean> NL_COLORBLIND_MODE;
    public static final Flag<Boolean> COMPOSE_COLORBLIND_MODE;
    public static final Flag<Boolean> COMPOSE_PIN_PREVIEW;
    public static final Flag<Boolean> COMPOSE_CONSTRAINT_VISUALIZATION;
    public static final Flag<Boolean> COMPOSE_INDIVIDUAL_PIN_PREVIEW;
    public static final Flag<Boolean> COMPOSE_INTERACTIVE_ANIMATION_SWITCH;
    public static final Flag<Boolean> COMPOSE_CLASSLOADERS_PRELOADING;
    private static final FlagGroup MANIFESTS;
    public static final Flag<Boolean> ANDROID_MANIFEST_INDEX_ENABLED;
    private static final FlagGroup APP_INSPECTION;
    public static final Flag<Boolean> ENABLE_APP_INSPECTION_TOOL_WINDOW;
    public static final Flag<Boolean> APP_INSPECTION_USE_DEV_JAR;
    public static final Flag<Boolean> APP_INSPECTION_USE_SNAPSHOT_JAR;
    private static final FlagGroup WORK_MANAGER_INSPECTOR;
    public static final Flag<Boolean> ENABLE_WORK_MANAGER_INSPECTOR_TAB;
    public static final Flag<Boolean> ENABLE_WORK_MANAGER_GRAPH_VIEW;
    private static final FlagGroup NETWORK_INSPECTOR;
    public static final Flag<Boolean> ENABLE_NETWORK_MANAGER_INSPECTOR_TAB;
    private static final FlagGroup BACKGROUND_TASK_INSPECTOR;
    public static final Flag<Boolean> ENABLE_BACKGROUND_TASK_INSPECTOR_TAB;
    private static final FlagGroup DEVICE_MANAGER;
    public static final Flag<Boolean> ENABLE_NEW_DEVICE_MANAGER_PANEL;
    public static final Flag<Boolean> ENABLE_DEVICE_MANAGER_GROUPS;
    private static final FlagGroup SUGGESTED_IMPORT;
    public static final Flag<Boolean> ENABLE_SUGGESTED_IMPORT;
    private static final FlagGroup DDMLIB;
    public static final Flag<Boolean> ENABLE_JDWP_PROXY_SERVICE;
    private static final FlagGroup SERVER_FLAGS;
    public static final Flag<Boolean> TEST_SERVER_FLAG;

    @NotNull
    private static Flags createFlags() {
        Application app = ApplicationManager.getApplication();
        Object userOverrides = app != null && !app.isUnitTestMode() ? StudioFlagSettings.getInstance() : new DefaultFlagOverrides();
        return new Flags((FlagOverrides)userOverrides, new ImmutableFlagOverrides[]{new PropertyOverrides(), new ServerFlagOverrides()});
    }

    private StudioFlags() {
    }

    static {
        if (((Boolean)PROFILEABLE.get()).booleanValue()) {
            // empty if block
        }
        PROFILEABLE_IN_QR = Flag.create((FlagGroup)PROFILER, (String)"profileable.qr", (String)"Support profileable processes on Q & R", (String)"Show profileable processes on Q and R", (boolean)false);
        ML = new FlagGroup(FLAGS, "ml", "ML");
        ML_MODEL_BINDING = Flag.create((FlagGroup)ML, (String)"modelbinding", (String)"Enable ML model binding", (String)"When enabled, TFLite model file will be recognized and indexed. Please invalidates file caches after enabling (File -> Invalidate Caches...) in order to reindex model files.", (boolean)true);
        ASSET = new FlagGroup(FLAGS, "asset", "Asset Studio");
        ASSET_COPY_MATERIAL_ICONS = Flag.create((FlagGroup)ASSET, (String)"copy.material.icons", (String)"Allow copying icons to Sdk folder", (String)"Allow the IconPickerDialog in Asset Studio to copy bundled material icons in to the Android/Sdk folder", (boolean)true);
        ASSET_DOWNLOAD_MATERIAL_ICONS = Flag.create((FlagGroup)ASSET, (String)"download.material.icons", (String)"Allow downloading icons to Sdk folder", (String)"Allow the IconPickerDialog in Asset Studio to download any new material icons in to the Android/Sdk folder", (boolean)true);
        NELE = new FlagGroup(FLAGS, "nele", "Layout Editor");
        NELE_ANIMATIONS_PREVIEW = Flag.create((FlagGroup)NELE, (String)"animated.preview", (String)"Show preview animations toolbar", (String)"Show an animations bar that allows playback of vector drawable animations.", (boolean)false);
        NELE_ANIMATED_SELECTOR_PREVIEW = Flag.create((FlagGroup)NELE, (String)"animated.selector.preview", (String)"Show preview animations toolbar for animated selector", (String)"Show an animations bar that allows playback of transitions in animated selector.", (boolean)false);
        NELE_MOTION_LAYOUT_ANIMATIONS = Flag.create((FlagGroup)NELE, (String)"animated.motion.layout", (String)"Show preview animations toolbar for MotionLayout", (String)"Show an animations bar that allows playback of MotionLayout animations.", (boolean)false);
        NELE_MOTION_LAYOUT_EDITOR = Flag.create((FlagGroup)NELE, (String)"animated.motion.editor", (String)"Show motion editor for MotionLayout", (String)"Show the motion editor UI for MotionLayout.", (boolean)true);
        NELE_CONSTRAINT_SELECTOR = Flag.create((FlagGroup)NELE, (String)"constraint.selection", (String)"Allow selection of Constraints", (String)"Allow the selection of constraints.", (boolean)true);
        NELE_MOTION_HORIZONTAL = Flag.create((FlagGroup)NELE, (String)"animated.motion.horizontal", (String)"Display motion editor horizontally", (String)"Controls the placement of the motion editor (horizontal versus vertical).", (boolean)false);
        NELE_MOCKUP_EDITOR = Flag.create((FlagGroup)NELE, (String)"mockup.editor", (String)"Enable the Mockup Editor", (String)"Enable the Mockup Editor to ease the creation of Layouts from a design file.", (boolean)false);
        NELE_CONVERT_VIEW = Flag.create((FlagGroup)NELE, (String)"convert.view", (String)"Enable the Convert View action", (String)"Enable the Convert View Action when right clicking on a component", (boolean)true);
        NELE_RENDER_DIAGNOSTICS = Flag.create((FlagGroup)NELE, (String)"diagnostics", (String)"Enable rendering on-screen stats", (String)"If enabled, the surface displays some debug information to diagnose performance", (boolean)false);
        NELE_COLOR_RESOURCE_PICKER_FOR_FILE_EDITORS = Flag.create((FlagGroup)NELE, (String)"editor.color.picker", (String)"Enable popup color resource picker for java and kotlin files.", (String)"Show the popup color resource picker when clicking the gutter icon of color resource in java and kotlin files.", (boolean)true);
        NELE_DRAWABLE_POPUP_PICKER = Flag.create((FlagGroup)NELE, (String)"show.drawable.popup.picker", (String)"Enable drawable popup picker in Xml Editor.", (String)"Show the resource popup picker for picking drawable resources from the Editor's gutter icon.", (boolean)true);
        NELE_LOG_ANDROID_FRAMEWORK = Flag.create((FlagGroup)NELE, (String)"log.android.framework", (String)"Log messages coming from Layoutlib Native.", (String)"Log in the IDEA log the messages coming from Java and native code of Layoutlib Native.", (boolean)false);
        NELE_SCENEVIEW_TOP_TOOLBAR = Flag.create((FlagGroup)NELE, (String)"sceneview.top.toolbar", (String)"Enable the per SceneView top toolbar.", (String)"Enable the per SceneView top toolbar that displays the SceneView contextual actions.", (boolean)true);
        NELE_SCENEVIEW_BOTTOM_BAR = Flag.create((FlagGroup)NELE, (String)"sceneview.bottom.bar", (String)"Enable the per SceneView bottom bar.", (String)"Enable the per SceneView bottom bar that displays the SceneView contextual actions.", (boolean)false);
        NELE_SCENEVIEW_LEFT_BAR = Flag.create((FlagGroup)NELE, (String)"sceneview.left.bar", (String)"Enable SceneView left bar for overlay actions.", (String)"Enable the SceneView left bar that displays the overlay actions.", (boolean)true);
        NELE_SHOW_LAYOUTLIB_LEGACY = Flag.create((FlagGroup)NELE, (String)"hide.layoutlib.legacy", (String)"Show the legacy version of Layoutlib.", (String)"Show users ways of reverting to the legacy version of Layoutlib.", (boolean)false);
        ASSISTANT = new FlagGroup(FLAGS, "assistant", "Assistants");
        CONNECTION_ASSISTANT_ENABLED = Flag.create((FlagGroup)ASSISTANT, (String)"connection.enabled", (String)"Enable the connection assistant", (String)"If enabled, user can access the Connection Assistant under \"Tools\" and \"Deploy Target Dialog\"", (boolean)true);
        NELE_CONSTRAINT_LAYOUT_ASSISTANT = Flag.create((FlagGroup)ASSISTANT, (String)"layout.editor.help.constraintlayout", (String)"Display Help for Constraint Layout", (String)"If enabled, the assistant panel will display helpful guide on using Constraint Layout.", (boolean)true);
        NELE_MOTION_LAYOUT_ASSISTANT = Flag.create((FlagGroup)ASSISTANT, (String)"layout.editor.help.motionlayout", (String)"Display Help for Motion Layout", (String)"If enabled, the assistant panel will display helpful guide on using Motion Layout.", (boolean)true);
        NELE_NAV_EDITOR_ASSISTANT = Flag.create((FlagGroup)ASSISTANT, (String)"layout.editor.help.naveditor", (String)"Display Help for Navigation Editor", (String)"If enabled, the assistant panel will display helpful guide on using the Navigation Editor.", (boolean)true);
        NELE_DRAG_PLACEHOLDER = Flag.create((FlagGroup)NELE, (String)"drag.placeholder", (String)"Dragging widgets with Placeholders", (String)"New architecture for dragging widgets in Layout Editor", (boolean)true);
        NELE_PROPERTY_PANEL_ACTIONBAR = Flag.create((FlagGroup)NELE, (String)"property.panel.actionbar", (String)"Property Panel Actionbar", (String)"Support Actionbar in property panel", (boolean)false);
        NELE_VISUALIZATION_LOCALE_MODE = Flag.create((FlagGroup)NELE, (String)"visualization.locale", (String)"Locale Mode in Layout Validation Tool", (String)"Enable locale mode in Layout Validation Tool to preview layout in project's locales", (boolean)true);
        NELE_VISUALIZATION_APPLY_CONFIG_TO_LAYOUT_EDITOR = Flag.create((FlagGroup)NELE, (String)"visualization.apply.config", (String)"Apply Selected Configuration in Validation Tool to Layout Editor", (String)"Apply the configuration to Layout Editor by double clicking the preview in Validation Tool", (boolean)false);
        NELE_SOURCE_CODE_EDITOR = Flag.create((FlagGroup)NELE, (String)"show.source.code.editor", (String)"New Source Code Editor", (String)"Enable new source code editor with preview(s) coming as a substitute to Compose and Custom View editors.", (boolean)true);
        NELE_TOGGLE_TOOLS_ATTRIBUTES_IN_PREVIEW = Flag.create((FlagGroup)NELE, (String)"toggle.tools.attributes.preview", (String)"New Toggle for Tools namespaces attributes", (String)"Enable the new toggle in the Layout Editor. Allows toggling tools attributes in the Layout preview.", (boolean)true);
        NELE_SHOW_RECYCLER_VIEW_SETUP_WIZARD = Flag.create((FlagGroup)NELE, (String)"recyclerview.setup.wizard", (String)"Show setup wizard for recycler view", (String)"When you right click recycler view in layout editor, you can now see \"Generate Adapter\" that takes you through setup wizard", (boolean)false);
        NELE_CUSTOM_SHORTCUT_KEYMAP = Flag.create((FlagGroup)NELE, (String)"custom.shortcut.keymap", (String)"Design Tool Custom Shortcut", (String)"Make the shortcuts of design tools configurable. The shortcut keymap can be changed in Preferences -> Keymap -> Android Design Tools", (boolean)true);
        NELE_LAYOUT_SCANNER_IN_EDITOR = Flag.create((FlagGroup)NELE, (String)"toggle.layout.editor.validator.a11y", (String)"Toggle layout validator for layout editor.", (String)"When the model changes, layout editor will run the series of layout validations and update lint output", (boolean)true);
        NELE_LAYOUT_SCANNER_ADD_INCLUDE = Flag.create((FlagGroup)NELE, (String)"toggle.layout.editor.validator.a11y.include", (String)"Toggle whether to show included layout or not.", (String)"If the layout contains <include>, turning this flag on will run the scanner in the included layout.", (boolean)false);
        NELE_TRANSFORM_PANEL = Flag.create((FlagGroup)NELE, (String)"toggle.layout.editor.transform.panel", (String)"Toggle transform panel in layout editor and motion editor.", (String)"Enable the new transform panel in the layout editor and motion editor", (boolean)true);
        NELE_TRANSITION_PANEL = Flag.create((FlagGroup)NELE, (String)"toggle.layout.editor.transition.panel", (String)"Toggle transition panel in motion editor.", (String)"Enable the new transition panel in the motion editor", (boolean)true);
        NELE_OVERLAY_PROVIDER = Flag.create((FlagGroup)NELE, (String)"toggle.overlay.provider.extension.point", (String)"Toggle overlay provider extension point.", (String)"Enable the overlay provider extension point", (boolean)true);
        NELE_CLASS_BINARY_CACHE = Flag.create((FlagGroup)NELE, (String)"toggle.layout.editor.class.binary.cache", (String)"Enable binary cache", (String)"Enable binary cache of classes used in preview", (boolean)true);
        NELE_STATE_LIST_PICKER = Flag.create((FlagGroup)NELE, (String)"state.list.picker", (String)"Enable State List Picker", (String)"Enable state list picker for selector drawable.", (boolean)true);
        NELE_ASSET_REPOSITORY_INCLUDE_AARS_THROUGH_PROJECT_SYSTEM = Flag.create((FlagGroup)NELE, (String)"asset.repository.include.aars.through.project.system", (String)"Include AARs through project system", (String)"Include resource directories from AARs found through project system.", (boolean)false);
        NELE_VISUAL_LINT = Flag.create((FlagGroup)NELE, (String)"visual.lint", (String)"Enable visual linting for layouts", (String)"Enable all the various tools related to visual linting of layouts.", (boolean)false);
        NELE_WARN_NEW_THREADS = Flag.create((FlagGroup)NELE, (String)"preview.warn.new.threads", (String)"Enable new threads warning", (String)"Display a warning if user code creates new threads in the preview", (boolean)true);
        NAV_EDITOR = new FlagGroup(FLAGS, "nav", "Navigation Editor");
        NAV_SAFE_ARGS_SUPPORT = Flag.create((FlagGroup)NAV_EDITOR, (String)"safe.args.enabled", (String)"Enable support for Safe Args", (String)"Generate in-memory Safe Args classes if the current module is using the feature.", (boolean)true);
        RES_MANAGER = new FlagGroup(FLAGS, "res.manager", "Resource Manager");
        EXTENDED_TYPE_FILTERS = Flag.create((FlagGroup)RES_MANAGER, (String)"extended.filters", (String)"Enable extended filters for resources", (String)"Adds more filter options for resources based on the selected ResourceType. Includes options to filter by resource XML tag or File extension.", (boolean)true);
        NAVIGATION_PREVIEW = Flag.create((FlagGroup)RES_MANAGER, (String)"nav.preview", (String)"Enable previews for Navigation resources", (String)"Adds a visual preview to the Navigation resources in the Resource Manager. The preview corresponds to the start destination of the graph.", (boolean)true);
        RESOURCE_REPOSITORY = new FlagGroup(FLAGS, "resource.repository", "Resource Repository");
        RESOURCE_REPOSITORY_TRACE_UPDATES = Flag.create((FlagGroup)RESOURCE_REPOSITORY, (String)"trace.updates", (String)"Enable Tracing of Resource Repository Updates", (String)"Enables tracing of resource repository updates", (boolean)false);
        RESOURCE_REPOSITORY_TRACE_SIZE = Flag.create((FlagGroup)RESOURCE_REPOSITORY, (String)"trace.size", (String)"Maximum Size of Resource Repository Update Trace", (String)"Size of the in-memory cyclic buffer used for tracing of resource repository updates", (int)10000);
        RUNDEBUG = new FlagGroup(FLAGS, "rundebug", "Run/Debug");
        RUNDEBUG_LOGCAT_CONSOLE_OUTPUT_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"logcat.console.output.enabled", (String)"Show logcat process output in Run/Debug console window", (String)"When running or debugging an Android process, output the logcat output of the process in the console window.", (boolean)true);
        RUNDEBUG_ANDROID_BUILD_BUNDLE_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"android.bundle.build.enabled", (String)"Enable the Build Bundle action", (String)("If enabled, the \"Build Bundle(s)\" menu item is enabled. Changing the value of this flag requires restarting " + ApplicationNamesInfo.getInstance().getFullProductName() + "."), (boolean)true);
        DELTA_INSTALL = Flag.create((FlagGroup)RUNDEBUG, (String)"deltainstall", (String)"Delta install", (String)"Upon installing, if application is already on device, only send parts of the apks which have changed (the delta).", (boolean)true);
        APPLY_CHANGES_OPTIMISTIC_SWAP = Flag.create((FlagGroup)RUNDEBUG, (String)"applychanges.optimisticswap", (String)"Use the 'Apply Changes 2.0' deployment pipeline", (String)"Supports Install-without-Install, Speculative Diff and Structural Redefinition", (boolean)true);
        APPLY_CHANGES_OPTIMISTIC_RESOURCE_SWAP = Flag.create((FlagGroup)RUNDEBUG, (String)"applychanges.optimisticresourceswap", (String)"Use the 'Apply Changes 2.0' deployment pipeline for full Apply Changes", (String)"Requires applychanges.optimisticswap to be true.", (boolean)true);
        OPTIMISTIC_INSTALL_SUPPORT_LEVEL = Flag.create((FlagGroup)RUNDEBUG, (String)"optimisticinstall.supportlevel", (String)"The amount of support for using the 'Apply Changes 2.0' pipeline on Run.", (String)"This can be \"DISABLED\" to always use a package manager installation; \"DEX\" to use the pipeline for dex-only changes; \"DEX_AND_NATIVE\" to use the pipeline for dex and native library-only changes; or \"DEX_AND_NATIVE_AND_RESOURCES\" to use the pipeline for changes to dex, native libraries, and/or resource/asset files. Deploying changes that exceed the level of support configured here will cause the deployment to install via the package manager.", (Enum)OptimisticInstallSupportLevel.DEX_AND_NATIVE);
        APPLY_CHANGES_STRUCTURAL_DEFINITION = Flag.create((FlagGroup)RUNDEBUG, (String)"applychanges.structuralredefinition", (String)"Use ART's new structural redefinition extension for Apply Changes.", (String)"Requires applychanges.optimisticswap to be true.", (boolean)true);
        APPLY_CHANGES_VARIABLE_REINITIALIZATION = Flag.create((FlagGroup)RUNDEBUG, (String)"applychanges.variablereinitialization", (String)"Use ART's new variable reinitializaiton extension for Apply Changes.", (String)"Requires applychanges.structuralredefinition to be true.", (boolean)true);
        APPLY_CHANGES_FAST_RESTART_ON_SWAP_FAIL = Flag.create((FlagGroup)RUNDEBUG, (String)"applychanges.swap.fastrestartonswapfail", (String)"Allow fast restart on swap failure.", (String)"Eliminate the need to build again when auto re-run checkbox is turned on.", (boolean)true);
        APPLY_CHANGES_KEEP_CONNECTION_ALIVE = Flag.create((FlagGroup)RUNDEBUG, (String)"applychanges.connection.keepalive", (String)"Keep connection to device alive.", (String)"Eliminate the cost of opening a connection and spawning a process when using Apply Changes.", (boolean)true);
        SELECT_DEVICE_SNAPSHOT_COMBO_BOX_SNAPSHOTS_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"select.device.snapshot.combo.box.snapshots.enabled", (String)"Enable Select Device/Snapshot combo box snapshots", (String)"So the new Instant Run can use the combo box", (boolean)true);
        RUN_ON_MULTIPLE_DEVICES_ACTION_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"run.on.multiple.devices.action.enabled", (String)"Enable the Run on Multiple Devices action", (String)"To revert to the 4.0 behavior until multiple devices are properly supported for the other executors", (boolean)false);
        ADB_CONNECTION_STATUS_WIDGET_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"adb.connection.status.widget.enabled", (String)"Enable and Show ADB Connection Widget", (String)"Enables and shows the ADB connection status widget in the status bar", (boolean)false);
        ADB_WIRELESS_PAIRING_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"adb.wireless.enabled", (String)"Enable pairing devices through ADB wireless", (String)"Allow pairing new physical device through QR Code pairing via ADB wireless", (boolean)false);
        WEAR_DEVICE_PAIRING_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"wear.device.pairing.enabled", (String)"Enable Wear emulator pairing assistant", (String)"Show the Wear emulator pairing assistant", (boolean)true);
        ADB_SERVER_MANAGEMENT_MODE_SETTINGS_VISIBLE = Flag.create((FlagGroup)RUNDEBUG, (String)"adb.server.management.mode.settings.visible", (String)"Show ADB server management mode settings", (String)"To allow toggling between automatic or user managed ADB server mode.", (boolean)false);
        DEFAULT_ACTIVITY_LOCATOR_STRATEGY = Flag.create((FlagGroup)RUNDEBUG, (String)"default.activity.locator.strategy", (String)"Choose a strategy for selecting the default activity to launch from the merged manifest.", (String)"This can be \"BLOCK\" to unconditionally block on a fresh merged manifest, \"STALE\" to use a potentially stale manifest, or \"INDEX\" to use the custom Android Manifest index (only select this option if manifest indexing is enabled).", (Enum)DefaultActivityLocatorStrategy.INDEX);
        DEFAULT_ACTIVITY_LOCATOR_FROM_APKS = Flag.create((FlagGroup)RUNDEBUG, (String)"default.activity.locator.sourceoftruth", (String)"Use APKs as source of truth", (String)"Open APK and parse the manifest in order to discover default activity.", (boolean)true);
        SUPPORT_FEATURE_ON_FEATURE_DEPS = Flag.create((FlagGroup)RUNDEBUG, (String)"feature.on.feature", (String)"Enable feature-on-feature dependencies", (String)"Enables Studio to understand feature-on-feature dependencies when launching dynamic apps.", (boolean)false);
        COROUTINE_DEBUGGER_ENABLE = Flag.create((FlagGroup)RUNDEBUG, (String)"coroutine.debugger.enable", (String)"Enable Coroutine Debugger", (String)"Enables the Coroutine Debugger, that shows up as a panel in the debugger when debugging an app that uses coroutines", (boolean)false);
        GRADLE_IDE = new FlagGroup(FLAGS, "gradle.ide", "Gradle Project System");
        FIX_ANDROID_RUN_CONFIGURATIONS_ENABLED = Flag.create((FlagGroup)GRADLE_IDE, (String)"gradle.run.configuration.fix.enabled", (String)"Check Android Run Configurations contains the \"Gradle-aware Make\" task and fix them", (String)"When a project is loaded, automatically add a \"Gradle-aware Make\" task to each Run Configuration if the task is missing", (boolean)true);
        NEW_PSD_ENABLED = Flag.create((FlagGroup)GRADLE_IDE, (String)"new.psd", (String)"Enable new \"Project Structure\" dialog", (String)"Turns on the new \"Project Structure\" dialog.", (boolean)true);
        USE_DEVELOPMENT_OFFLINE_REPOS = Flag.create((FlagGroup)GRADLE_IDE, (String)"development.offline.repos", (String)"Enable development offline repositories", (String)"Makes Gradle use development offline repositories such as /out/repo", (boolean)StudioPathManager.isRunningFromSources());
        BUILD_ATTRIBUTION_ENABLED = Flag.create((FlagGroup)GRADLE_IDE, (String)"build.attribution", (String)"Enable build attribution", (String)"Enable build attribution.", (boolean)true);
        AGP_UPGRADE_ASSISTANT = Flag.create((FlagGroup)GRADLE_IDE, (String)"agp.upgrade.assistant", (String)"Enable AGP Upgrade Assistant", (String)"Enable the Upgrade Assistant for helping with AGP upgrades", (boolean)true);
        AGP_UPGRADE_ASSISTANT_TOOL_WINDOW = Flag.create((FlagGroup)GRADLE_IDE, (String)"agp.upgrade.assistant.tool.window", (String)"Enable the AGP Upgrade Assistant Tool Window", (String)"Enable Tool Window-oriented interaction with the AGP Upgrade Assistant", (boolean)true);
        DISABLE_FORCED_UPGRADES = Flag.create((FlagGroup)GRADLE_IDE, (String)"forced.agp.update", (String)"Disable forced Android Gradle plugin upgrades", (String)("This option is only respected when running " + ApplicationNamesInfo.getInstance().getFullProductName() + " internally."), (boolean)false);
        USE_MODULE_PER_SOURCE_SET = Flag.create((FlagGroup)GRADLE_IDE, (String)"module.per.source.set", (String)"Enables creating multiple modules per Gradle project", (String)"This allows the IDE to more closely represent how the project is configured in Gradle.", (boolean)false);
        GRADLE_SYNC_PARALLEL_SYNC_ENABLED = Flag.create((FlagGroup)GRADLE_IDE, (String)"gradle.sync.parallel.sync.enabled", (String)"Enables parallel sync", (String)"This allows the IDE to fetch models in parallel (if supported by Gralde and enabled via org.gradle.parallel=true).", (boolean)false);
        GRADLE_SYNC_PARALLEL_SYNC_PREFETCH_VARIANTS = Flag.create((FlagGroup)GRADLE_IDE, (String)"gradle.sync.parallel.sync.prefetch.variants", (String)"Enables speculative syncing of current variants", (String)"This allows the IDE to pre-fetch models for the currently selected variants in parallel before resolving the new variant selection (which is less parallelizable process).", (boolean)false);
        GRADLE_SYNC_ENABLE_CACHED_VARIANTS = Flag.create((FlagGroup)GRADLE_IDE, (String)"gradle.sync.enable.cached.variants", (String)"Enables caching of build variants", (String)"Enables caching of build variant data so that the IDE does not always run Gradle when switching between build variants. While faster this mode may be incompatible with some plugins.", (boolean)true);
        ALLOW_DIFFERENT_JDK_VERSION = Flag.create((FlagGroup)GRADLE_IDE, (String)"jdk.allow.different", (String)"Allow different Gradle JDK", (String)"Allow usage of a different JDK version when running Gradle.", (boolean)true);
        GRADLE_SYNC_USE_V2_MODEL = Flag.create((FlagGroup)GRADLE_IDE, (String)"gradle.sync.use.v2", (String)"Use V2 Builder models", (String)"Enable fetching V2 builder models from AGP when syncing.", (boolean)false);
        GRADLE_SYNC_RECREATE_JDK = Flag.create((FlagGroup)GRADLE_IDE, (String)"gradle.sync.recreate.jdk", (String)"Recreate JDK on sync", (String)"Recreate Gradle JDK when syncing if there are changed roots.", (boolean)true);
        DATABASE_INSPECTOR = new FlagGroup(FLAGS, "database.inspector", "Database Inspector");
        DATABASE_INSPECTOR_ENABLED = Flag.create((FlagGroup)DATABASE_INSPECTOR, (String)"enabled", (String)"Enable Database Inspector", (String)"If enabled the Database Inspector tool window will appear.SQLite files opened from the Device Explorer will be opened in the inspector.", (boolean)true);
        DATABASE_INSPECTOR_OPEN_FILES_ENABLED = Flag.create((FlagGroup)DATABASE_INSPECTOR, (String)"open.files.enabled", (String)"Enable support for opening SQLite files in Database Inspector", (String)"If enabled, the Database Inspector tool will be able to open SQLite files.eg. SQLite files opened from the Device Explorer will open in the inspector.", (boolean)false);
        DATABASE_INSPECTOR_OFFLINE_MODE_ENABLED = Flag.create((FlagGroup)DATABASE_INSPECTOR, (String)"offline.enabled", (String)"Enable offline mode in Database Inspector", (String)"If enabled, Database Inspector will download a copy of open databases when the connection to the device is lost.", (boolean)true);
        DATABASE_INSPECTOR_EXPORT_TO_FILE_ENABLED = Flag.create((FlagGroup)DATABASE_INSPECTOR, (String)"export.to.file.enabled", (String)"Enable Export to File feature in Database Inspector", (String)"If enabled, Database Inspector will expose an ability for the user to export a table, query results, or the whole database to a local file.", (boolean)true);
        LAYOUT_INSPECTOR = new FlagGroup(FLAGS, "layout.inspector", "Layout Inspector");
        LAYOUT_INSPECTOR_LOAD_OVERLAY_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"load.overlay", (String)"Enable the Load Overlay feature", (String)"If enabled, show actions to let user choose overlay image on preview.", (boolean)true);
        LAYOUT_INSPECTOR_SUB_VIEW_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"sub.view", (String)"Enable the sub view feature", (String)"If enabled, changes the preview to focus on a component.", (boolean)true);
        LAYOUT_INSPECTOR_V2_PROTOCOL_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"capture.v2", (String)"Enable using V2 protocol to capture view data", (String)"If enabled, uses V2 protocol to capture view information from device.", (boolean)false);
        LAYOUT_INSPECTOR_EDITING_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"ui.editing", (String)"Enable editing ViewNode properties in the properties table.", (String)"If enabled, users can edit properties in the properties table.", (boolean)false);
        DYNAMIC_LAYOUT_INSPECTOR_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"dynamic.layout.inspector", (String)"Enable dynamic layout inspector", (String)"Turns on the dynamic layout inspector.", (boolean)true);
        DYNAMIC_LAYOUT_INSPECTOR_EDITING_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"dynamic.layout.editor", (String)"Enable dynamic layout editor", (String)"If enabled, users can edit layout properties with live updates on a device while the dynamic layout inspector is running.", (boolean)false);
        DYNAMIC_LAYOUT_INSPECTOR_USE_DEVBUILD_SKIA_SERVER = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"dynamic.layout.inspector.devbuild.skia", (String)"Use the locally-built skia rendering server", (String)"If enabled and this is a locally-built studio instance, use the locally-built skia server instead of one from the SDK.", (boolean)false);
        DYNAMIC_LAYOUT_INSPECTOR_ENABLE_COMPOSE_SUPPORT = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"dynamic.layout.inspector.compose.support", (String)"Show inspectables from Compose", (String)"If enabled the component tree will include Composable nodes if they are wrapped in an Inspectable.", (boolean)true);
        DYNAMIC_LAYOUT_INSPECTOR_USE_INSPECTION = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"dynamic.layout.inspector.use.inspection", (String)"Use app inspection client", (String)"If enabled, use a client built on the app inspection pipeline instead of the transport pipeline.", (boolean)true);
        DYNAMIC_LAYOUT_INSPECTOR_SHOW_SEMANTICS = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"dynamic.layout.inspector.show.semantics", (String)"Show semantics", (String)"If enabled, display semantic information found in the agent.", (boolean)false);
        EMBEDDED_EMULATOR = new FlagGroup(FLAGS, "embedded.emulator", "Embedded Emulator");
        EMBEDDED_EMULATOR_SCREENSHOT_STATISTICS = Flag.create((FlagGroup)EMBEDDED_EMULATOR, (String)"screenshot.statistics", (String)"Enable Collection of Screenshot Statistics", (String)"Captures statistics of received Emulator screenshots", (boolean)false);
        EMBEDDED_EMULATOR_TRACE_GRPC_CALLS = Flag.create((FlagGroup)EMBEDDED_EMULATOR, (String)"trace.grpc.calls", (String)"Enable Emulator gRPC Tracing", (String)"Enables tracing of most Emulator gRPC calls", (boolean)false);
        EMBEDDED_EMULATOR_TRACE_HIGH_VOLUME_GRPC_CALLS = Flag.create((FlagGroup)EMBEDDED_EMULATOR, (String)"trace.high.volume.grpc.calls", (String)"Enable High Volume Emulator gRPC Tracing", (String)"Enables tracing of high volume Emulator gRPC calls", (boolean)false);
        EMBEDDED_EMULATOR_TRACE_SCREENSHOTS = Flag.create((FlagGroup)EMBEDDED_EMULATOR, (String)"trace.screenshots", (String)"Enable Emulator Screenshot Tracing", (String)"Enables tracing of received Emulator screenshots", (boolean)false);
        EMBEDDED_EMULATOR_TRACE_NOTIFICATIONS = Flag.create((FlagGroup)EMBEDDED_EMULATOR, (String)"trace.notifications", (String)"Enable Emulator Notification Tracing", (String)"Enables tracing of received Emulator notifications", (boolean)false);
        EMBEDDED_EMULATOR_TRACE_DISCOVERY = Flag.create((FlagGroup)EMBEDDED_EMULATOR, (String)"trace.discovery", (String)"Enable Tracing of Emulator Discovery", (String)"Enables tracing of Emulator discovery", (boolean)false);
        REFACTORINGS = new FlagGroup(FLAGS, "refactor", "Refactor menu");
        MIGRATE_TO_RESOURCE_NAMESPACES_REFACTORING_ENABLED = Flag.create((FlagGroup)REFACTORINGS, (String)"migrateto.resourcenamespaces.enabled", (String)"Enable the Migrate to Resource Namespaces refactoring", (String)"If enabled, show the action in the refactoring menu", (boolean)false);
        MIGRATE_TO_NON_TRANSITIVE_R_CLASSES_REFACTORING_ENABLED = Flag.create((FlagGroup)REFACTORINGS, (String)"migrateto.nontransitiverclasses.enabled", (String)"Enable the Migrate to non-transitive R classes refactoring", (String)"If enabled, show the action in the refactoring menu", (boolean)true);
        IOT = new FlagGroup(FLAGS, "iot", "IoT features");
        UNINSTALL_LAUNCHER_APPS_ENABLED = Flag.create((FlagGroup)IOT, (String)"iot.uninstalllauncherapps.enabled", (String)"Enable the Uninstall of IoT launcher apps feature", (String)"If enabled, uninstall IoT launcher apps when installing a new one", (boolean)false);
        NDK = new FlagGroup(FLAGS, "ndk", "Native code features");
        CMAKE_ENABLE_FEATURES_FROM_CLION = Flag.create((FlagGroup)NDK, (String)"cmakeclionfeatures", (String)"Enable CMake language support from CLion", (String)"If enabled, language support features (e.g. syntax highlighting) currently present in CLion will be turned on.", (boolean)true);
        APK_DEBUG_BUILD_ID_CHECK = Flag.create((FlagGroup)NDK, (String)"apkdebugbuildidcheck", (String)"Enable build ID check in APK debugging", (String)"If enabled, the build ID of user-provided symbol files are compared against the binaries inside the APK.", (boolean)true);
        APK_DEBUG_RELOAD = Flag.create((FlagGroup)NDK, (String)"apkdebugreload", (String)"Enable APK reloading feature", (String)"If enabled, the user will be provided with an option to reload the APK inside an APK debugging project", (boolean)true);
        NDK_SIDE_BY_SIDE = new FlagGroup(FLAGS, "ndk.sxs", "NDK Side by Side");
        NDK_SIDE_BY_SIDE_ENABLED = Flag.create((FlagGroup)NDK_SIDE_BY_SIDE, (String)"ndk.sxs.enabled", (String)"Enable side by side NDK support", (String)"If enabled, C/C++ projects will have NDK side by side support", (boolean)true);
        USE_CONTENT_ROOTS_FOR_NATIVE_PROJECT_VIEW = Flag.create((FlagGroup)NDK, (String)"use.content.roots.for.native.project.view", (String)"Use content roots for native project view", (String)"If enabled, the C/C++ content roots are displayed in Android View and Project View. Otherwise, each individual native target is displayed.", (boolean)true);
        ENABLE_SHOW_FILES_UNKNOWN_TO_CMAKE = Flag.create((FlagGroup)NDK, (String)"ndk.projectview.showfilessunknowntocmake", (String)"Enable option to show files unknown to CMake", (String)"If enabled, for projects using CMake, Android project view menu would show an option to `Show Files Unknown To CMake`.", (boolean)true);
        ENABLE_LLDB_NATVIS = Flag.create((FlagGroup)NDK, (String)"lldb.natvis", (String)"Use NatVis visualizers in native debugger", (String)"If enabled, native debugger formats variables using NatVis files found in the project.", (boolean)true);
        EDITOR = new FlagGroup(FLAGS, "editor", "Editor features");
        COLLAPSE_ANDROID_NAMESPACE = Flag.create((FlagGroup)EDITOR, (String)"collapse.android.namespace", (String)"Collapse the android namespace in XML code completion", (String)"If enabled, XML code completion doesn't include resources from the android namespace. Instead a fake completion item is used to offer just the namespace prefix.", (boolean)true);
        ADVANCED_JNI_ASSISTANCE = Flag.create((FlagGroup)EDITOR, (String)"advanced.jni.assistance", (String)"Enable advanced JNI assistance", (String)"If enabled, additional inspection, completion, and refactoring supports are provided related to JNI. If disabled, some inspections related to JNI may stop working.", (boolean)true);
        CUSTOM_JAVA_NEW_CLASS_DIALOG = Flag.create((FlagGroup)EDITOR, (String)"custom.new.class.dialog", (String)"Enable custom New Class dialog", (String)"If enabled, our custom UI for creating a new Java class is used. Otherwise the platform default is used.", (boolean)false);
        INCREMENTAL_RESOURCE_REPOSITORIES = Flag.create((FlagGroup)EDITOR, (String)"incremental.resource.repositories", (String)"Handle PSI events incrementally in ResourceFolderRepository", (String)"If enabled, ResourceFolderRepository will handle PSI events synchronously, rather than rescanning the whole file.", (boolean)true);
        TWEAK_COLOR_SCHEME = Flag.create((FlagGroup)EDITOR, (String)"tweak.color.scheme", (String)"Change the default color scheme", (String)"If enabled, we modify the default color scheme slightly.", (boolean)true);
        SAMPLES_SUPPORT_ENABLED = Flag.create((FlagGroup)EDITOR, (String)"samples.support.enabled", (String)"Enable supports of samples (tag inside KDoc) that are used in quick documentation", (String)"Enable supports of samples (tag inside KDoc) that are used in quick documentation", (boolean)false);
        DAGGER_SUPPORT_ENABLED = Flag.create((FlagGroup)EDITOR, (String)"dagger.support.enabled", (String)"Enable editor support for Dagger", (String)"If enabled adds Dagger specific find usages, gutter icons and new parsing for Dagger errors", (boolean)true);
        UAB = new FlagGroup(FLAGS, "uab", "Unified App Bundle");
        UAB_ENABLE_NEW_INSTANT_APP_RUN_CONFIGURATIONS = Flag.create((FlagGroup)UAB, (String)"enable.ia.run.configs", (String)"Enable new instant app run configuration options", (String)"If enabled, shows the new instant app deploy checkbox in the run configuration dialog and allows new instant app deploy workflow.", (boolean)true);
        TESTING = new FlagGroup(FLAGS, "testing", "Testing support");
        PRINT_INSTRUMENTATION_STATUS = Flag.create((FlagGroup)TESTING, (String)"print.instrumentation.status", (String)"Print instrumentation status information when testing", (String)"If enabled, instrumentation output keys (from calling Instrumentation#sendStatus) that begin with 'android.studio.display.' will have their values printed after a test has finished running.", (boolean)true);
        MULTIDEVICE_INSTRUMENTATION_TESTS = Flag.create((FlagGroup)TESTING, (String)"multidevice.instrumentation.tests", (String)"Allow running instrumentation tests on multiple devices at a time.", (String)"If enabled, you can choose run-on-selected-devices for android instrumentation test run configurations.", (boolean)true);
        UTP_TEST_RESULT_SUPPORT = Flag.create((FlagGroup)TESTING, (String)"utp.instrumentation.tests", (String)"Allow importing UTP test results.", (String)"If enabled, you can import UTP test results and display them in test result panel.", (boolean)true);
        UTP_INSTRUMENTATION_TESTING = Flag.create((FlagGroup)TESTING, (String)"utp.instrumentation.testing", (String)"Run instrumentation tests via UTP", (String)"If enabled, switch to running instrumentation tests via UTP.", (boolean)false);
        MEMORY_SETTINGS = new FlagGroup(FLAGS, "memory.settings", "Memory Settings");
        LOW_IDE_XMX_CAP = Flag.create((FlagGroup)MEMORY_SETTINGS, (String)"low.ide.xmx.cap", (String)"Set low IDE Xmx cap in memory settings", (String)"If set, IDE Xmx is capped at 4GB in the configuration dialog. Otherwise, the cap is 8GB", (boolean)true);
        SYSTEM_HEALTH = new FlagGroup(FLAGS, "system.health", "System Health");
        WINDOWS_UCRT_CHECK_ENABLED = Flag.create((FlagGroup)SYSTEM_HEALTH, (String)"windows.ucrt.check.enabled", (String)"Enable Universal C Runtime system health check", (String)"If enabled, a notification will be shown if the Universal C Runtime in Windows is not installed", (boolean)false);
        ANTIVIRUS_NOTIFICATION_ENABLED = Flag.create((FlagGroup)SYSTEM_HEALTH, (String)"antivirus.notification.enabled", (String)"Enable antivirus system health check", (String)"If enabled, a notification will be shown if antivirus realtime scanning is enabled and directories relevant to build performance aren't excluded", (boolean)true);
        ANTIVIRUS_METRICS_ENABLED = Flag.create((FlagGroup)SYSTEM_HEALTH, (String)"antivirus.metrics.enabled", (String)"Enable antivirus metrics collection", (String)"If enabled, metrics about the status of antivirus realtime scanning and excluded directories will be collected", (boolean)true);
        ANTIVIRUS_CHECK_USE_REGISTRY = Flag.create((FlagGroup)SYSTEM_HEALTH, (String)"antivirus.check.registry", (String)"Use registry instead of PowerShell for checking antivirus status", (String)"If enabled, the antivirus status checker will use the Windows registry instead of PowerShell commands", (boolean)true);
        COMPOSE = new FlagGroup(FLAGS, "compose", "Compose");
        COMPOSE_PREVIEW = Flag.create((FlagGroup)COMPOSE, (String)"preview.enabled", (String)"Enable the Compose preview", (String)"If enabled, a visual preview will be available for Compose.", (boolean)true);
        COMPOSE_PREVIEW_ONLY_KOTLIN_BUILD = Flag.create((FlagGroup)COMPOSE, (String)"preview.fast.build.enabled", (String)"Enable the use of \"compileDebugKotlin\" for the preview refresh", (String)"If enabled, the refresh button will only trigger the \"compileDebugKotlin\" task as opposed to others like\"generateDebugSources\" or \"compileJava\".", (boolean)true);
        COMPOSE_PREVIEW_BUILD_ON_SAVE = Flag.create((FlagGroup)COMPOSE, (String)"preview.build.on.save.enabled", (String)"Enable the compose \"build on save\"", (String)"If enabled, the preview will automatically trigger a build after the user or IntelliJ save the documents.", (boolean)false);
        COMPOSE_PREVIEW_RUN_CONFIGURATION = Flag.create((FlagGroup)COMPOSE, (String)"preview.run.configuration", (String)"Enable running Compose Previews on device/emulator", (String)"If enabled, it will be possible to create run configurations that launch a Compose Preview directly to the device/emulator.", (boolean)true);
        COMPOSE_PREVIEW_DOUBLE_RENDER = Flag.create((FlagGroup)COMPOSE, (String)"preview.double.render", (String)"Enable the Compose double render mode", (String)"If enabled, preview components will be rendered twice so components depending on a recompose (like tableDecoration) render correctly.", (boolean)false);
        COMPOSE_PREVIEW_SCROLL_ON_CARET_MOVE = Flag.create((FlagGroup)COMPOSE, (String)"preview.scroll.on.caret.move", (String)"Enable the Compose Preview scrolling when the caret moves", (String)"If enabled, when moving the caret in the text editor, the Preview will show the preview currently under the cursor.", (boolean)true);
        COMPOSE_PREVIEW_INTERRUPTIBLE = Flag.create((FlagGroup)COMPOSE, (String)"preview.interruptible", (String)"Allows the Compose Preview to interrupt rendering calls", (String)"If enabled, if a render takes too long, the preview will be able to interrupt the execution.", (boolean)true);
        COMPOSE_EDITOR_SUPPORT = Flag.create((FlagGroup)COMPOSE, (String)"editor", (String)"Compose-specific support in the code editor", (String)"Controls whether Compose-specific editor features, like completion tweaks, are enabled. This flag has priority over all flags in the `compose.editor.*` namespace.", (boolean)true);
        COMPOSE_COMPLETION_PRESENTATION = Flag.create((FlagGroup)COMPOSE, (String)"editor.completion.presentation", (String)"Custom presentation for code completion items for composable functions", (String)"If enabled, code completion items for composable functions use a custom presentation (icon, text).", (boolean)true);
        COMPOSE_COMPLETION_WEIGHER = Flag.create((FlagGroup)COMPOSE, (String)"editor.completion.weigher", (String)"Custom weigher for Compose", (String)"If enabled, code completion puts composable functions above other completion suggestions.", (boolean)true);
        COMPOSE_COMPLETION_INSERT_HANDLER = Flag.create((FlagGroup)COMPOSE, (String)"editor.completion.insert.handler", (String)"Custom insert handler for composable functions", (String)"If enabled, code completion for composable functions uses a custom InsertHandler that inserts required parameter names.", (boolean)true);
        COMPOSE_AUTO_DOCUMENTATION = Flag.create((FlagGroup)COMPOSE, (String)"editor.auto.documentation", (String)"Show quick documentation automatically for Compose", (String)"If enabled, during code completion popup with documentation shows automatically", (boolean)true);
        COMPOSE_RENDER_SAMPLE_IN_DOCUMENTATION = Flag.create((FlagGroup)COMPOSE, (String)"editor.render.sample", (String)"Render samples of compose elements inside documentation", (String)"If enabled, adds rendered image of sample for compose element if such exists", (boolean)false);
        COMPOSE_RENDER_SAMPLE_IN_DOCUMENTATION_SLOW = Flag.create((FlagGroup)COMPOSE, (String)"editor.render.sample.slow", (String)"Slow down rendering of samples of compose elements inside documentation", (String)"If enabled, slow down rendering of samples of compose elements inside documentation, this flag is used for demonstration of non-blocking behavior", (boolean)false);
        COMPOSE_FUNCTION_EXTRACTION = Flag.create((FlagGroup)COMPOSE, (String)"editor.function.extraction", (String)"Enables extracting @Composable function from other composables", (String)"If enabled, function extracted from @Composable function will annotated @Composable", (boolean)true);
        COMPOSE_WIZARD_TEMPLATES = Flag.create((FlagGroup)COMPOSE, (String)"wizard.templates", (String)"Show Compose Wizards", (String)"If enabled, allows adding new Compose Projects/Modules/Activities through the wizards", (boolean)true);
        COMPOSE_ANIMATED_PREVIEW = Flag.create((FlagGroup)COMPOSE, (String)"preview.animated.enable", (String)"Enable animated compose preview", (String)"If enabled, a user can switch compose preview to be animated", (boolean)true);
        COMPOSE_ANIMATED_PREVIEW_SHOW_CLICK = Flag.create((FlagGroup)COMPOSE, (String)"preview.animated.click.enable", (String)"Enable displaying clicks on the animated preview", (String)"If enabled, clicking on the animated preview will generate a ripple", (boolean)true);
        COMPOSE_ANIMATION_INSPECTOR = Flag.create((FlagGroup)COMPOSE, (String)"preview.animation.inspector", (String)"Enable compose preview animation inspection", (String)"If enabled, users can inspect animations in compose previews, e.g. play/pause and jump to specific frame", (boolean)true);
        COMPOSE_ANIMATION_PREVIEW_LABEL_INSPECTION = Flag.create((FlagGroup)COMPOSE, (String)"preview.animation.label.inspection", (String)"Enable 'label' parameter inspection of Compose animations PropKeys", (String)"If enabled, show a warning when the 'label' parameter of Compose animations PropKeys are not set.", (boolean)true);
        COMPOSE_LIVE_LITERALS = Flag.create((FlagGroup)COMPOSE, (String)"preview.live.literals", (String)"Enable the live literals", (String)"If enabled, the live literals feature is enabled", (boolean)true);
        COMPOSE_DEPLOY_LIVE_LITERALS = Flag.create((FlagGroup)COMPOSE, (String)"deploy.live.literals.deploy", (String)"Enable live literals deploy", (String)"If enabled, literals within Composable functions are instantly deployed to device", (boolean)true);
        COMPOSE_LIVE_LITERALS_UPDATE_RATE = Flag.create((FlagGroup)COMPOSE, (String)"deploy.live.literals.updaterate", (String)"Update rate of live literals edits", (String)"The rate of which live literals are updated in milliseconds", (int)50);
        COMPOSE_DEBUG_BOUNDS = Flag.create((FlagGroup)COMPOSE, (String)"preview.debug.bounds", (String)"Enable the debug bounds switch controls", (String)"If enabled, the user can enable/disable the painting of debug bounds", (boolean)false);
        COMPOSE_PREVIEW_ELEMENT_PICKER = Flag.create((FlagGroup)COMPOSE, (String)"preview.element.picker.enable", (String)"Enable @Preview picker", (String)"If enabled, the picker for @Preview elements will be available", (boolean)false);
        COMPOSE_BLUEPRINT_MODE = Flag.create((FlagGroup)COMPOSE, (String)"preview.blueprint", (String)"Enable the blueprint mode for Compose previews", (String)"If enabled, the user can change the mode of Compose previews, between design and blueprint mode", (boolean)false);
        COMPOSE_QUICK_ANIMATED_PREVIEW = Flag.create((FlagGroup)COMPOSE, (String)"preview.animated.quick", (String)"Speed up transition between static and animated compose previews", (String)"If enabled, a transition between static and animated compose preview is almost instant", (boolean)true);
        NL_COLORBLIND_MODE = Flag.create((FlagGroup)COMPOSE, (String)"nl.colorblind", (String)"Enable the colorblind mode for Design Surface", (String)"If enabled, the user can change the mode of layout previews, between different types of colorblind modes", (boolean)true);
        COMPOSE_COLORBLIND_MODE = Flag.create((FlagGroup)COMPOSE, (String)"preview.colorblind", (String)"Enable the colorblind mode for Compose previews", (String)"If enabled, the user can change the mode of Compose previews, between different types of colorblind modes", (boolean)true);
        COMPOSE_PIN_PREVIEW = Flag.create((FlagGroup)COMPOSE, (String)"preview.pin.enable", (String)"Enable pinning compose previews", (String)"If enabled, a user can pin a preview", (boolean)false);
        COMPOSE_CONSTRAINT_VISUALIZATION = Flag.create((FlagGroup)COMPOSE, (String)"constraint.visualization", (String)"Enable ConstraintLayout visualization in Compose previews", (String)"If enabled, constraints from a ConstraintLayout composable will be shown in the preview", (boolean)true);
        COMPOSE_INDIVIDUAL_PIN_PREVIEW = Flag.create((FlagGroup)COMPOSE, (String)"preview.individual.pin.enable", (String)"Enable pinning of individual compose previews", (String)"If enabled, a user can pin a single preview within a file", (boolean)false);
        COMPOSE_INTERACTIVE_ANIMATION_SWITCH = Flag.create((FlagGroup)COMPOSE, (String)"preview.switch.animation.interactive", (String)"Enable animation inspection switch from interactive preview (and disable from static preview)", (String)"If enabled, a user can switch to animation inspection from interactive preview", (boolean)true);
        COMPOSE_CLASSLOADERS_PRELOADING = Flag.create((FlagGroup)COMPOSE, (String)"preview.classloaders.preloading", (String)"Enable background classes preloading", (String)"If enabled, a background classes preloading will happen to speed-up preview ClassLoader warm-up", (boolean)true);
        MANIFESTS = new FlagGroup(FLAGS, "manifests", "Android Manifests");
        ANDROID_MANIFEST_INDEX_ENABLED = Flag.create((FlagGroup)MANIFESTS, (String)"index.enabled", (String)"Enable Android Manifest Indexing", (String)"Enables a custom index for pre-parsing your project's AndroidManifest.xml files", (boolean)true);
        APP_INSPECTION = new FlagGroup(FLAGS, "appinspection", "App Inspection");
        ENABLE_APP_INSPECTION_TOOL_WINDOW = Flag.create((FlagGroup)APP_INSPECTION, (String)"enable.tool.window", (String)"Enable App Inspection Tool Window", (String)"Enables the top-level App Inspection tool window, which will contain tabs to various feature inspectors", (boolean)true);
        APP_INSPECTION_USE_DEV_JAR = Flag.create((FlagGroup)APP_INSPECTION, (String)"use.dev.jar", (String)"Use a precompiled, prebuilt inspector jar", (String)"If enabled, grab inspector jars from prebuilt locations, skipping over version checking and dynamic resolving of inspector artifacts from maven. This is useful for devs who want to load locally built inspectors.", (boolean)false);
        APP_INSPECTION_USE_SNAPSHOT_JAR = Flag.create((FlagGroup)APP_INSPECTION, (String)"use.snapshot.jar", (String)"Always extract latest inspector jar from library", (String)"If enabled, override normal inspector resolution logic, instead searching the IDE cache directly. This allows finding inspectors bundled in local, snapshot builds of Android libraries, as opposed to those released through the normal process on maven.", (boolean)false);
        WORK_MANAGER_INSPECTOR = new FlagGroup(FLAGS, "work.inspector", "WorkManager Inspector");
        ENABLE_WORK_MANAGER_INSPECTOR_TAB = Flag.create((FlagGroup)WORK_MANAGER_INSPECTOR, (String)"enable.tab", (String)"Enable WorkManager Inspector Tab", (String)"Enables a WorkManager Inspector Tab in the App Inspection tool window", (boolean)true);
        ENABLE_WORK_MANAGER_GRAPH_VIEW = Flag.create((FlagGroup)WORK_MANAGER_INSPECTOR, (String)"enable.graph.view", (String)"Enable WorkManager Graph View", (String)"Enables a Graph View for visualizing work dependencies in the WorkManager Inspector Tab", (boolean)true);
        NETWORK_INSPECTOR = new FlagGroup(FLAGS, "network.inspector", "Network Inspector");
        ENABLE_NETWORK_MANAGER_INSPECTOR_TAB = Flag.create((FlagGroup)NETWORK_INSPECTOR, (String)"enable.network.inspector.tab", (String)"Enable Network Inspector Tab", (String)"Enables a Network Inspector Tab in the App Inspection tool window", (boolean)false);
        BACKGROUND_TASK_INSPECTOR = new FlagGroup(FLAGS, "backgroundtask.inspector", "BackgroundTask Inspector");
        ENABLE_BACKGROUND_TASK_INSPECTOR_TAB = Flag.create((FlagGroup)BACKGROUND_TASK_INSPECTOR, (String)"enable.backgroundtask.inspector.tab", (String)"Enable BackgroundTask Inspector Tab", (String)"Enables a BackgroundTask Inspector Tab in the App Inspection tool window", (boolean)false);
        DEVICE_MANAGER = new FlagGroup(FLAGS, "device.manager", "Device Manager");
        ENABLE_NEW_DEVICE_MANAGER_PANEL = Flag.create((FlagGroup)DEVICE_MANAGER, (String)"enable.device.manager", (String)"Enable new Device Manager panel", (String)"Enables the new Device Manager panel on the right. It will be a replacement for an AVD manager with additional functionality", (boolean)false);
        ENABLE_DEVICE_MANAGER_GROUPS = Flag.create((FlagGroup)DEVICE_MANAGER, (String)"enable.device.manager.groups", (String)"Enable groups tab", (String)"Enables the device groups tab in the new Device Manager", (boolean)false);
        SUGGESTED_IMPORT = new FlagGroup(FLAGS, "suggested.import", "Suggested import");
        ENABLE_SUGGESTED_IMPORT = Flag.create((FlagGroup)SUGGESTED_IMPORT, (String)"enable", (String)"Enable suggested import", (String)"Enables the code path where we get indices from dl.google.com/android/studio/gmaven/index/... and generate corresponding lookup table from class names to GMaven coordinates. It will be a replacement for the hardcoded mapping data in MavenClassRegistryFromHardcodedMap.", (boolean)true);
        DDMLIB = new FlagGroup(FLAGS, "ddmlib", "DDMLIB");
        ENABLE_JDWP_PROXY_SERVICE = Flag.create((FlagGroup)DDMLIB, (String)"enable.jdwp.proxy.service", (String)"Enable jdwp proxy service", (String)"Creates a proxy service within DDMLIB to allow shared device client connections.", (boolean)false);
        SERVER_FLAGS = new FlagGroup(FLAGS, "serverflags", "Server Flags");
        TEST_SERVER_FLAG = Flag.create((FlagGroup)SERVER_FLAGS, (String)"test", (String)"Test Server Enabled Flag", (String)"Creates a sample studio flag that can be set using a server flag", (boolean)false);
    }

    public static enum DefaultActivityLocatorStrategy {
        BLOCK,
        INDEX,
        STALE;

    }

    public static enum OptimisticInstallSupportLevel {
        DISABLED,
        DEX,
        DEX_AND_NATIVE,
        DEX_AND_NATIVE_AND_RESOURCES;

    }
}

