/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.lint.common.LintBundle;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintBaseline;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.TextFormat;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import org.jetbrains.annotations.NotNull;

public class AndroidLintLintBaselineInspection
extends AndroidLintInspectionBase {
    public static boolean ourSkipBaselineNextRun;
    public static boolean ourUpdateBaselineNextRun;
    public static AnalysisScope ourRerunScope;

    public AndroidLintLintBaselineInspection() {
        super(LintBundle.message("android.lint.inspections.lint.baseline", new Object[0]), IssueRegistry.BASELINE);
    }

    @Override
    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, LintFix fixData) {
        if (startElement == null) {
            AndroidLintLintBaselineInspection.$$$reportNull$$$0(0);
        }
        if (endElement == null) {
            AndroidLintLintBaselineInspection.$$$reportNull$$$0(1);
        }
        if (message == null) {
            AndroidLintLintBaselineInspection.$$$reportNull$$$0(2);
        }
        if (LintBaseline.Companion.isFilteredMessage(message, TextFormat.RAW)) {
            LintIdeQuickFix[] lintIdeQuickFixArray = new LintIdeQuickFix[]{new DefaultLintQuickFix("Temporarily turn off the baseline and re-run the analysis"){

                @Override
                public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
                    if (startElement == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (endElement == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (context == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    ourSkipBaselineNextRun = true;
                    AndroidLintLintBaselineInspection.rerun();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "startElement";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "endElement";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "context";
                            break;
                        }
                    }
                    objectArray[1] = "com/android/tools/idea/lint/common/AndroidLintLintBaselineInspection$1";
                    objectArray[2] = "apply";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }};
            if (lintIdeQuickFixArray == null) {
                AndroidLintLintBaselineInspection.$$$reportNull$$$0(3);
            }
            return lintIdeQuickFixArray;
        }
        if (LintBaseline.Companion.isFixedMessage(message, TextFormat.RAW)) {
            LintIdeQuickFix[] lintIdeQuickFixArray = new LintIdeQuickFix[]{new DefaultLintQuickFix("Update baseline file to remove fixed issues"){

                @Override
                public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
                    if (startElement == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (endElement == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (context == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    ourUpdateBaselineNextRun = true;
                    AndroidLintLintBaselineInspection.rerun();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "startElement";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "endElement";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "context";
                            break;
                        }
                    }
                    objectArray[1] = "com/android/tools/idea/lint/common/AndroidLintLintBaselineInspection$2";
                    objectArray[2] = "apply";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }};
            if (lintIdeQuickFixArray == null) {
                AndroidLintLintBaselineInspection.$$$reportNull$$$0(4);
            }
            return lintIdeQuickFixArray;
        }
        LintIdeQuickFix[] lintIdeQuickFixArray = super.getQuickFixes(startElement, endElement, message, fixData);
        if (lintIdeQuickFixArray == null) {
            AndroidLintLintBaselineInspection.$$$reportNull$$$0(5);
        }
        return lintIdeQuickFixArray;
    }

    private static void rerun() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (Frame frame : Frame.getFrames()) {
                InspectionResultsView view = AndroidLintLintBaselineInspection.findInspectionView(frame);
                if (view == null || !view.isRerunAvailable() || view.isDisposed()) continue;
                ourRerunScope = view.getScope();
                view.rerun();
            }
        });
    }

    public static void clearNextRunState() {
        ourSkipBaselineNextRun = false;
        ourUpdateBaselineNextRun = false;
        ourRerunScope = null;
    }

    private static InspectionResultsView findInspectionView(Container container) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            InspectionResultsView view;
            Component component = container.getComponent(i);
            if (component instanceof InspectionResultsView) {
                return (InspectionResultsView)component;
            }
            if (!(component instanceof Container) || (view = AndroidLintLintBaselineInspection.findInspectionView((Container)component)) == null) continue;
            return view;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/common/AndroidLintLintBaselineInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/common/AndroidLintLintBaselineInspection";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

