/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\rJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001d\u0010\u0015\u001a\u00020\u000f2\u000b\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\u001a\u001a\u00020\u0005H\u0016J \u0010\u001b\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/lint/common/CreateFileQuickFix;", "Lcom/android/tools/idea/lint/common/LintIdeQuickFix;", "myFile", "Ljava/io/File;", "myText", "", "myBinary", "", "mySelectPattern", "myFormat", "", "myDisplayName", "myFamilyName", "(Ljava/io/File;Ljava/lang/String;[BLjava/lang/String;ZLjava/lang/String;Ljava/lang/String;)V", "apply", "", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "context", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$Context;", "createFile", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "getFamilyName", "getName", "isApplicable", "contextType", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$ContextType;", "intellij.android.lint"})
public final class CreateFileQuickFix
implements LintIdeQuickFix {
    private final File myFile;
    private final String myText;
    private final byte[] myBinary;
    private final String mySelectPattern;
    private final boolean myFormat;
    private final String myDisplayName;
    private final String myFamilyName;

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Project project = startElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"startElement.project");
        Project project2 = project;
        if (LocalFileSystem.getInstance().findFileByIoFile(this.myFile) != null) {
            boolean $i$f$isUnitTestMode = false;
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isUnitTestMode()) {
                if (Messages.showYesNoDialog((Project)project2, (String)(this.myFile.getName() + " already exists; do you want to replace it?"), (String)"Replace File", null) == 0) {
                    this.createFile(project2, context);
                }
                return;
            }
        }
        this.createFile(project2, context);
    }

    private final void createFile(Project project, AndroidQuickfixContexts.Context context) {
        try {
            Pattern pattern;
            Matcher matcher;
            File file = this.myFile.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"myFile.parentFile");
            VirtualFile virtualFile = VfsUtil.createDirectoryIfMissing((String)file.getPath());
            if (virtualFile == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"VfsUtil.createDirectoryI\u2026arentFile.path) ?: return");
            VirtualFile parent = virtualFile;
            if (this.myBinary == null && this.myText == null) {
                VirtualFile virtualFile2 = VfsUtil.findFileByIoFile((File)this.myFile, (boolean)false);
                if (virtualFile2 != null) {
                    virtualFile2.delete((Object)this);
                }
                return;
            }
            VirtualFile virtualFile3 = parent.createChildData((Object)this, this.myFile.getName());
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"parent.createChildData(this, myFile.name)");
            VirtualFile newFile = virtualFile3;
            if (this.myBinary != null) {
                newFile.setBinaryContent(this.myBinary);
                return;
            }
            Intrinsics.checkNotNull((Object)this.myText);
            String string = this.myText;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            newFile.setBinaryContent(byArray);
            if (this.myFormat) {
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(newFile);
                if (psiFile != null) {
                    String it = string = psiFile;
                    boolean bl = false;
                    CodeStyleManager.getInstance((Project)project).reformat((PsiElement)it);
                }
            }
            if (!(context instanceof AndroidQuickfixContexts.EditorContext)) {
                return;
            }
            FileEditorManager manager = FileEditorManager.getInstance((Project)project);
            manager.openFile(newFile, true, true);
            if (this.mySelectPattern != null && (matcher = (pattern = Pattern.compile(this.mySelectPattern)).matcher(this.myText)).find()) {
                int selectStart = 0;
                int selectEnd = 0;
                if (matcher.groupCount() > 0) {
                    selectStart = matcher.start(1);
                    selectEnd = matcher.end(1);
                } else {
                    selectStart = matcher.start();
                    selectEnd = matcher.end();
                }
                Editor editor = ((AndroidQuickfixContexts.EditorContext)context).getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"context.editor");
                Editor editor2 = editor;
                editor2.getSelectionModel().setSelection(selectStart, selectEnd);
            }
        }
        catch (IOException e) {
            Logger.getInstance(CreateFileQuickFix.class).error((Throwable)e);
        }
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Intrinsics.checkNotNullParameter((Object)contextType, (String)"contextType");
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myDisplayName;
    }

    @Override
    @Nullable
    public String getFamilyName() {
        return this.myFamilyName;
    }

    public CreateFileQuickFix(@NotNull File myFile, @Nullable String myText, @Nullable byte[] myBinary, @Nullable String mySelectPattern, boolean myFormat, @NotNull String myDisplayName, @Nullable String myFamilyName) {
        Intrinsics.checkNotNullParameter((Object)myFile, (String)"myFile");
        Intrinsics.checkNotNullParameter((Object)myDisplayName, (String)"myDisplayName");
        this.myFile = myFile;
        this.myText = myText;
        this.myBinary = myBinary;
        this.mySelectPattern = mySelectPattern;
        this.myFormat = myFormat;
        this.myDisplayName = myDisplayName;
        this.myFamilyName = myFamilyName;
    }
}

