/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.AbstractResourceRepository;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.DomPsiParser;
import com.android.tools.idea.lint.common.LintBatchResult;
import com.android.tools.idea.lint.common.LintEditorResult;
import com.android.tools.idea.lint.common.LintIdeConfiguration;
import com.android.tools.idea.lint.common.LintIdeGradleConfiguration;
import com.android.tools.idea.lint.common.LintIdeGradleVisitor;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.idea.lint.common.LintIgnoredResult;
import com.android.tools.idea.lint.common.LintProblemData;
import com.android.tools.idea.lint.common.LintResult;
import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.ConfigurationHierarchy;
import com.android.tools.lint.client.api.GradleVisitor;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Constraint;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.tools.lint.helpers.DefaultJavaEvaluator;
import com.android.tools.lint.helpers.DefaultUastParser;
import com.android.tools.lint.model.LintModelLintOptions;
import com.android.tools.lint.model.LintModelModule;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.io.Files;
import com.intellij.analysis.AnalysisScope;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.util.PathUtil;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.net.HttpConfigurable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LintIdeClient
extends LintClient
implements Disposable {
    public static final boolean SUPPORT_CLASS_FILES = false;
    protected static final Logger LOG;
    protected com.intellij.openapi.project.Project myProject;
    @Nullable
    protected Map<Project, Module> myModuleMap;
    protected final LintResult myLintResult;
    @Nullable
    private static volatile String ourSystemPath;

    public LintIdeClient(com.intellij.openapi.project.Project project, LintResult lintResult) {
        super("studio");
        this.myProject = project;
        this.myLintResult = lintResult;
    }

    public LintDriver createDriver(LintRequest request) {
        return this.createDriver(request, LintIdeSupport.get().getIssueRegistry());
    }

    public LintDriver createDriver(LintRequest request, IssueRegistry registry) {
        Project main;
        LintModelModule model;
        LintDriver driver = new LintDriver(registry, (LintClient)this, request);
        Collection projects = request.getProjects();
        if (projects != null && !projects.isEmpty() && (model = (main = request.getMainProject((Project)projects.iterator().next())).getBuildModule()) != null) {
            try {
                LintModelLintOptions lintOptions = model.getLintOptions();
                driver.setCheckTestSources(lintOptions.getCheckTestSources());
                driver.setCheckDependencies(lintOptions.getCheckDependencies());
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return driver;
    }

    public ResourceRepository getResources(Project project, ResourceRepositoryScope scope) {
        return new AbstractResourceRepository(){

            protected ListMultimap<String, ResourceItem> getResourcesInternal(ResourceNamespace namespace, ResourceType resourceType) {
                return ImmutableListMultimap.of();
            }

            public ResourceVisitor.VisitResult accept(ResourceVisitor visitor) {
                return ResourceVisitor.VisitResult.ABORT;
            }

            public Collection<ResourceItem> getPublicResources(ResourceNamespace namespace, ResourceType type) {
                return Collections.emptyList();
            }

            public Set<ResourceNamespace> getNamespaces() {
                return Collections.emptySet();
            }

            public Collection<SingleNamespaceResourceRepository> getLeafResourceRepositories() {
                return Collections.emptyList();
            }
        };
    }

    @Nullable
    public static ApiLookup getApiLookup(com.intellij.openapi.project.Project project) {
        return ApiLookup.get((LintClient)LintIdeSupport.get().createClient(project, new LintIgnoredResult()));
    }

    public void runReadAction(Runnable runnable) {
        if (!(this.myLintResult instanceof LintEditorResult)) {
            ApplicationManager.getApplication().runReadAction(runnable);
            return;
        }
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            application.runReadAction(runnable);
            return;
        }
        long startMs = System.currentTimeMillis();
        boolean success = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority((Runnable)runnable);
        long elapsedMs = System.currentTimeMillis() - startMs;
        if (elapsedMs >= 20000L) {
            LOG.warn("Android Lint took a long time to run a read action (" + elapsedMs + " ms)");
        }
        if (!success) {
            throw new ProcessCanceledException();
        }
    }

    public <T> T runReadAction(Computable<T> computable) {
        if (this.myLintResult instanceof LintEditorResult) {
            Ref res = new Ref();
            this.runReadAction(() -> res.set(computable.compute()));
            return (T)res.get();
        }
        return (T)ApplicationManager.getApplication().runReadAction(computable);
    }

    public com.intellij.openapi.project.Project getIdeProject() {
        return this.myProject;
    }

    @Nullable
    protected Module findModuleForLintProject(com.intellij.openapi.project.Project project, Project lintProject) {
        Module module;
        if (this.myModuleMap != null && (module = this.myModuleMap.get(lintProject)) != null) {
            return module;
        }
        File dir = lintProject.getDir();
        VirtualFile vDir = LocalFileSystem.getInstance().findFileByIoFile(dir);
        return vDir != null ? ModuleUtilCore.findModuleForFile((VirtualFile)vDir, (com.intellij.openapi.project.Project)project) : null;
    }

    public void setModuleMap(@Nullable Map<Project, Module> moduleMap) {
        this.myModuleMap = moduleMap;
    }

    public Configuration getConfiguration(Project project, @Nullable LintDriver driver) {
        return this.getConfigurations().getConfigurationForProject(project, (file, defaultConfiguration) -> this.createConfiguration(project, (Configuration)defaultConfiguration));
    }

    private Configuration createConfiguration(Project project, Configuration defaultConfiguration) {
        LintModelModule model = project.getBuildModule();
        ConfigurationHierarchy configurations = this.getConfigurations();
        if (model != null) {
            LintModelLintOptions options = model.getLintOptions();
            return configurations.createLintOptionsConfiguration(project, options, false, defaultConfiguration, () -> new LintIdeGradleConfiguration(configurations, options, this.getIssues()));
        }
        return new LintIdeConfiguration(configurations, project, this.getIssues());
    }

    public void report(@NotNull Context context, @NotNull Incident incident, @NotNull Constraint constraint) {
        if (context == null) {
            LintIdeClient.$$$reportNull$$$0(0);
        }
        if (incident == null) {
            LintIdeClient.$$$reportNull$$$0(1);
        }
        if (constraint == null) {
            LintIdeClient.$$$reportNull$$$0(2);
        }
        assert (false);
    }

    public void report(@NotNull Context context, @NotNull Incident incident, @NotNull LintMap map) {
        if (context == null) {
            LintIdeClient.$$$reportNull$$$0(3);
        }
        if (incident == null) {
            LintIdeClient.$$$reportNull$$$0(4);
        }
        if (map == null) {
            LintIdeClient.$$$reportNull$$$0(5);
        }
        assert (false);
    }

    public void report(@NotNull Context context, @NotNull Incident incident, @NotNull TextFormat format) {
        if (context == null) {
            LintIdeClient.$$$reportNull$$$0(6);
        }
        if (incident == null) {
            LintIdeClient.$$$reportNull$$$0(7);
        }
        if (format == null) {
            LintIdeClient.$$$reportNull$$$0(8);
        }
        if (this.myLintResult instanceof LintEditorResult) {
            this.report((LintEditorResult)this.myLintResult, context, incident, format);
        } else if (this.myLintResult instanceof LintBatchResult) {
            this.report((LintBatchResult)this.myLintResult, context, incident, format);
        } else if (!(this.myLintResult instanceof LintIgnoredResult)) assert (false) : incident.getMessage();
    }

    public void report(LintEditorResult lintResult, Context context, Incident incident, TextFormat format) {
        Location secondary;
        Issue issue = incident.getIssue();
        Severity severity = incident.getSeverity();
        Location location = incident.getLocation();
        String message = incident.getMessage();
        LintFix quickfixData = incident.getFix();
        File file = location.getFile();
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
        if (lintResult.getMainFile().equals(vFile)) {
            Position start = location.getStart();
            Position end = location.getEnd();
            TextRange textRange = start != null && end != null && start.getOffset() <= end.getOffset() ? new TextRange(start.getOffset(), end.getOffset()) : TextRange.EMPTY_RANGE;
            Severity configuredSeverity = severity != issue.getDefaultSeverity() ? severity : null;
            message = format.convertTo(message, TextFormat.RAW);
            lintResult.getProblems().add(new LintProblemData(issue, message, textRange, configuredSeverity, quickfixData));
        }
        if ((secondary = location.getSecondary()) != null && lintResult.getMainFile().equals(LocalFileSystem.getInstance().findFileByIoFile(secondary.getFile()))) {
            this.reportSecondary(context, issue, severity, location, message, format, quickfixData);
        }
    }

    public void report(LintBatchResult state, Context context, Incident incident, TextFormat format) {
        boolean inScope;
        Issue issue = incident.getIssue();
        Severity severity = incident.getSeverity();
        Location location = incident.getLocation();
        String message = incident.getMessage();
        LintFix quickfixData = incident.getFix();
        AnalysisScope scope = state.getScope();
        Map<Issue, Map<File, List<LintProblemData>>> myProblemMap = state.getProblemMap();
        File file = location.getFile();
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
        boolean bl = inScope = vFile != null && scope.contains(vFile);
        if (!inScope && vFile != null && vFile.isDirectory()) {
            Module module;
            if (scope.getScopeType() == 1) {
                inScope = true;
            } else if ((scope.getScopeType() == 4 || scope.getScopeType() == 7) && (module = this.findModuleForLintProject(this.myProject, context.getProject())) != null && scope.containsModule(module)) {
                inScope = true;
            }
        }
        if (inScope) {
            List<LintProblemData> problemList;
            file = new File(PathUtil.getCanonicalPath((String)file.getPath()));
            Map<File, List<LintProblemData>> file2ProblemList = myProblemMap.get(issue);
            if (file2ProblemList == null) {
                file2ProblemList = new HashMap<File, List<LintProblemData>>();
                myProblemMap.put(issue, file2ProblemList);
            }
            if ((problemList = file2ProblemList.get(file)) == null) {
                problemList = new ArrayList<LintProblemData>();
                file2ProblemList.put(file, problemList);
            }
            TextRange textRange = TextRange.EMPTY_RANGE;
            Position start = location.getStart();
            Position end = location.getEnd();
            if (start != null && end != null && start.getOffset() <= end.getOffset()) {
                textRange = new TextRange(start.getOffset(), end.getOffset());
            }
            Severity configuredSeverity = severity != issue.getDefaultSeverity() ? severity : null;
            message = format.convertTo(message, TextFormat.RAW);
            problemList.add(new LintProblemData(issue, message, textRange, configuredSeverity, quickfixData));
            if (location.getSecondary() != null) {
                this.reportSecondary(context, issue, severity, location, message, format, quickfixData);
            }
        }
        AndroidLintInspectionBase.getInspectionShortNameByIssue(this.myProject, issue);
    }

    protected void reportSecondary(Context context, Issue issue, Severity severity, Location location, String message, TextFormat format, @Nullable LintFix extraData) {
        Location secondary = location.getSecondary();
        if (secondary != null && secondary.getVisible()) {
            String secondaryMessage = secondary.getMessage();
            if (secondaryMessage != null) {
                message = secondary.isSelfExplanatory() ? secondaryMessage : (String)message + " (" + secondaryMessage + ")";
            }
            this.report(context, issue, severity, secondary, (String)message, format, extraData);
        }
    }

    protected Set<Issue> getIssues() {
        return this.myLintResult.getIssues();
    }

    @Nullable
    protected Module getModule() {
        return this.myLintResult.getModule();
    }

    @Nullable
    protected Module getModule(Project project) {
        Module module = this.findModuleForLintProject(this.getIdeProject(), project);
        if (module != null) {
            return module;
        }
        return this.getModule();
    }

    public void log(Severity severity, @Nullable Throwable exception, @Nullable String format, Object ... args) {
        if (severity == Severity.ERROR || severity == Severity.FATAL) {
            if (format != null) {
                LOG.error(String.format(format, args), exception);
            } else if (exception != null) {
                LOG.error(exception);
            }
        } else if (severity == Severity.WARNING) {
            if (format != null) {
                LOG.warn(String.format(format, args), exception);
            } else if (exception != null) {
                LOG.warn(exception);
            }
        } else if (format != null) {
            LOG.info(String.format(format, args), exception);
        } else if (exception != null) {
            LOG.info(exception);
        }
    }

    public XmlParser getXmlParser() {
        return new DomPsiParser(this);
    }

    public UastParser getUastParser(@Nullable Project project) {
        return new DefaultUastParser(project, this.myProject){

            protected DefaultJavaEvaluator createEvaluator(@Nullable Project project, com.intellij.openapi.project.Project p) {
                return new DefaultJavaEvaluator(p, project){

                    @Nullable
                    public PsiPackage getPackage(PsiElement node) {
                        PsiDirectory dir;
                        PsiFile containingFile = node.getContainingFile();
                        if (containingFile != null && (dir = containingFile.getParent()) != null) {
                            return JavaDirectoryService.getInstance().getPackage(dir);
                        }
                        return null;
                    }
                };
            }
        };
    }

    public GradleVisitor getGradleVisitor() {
        return new LintIdeGradleVisitor();
    }

    public List<File> getJavaClassFolders(Project project) {
        return Collections.emptyList();
    }

    public List<File> getJavaLibraries(Project project, boolean includeProvided) {
        return Collections.emptyList();
    }

    public List<File> getTestLibraries(Project project) {
        return Collections.emptyList();
    }

    public String readFile(File file) {
        ProgressManager.checkCanceled();
        if (this.myLintResult instanceof LintEditorResult) {
            return this.readFile((LintEditorResult)this.myLintResult, file);
        }
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
        if (vFile == null) {
            LOG.debug("Cannot find file " + file.getPath() + " in the VFS");
            return "";
        }
        return (String)this.runReadAction(() -> {
            Document document = FileDocumentManager.getInstance().getDocument(vFile);
            if (document == null) {
                LOG.info("Cannot create document for file " + file.getPath());
                return null;
            }
            return document.getText();
        });
    }

    private String readFile(LintEditorResult lintEditorResult, File file) {
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
        if (vFile == null) {
            try {
                return Files.asCharSource((File)file, (Charset)Charsets.UTF_8).read();
            }
            catch (IOException ioe) {
                LOG.debug("Cannot find file " + file.getPath() + " in the VFS");
                return "";
            }
        }
        String content = this.getFileContent(lintEditorResult, vFile);
        if (content == null) {
            LOG.info("Cannot find file " + file.getPath() + " in the PSI");
            return "";
        }
        return content;
    }

    public byte @NotNull [] readBytes(@NotNull File file) throws IOException {
        if (file == null) {
            LintIdeClient.$$$reportNull$$$0(9);
        }
        ProgressManager.checkCanceled();
        byte[] byArray = super.readBytes(file);
        if (byArray == null) {
            LintIdeClient.$$$reportNull$$$0(10);
        }
        return byArray;
    }

    public byte @NotNull [] readBytes(@NotNull PathString resourcePath) throws IOException {
        if (resourcePath == null) {
            LintIdeClient.$$$reportNull$$$0(11);
        }
        ProgressManager.checkCanceled();
        byte[] byArray = super.readBytes(resourcePath);
        if (byArray == null) {
            LintIdeClient.$$$reportNull$$$0(12);
        }
        return byArray;
    }

    @Nullable
    private String getFileContent(final LintEditorResult lintResult, VirtualFile vFile) {
        if (Objects.equals(lintResult.getMainFile(), vFile)) {
            return lintResult.getMainFileContent();
        }
        return (String)this.runReadAction(() -> {
            Document document = FileDocumentManager.getInstance().getDocument(vFile);
            if (document == null) {
                return null;
            }
            DocumentListener listener = new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent event) {
                    if (event == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    lintResult.markDirty();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/lint/common/LintIdeClient$3", "documentChanged"));
                }
            };
            document.addDocumentListener(listener, (Disposable)this);
            return document.getText();
        });
    }

    public void dispose() {
        this.myProject = null;
        this.myModuleMap = null;
    }

    @Nullable
    public String getClientDisplayRevision() {
        return ApplicationInfoEx.getInstanceEx().getFullVersion();
    }

    @Nullable
    public String getClientRevision() {
        return ApplicationInfoEx.getInstanceEx().getStrictVersion();
    }

    public String getClientDisplayName() {
        return ApplicationNamesInfo.getInstance().getFullProductName();
    }

    @Nullable
    public File getCacheDir(@Nullable String name, boolean create) {
        String path = ourSystemPath != null ? ourSystemPath : (ourSystemPath = PathUtil.getCanonicalPath((String)PathManager.getSystemPath()));
        Object relative = "lint";
        if (name != null) {
            relative = (String)relative + File.separator + name;
        }
        File lint = new File(path, (String)relative);
        if (create && !lint.exists()) {
            lint.mkdirs();
        }
        return lint;
    }

    public boolean isProjectDirectory(File dir) {
        return new File(dir, ".idea").exists();
    }

    @Nullable
    public String getRelativePath(@Nullable File baseFile, @Nullable File file) {
        return FileUtilRt.getRelativePath((File)baseFile, (File)file);
    }

    public List<File> getJavaSourceFolders(Project project) {
        Module module = this.getModule(project);
        if (module == null && (module = this.findModuleForLintProject(this.myProject, project)) == null) {
            return Collections.emptyList();
        }
        VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots(false);
        ArrayList<File> result = new ArrayList<File>(sourceRoots.length);
        for (VirtualFile root : sourceRoots) {
            result.add(new File(root.getPath()));
        }
        return result;
    }

    @Nullable
    public URLConnection openConnection(URL url) throws IOException {
        return HttpConfigurable.getInstance().openConnection(url.toExternalForm());
    }

    @Nullable
    public URLConnection openConnection(URL url, int timeout) throws IOException {
        URLConnection connection = HttpConfigurable.getInstance().openConnection(url.toExternalForm());
        if (timeout > 0) {
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
        }
        return connection;
    }

    public ClassLoader createUrlClassLoader(URL[] urls, ClassLoader parent) {
        return UrlClassLoader.build().parent(parent).files(Arrays.stream(urls).map(it -> Paths.get(it.getPath(), new String[0])).collect(Collectors.toList())).get();
    }

    static {
        LintClient.setClientName((String)"studio");
        LOG = Logger.getInstance(LintIdeClient.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "incident";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/common/LintIdeClient";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/common/LintIdeClient";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "readBytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "report";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readBytes";
                break;
            }
            case 10: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

