/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.lint.detector.api.LintFix;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.psi.KtElement;

public class ReplaceStringQuickFix
implements LintIdeQuickFix {
    private final String myName;
    private final String myFamilyName;
    @RegExp
    private final String myRegexp;
    private final String myNewValue;
    private boolean myShortenNames;
    private boolean myFormat;
    private SmartPsiFileRange myRange;
    private String myExpandedNewValue;
    private String mySelectPattern;

    public ReplaceStringQuickFix(@Nullable String name, @Nullable String familyName, @Nullable @RegExp String regexp, @NotNull String newValue) {
        if (newValue == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(0);
        }
        this.myName = name;
        this.myFamilyName = familyName;
        this.myNewValue = newValue;
        if (regexp != null && ((String)regexp).indexOf(40) == -1 && !((String)regexp).equals("_lint_insert_begin_") && !((String)regexp).equals("_lint_insert_end_")) {
            regexp = "(" + Pattern.quote((String)regexp) + ")";
        }
        this.myRegexp = regexp;
    }

    public ReplaceStringQuickFix setShortenNames(boolean shortenNames) {
        this.myShortenNames = shortenNames;
        return this;
    }

    public ReplaceStringQuickFix setFormat(boolean format) {
        this.myFormat = format;
        return this;
    }

    public ReplaceStringQuickFix setSelectPattern(String selectPattern) {
        this.mySelectPattern = selectPattern;
        return this;
    }

    public void setRange(SmartPsiFileRange range) {
        this.myRange = range;
    }

    @Override
    @NotNull
    public String getName() {
        if (this.myName == null) {
            if (this.myNewValue.isEmpty()) {
                return "Delete";
            }
            String string = "Replace with " + this.myNewValue;
            if (string == null) {
                ReplaceStringQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = this.myName;
        if (string == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    public String getFamilyName() {
        return this.myFamilyName;
    }

    @Nullable
    protected String getNewValue() {
        return this.myExpandedNewValue != null ? this.myExpandedNewValue : this.myNewValue;
    }

    protected void editBefore(@NotNull Document document) {
        if (document == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(3);
        }
    }

    protected void editAfter(@NotNull Document document) {
        if (document == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(4);
        }
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        if (startElement == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(5);
        }
        if (endElement == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(6);
        }
        if (context == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(7);
        }
        PsiFile file = startElement.getContainingFile();
        if (this.myRange != null && (file = this.myRange.getContainingFile()) == null) {
            return;
        }
        Project project = startElement.getProject();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = documentManager.getDocument(file);
        if (document != null) {
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            this.editBefore(document);
            TextRange range = this.getRange(startElement, endElement, true);
            if (range != null) {
                Pattern pattern;
                Matcher matcher;
                String newValue = this.getNewValue();
                if (newValue == null) {
                    newValue = "";
                }
                if (ReplaceStringQuickFix.whitespaceOnly(newValue)) {
                    range = ReplaceStringQuickFix.includeFullLineIfOnlySpace(document, range);
                }
                int startOffset = range.getStartOffset();
                int endOffset = range.getEndOffset();
                document.replaceString(startOffset, endOffset, (CharSequence)newValue);
                endOffset = startOffset + newValue.length();
                this.editAfter(document);
                if (this.myShortenNames || this.myFormat) {
                    documentManager.commitDocument(document);
                    PsiElement element = file.findElementAt(startOffset);
                    if (element == null) {
                        return;
                    }
                    if (this.myShortenNames) {
                        Object parent;
                        PsiElement end = file.findElementAt(endOffset);
                        PsiElement psiElement = parent = end != null ? PsiTreeUtil.findCommonParent((PsiElement)element.getParent(), (PsiElement)end) : element.getParent();
                        if (parent == null) {
                            parent = element.getParent();
                        }
                        parent = element.getLanguage() == JavaLanguage.INSTANCE ? JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(parent) : (element.getLanguage() == KotlinLanguage.INSTANCE && parent instanceof KtElement ? ShortenReferences.DEFAULT.process((KtElement)parent) : null);
                        if (this.myFormat && parent != null) {
                            CodeStyleManager.getInstance((Project)project).reformat(parent);
                        } else {
                            CodeStyleManager.getInstance((Project)project).reformatRange(element, startOffset, endOffset);
                        }
                    } else if (this.myFormat) {
                        CodeStyleManager.getInstance((Project)project).reformatRange(element, startOffset, endOffset);
                    }
                }
                if (this.mySelectPattern != null && context instanceof AndroidQuickfixContexts.EditorContext && (matcher = (pattern = Pattern.compile(this.mySelectPattern)).matcher(document.getText())).find(startOffset)) {
                    int selectEnd;
                    int selectStart;
                    if (matcher.groupCount() > 0) {
                        selectStart = matcher.start(1);
                        selectEnd = matcher.end(1);
                    } else {
                        selectStart = matcher.start();
                        selectEnd = matcher.end();
                    }
                    Editor editor = ((AndroidQuickfixContexts.EditorContext)context).getEditor();
                    editor.getSelectionModel().setSelection(selectStart, selectEnd);
                }
            }
        }
    }

    private static boolean whitespaceOnly(@NotNull String text) {
        if (text == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(8);
        }
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static TextRange includeFullLineIfOnlySpace(@NotNull Document document, @NotNull TextRange range) {
        if (document == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(9);
        }
        if (range == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(10);
        }
        int startOffset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        int lineStart = DocumentUtil.getLineStartOffset((int)startOffset, (Document)document);
        int lineEnd = DocumentUtil.getLineEndOffset((int)startOffset, (Document)document);
        if (lineEnd < endOffset) {
            return range;
        }
        String prefix = document.getText(new TextRange(lineStart, startOffset));
        String suffix = document.getText(new TextRange(endOffset, lineEnd));
        if (ReplaceStringQuickFix.whitespaceOnly(prefix) && ReplaceStringQuickFix.whitespaceOnly(suffix)) {
            return new TextRange(lineStart, lineEnd + 1);
        }
        return range;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private TextRange getRange(PsiElement startElement, PsiElement endElement, boolean computeReplacement) {
        int end;
        int start;
        if (!startElement.isValid() || !endElement.isValid()) {
            return null;
        }
        if (this.myRange != null) {
            PsiFile file = this.myRange.getContainingFile();
            if (file == null) {
                return null;
            }
            Segment segment = this.myRange.getRange();
            if (segment == null) return null;
            start = segment.getStartOffset();
            end = segment.getEndOffset();
            if (this.myRegexp != null && !"_lint_insert_begin_".equals(this.myRegexp) && !"_lint_insert_end_".equals(this.myRegexp)) {
                startElement = file.findElementAt(start);
                endElement = file.findElementAt(end);
                if (startElement == null || endElement == null) {
                    return null;
                }
            }
        } else {
            start = startElement.getTextOffset();
            end = endElement.getTextOffset() + endElement.getTextLength();
        }
        if (this.myRegexp == null) return new TextRange(start, end);
        if ("_lint_insert_begin_".equals(this.myRegexp)) {
            return new TextRange(start, start);
        }
        if ("_lint_insert_end_".equals(this.myRegexp)) {
            return new TextRange(end, end);
        }
        try {
            String sequence;
            Pattern pattern = Pattern.compile(this.myRegexp, 8);
            PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement);
            if (parent != null && parent.getTextRange().containsRange(start, end)) {
                TextRange parentRange = parent.getTextRange();
                int offset = parentRange.getStartOffset();
                sequence = parent.getText().substring(start - offset, end - offset);
            } else {
                String text = startElement.getContainingFile().getText();
                sequence = text.substring(start, end);
            }
            Matcher matcher = pattern.matcher(sequence);
            if (!matcher.find()) return null;
            end = start;
            if (matcher.groupCount() > 0) {
                if (this.myRegexp.contains("target")) {
                    try {
                        start += matcher.start("target");
                        end += matcher.end("target");
                    }
                    catch (IllegalArgumentException ignore) {
                        start += matcher.start(1);
                        end += matcher.end(1);
                    }
                } else {
                    start += matcher.start(1);
                    end += matcher.end(1);
                }
            } else {
                start += matcher.start();
                end += matcher.end();
            }
            if (!computeReplacement || this.myExpandedNewValue != null) return new TextRange(start, end);
            this.myExpandedNewValue = LintFix.ReplaceString.expandBackReferences((String)this.myNewValue, (Matcher)matcher);
            return new TextRange(start, end);
        }
        catch (Exception e) {
            Logger.getInstance(ReplaceStringQuickFix.class).warn("Invalid regular expression " + this.myRegexp);
            return null;
        }
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(11);
        }
        if (endElement == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(12);
        }
        if (contextType == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(13);
        }
        return this.getRange(startElement, endElement, false) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/common/ReplaceStringQuickFix";
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/common/ReplaceStringQuickFix";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "editBefore";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "editAfter";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "whitespaceOnly";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "includeFullLineIfOnlySpace";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

