/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001!B3\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001cH\u0002R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\""}, d2={"Lcom/intellij/openapi/diagnostic/RollingFileHandler;", "Ljava/util/logging/StreamHandler;", "logPath", "Ljava/nio/file/Path;", "limit", "", "count", "", "append", "", "onRotate", "Ljava/lang/Runnable;", "(Ljava/nio/file/Path;JIZLjava/lang/Runnable;)V", "getAppend", "()Z", "getCount", "()I", "getLimit", "()J", "getLogPath", "()Ljava/nio/file/Path;", "meter", "Lcom/intellij/openapi/diagnostic/RollingFileHandler$MeteredOutputStream;", "getOnRotate", "()Ljava/lang/Runnable;", "logPathWithIndex", "index", "open", "", "publish", "record", "Ljava/util/logging/LogRecord;", "rotate", "MeteredOutputStream", "intellij.platform.util"})
public final class RollingFileHandler
extends StreamHandler {
    private volatile MeteredOutputStream meter;
    @NotNull
    private final Path logPath;
    private final long limit;
    private final int count;
    private final boolean append;
    @Nullable
    private final Runnable onRotate;

    private final void open(boolean append) {
        Files.createDirectories(this.logPath.getParent(), new FileAttribute[0]);
        OutputStream fout = Files.newOutputStream(this.logPath, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        MeteredOutputStream meteredOutputStream = this.meter = new MeteredOutputStream(bout, append ? Files.size(this.logPath) : 0L);
        if (meteredOutputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"meter");
        }
        this.setOutputStream(meteredOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(@NotNull LogRecord record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        if (!this.isLoggable(record)) {
            return;
        }
        super.publish(record);
        this.flush();
        if (this.limit > 0L) {
            MeteredOutputStream meteredOutputStream = this.meter;
            if (meteredOutputStream == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"meter");
            }
            if (meteredOutputStream.getWritten() >= this.limit) {
                RollingFileHandler rollingFileHandler = this;
                synchronized (rollingFileHandler) {
                    boolean bl = false;
                    MeteredOutputStream meteredOutputStream2 = this.meter;
                    if (meteredOutputStream2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"meter");
                    }
                    if (meteredOutputStream2.getWritten() >= this.limit) {
                        this.rotate();
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void rotate() {
        Runnable runnable = this.onRotate;
        if (runnable != null) {
            runnable.run();
        }
        try {
            Files.deleteIfExists(this.logPathWithIndex(this.count));
            int n = this.count - 1;
            int n2 = 1;
            while (n >= n2) {
                void i;
                Path path = this.logPathWithIndex((int)i);
                if (Files.exists(path, new LinkOption[0])) {
                    Files.move(path, this.logPathWithIndex((int)(i + true)), StandardCopyOption.ATOMIC_MOVE);
                }
                --i;
            }
        }
        catch (IOException e) {
            super.publish(new LogRecord(Level.SEVERE, "Log rotate failed: " + e.getMessage()));
            return;
        }
        this.close();
        try {
            Files.move(this.logPath, this.logPathWithIndex(1), new CopyOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.open(false);
    }

    private final Path logPathWithIndex(int index) {
        String pathString = ((Object)this.logPath).toString();
        int extIndex = StringsKt.lastIndexOf$default((CharSequence)pathString, (char)'.', (int)0, (boolean)false, (int)6, null);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = pathString;
        int n = 0;
        String string3 = string2.substring(n, extIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append('.').append(index);
        string2 = pathString;
        String string4 = string2.substring(extIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
        Path path = Paths.get(stringBuilder2.append(string4).toString(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(pathString.sub\u2026ring.substring(extIndex))");
        return path;
    }

    @NotNull
    public final Path getLogPath() {
        return this.logPath;
    }

    public final long getLimit() {
        return this.limit;
    }

    public final int getCount() {
        return this.count;
    }

    public final boolean getAppend() {
        return this.append;
    }

    @Nullable
    public final Runnable getOnRotate() {
        return this.onRotate;
    }

    @JvmOverloads
    public RollingFileHandler(@NotNull Path logPath, long limit, int count, boolean append, @Nullable Runnable onRotate) {
        Intrinsics.checkNotNullParameter((Object)logPath, (String)"logPath");
        this.logPath = logPath;
        this.limit = limit;
        this.count = count;
        this.append = append;
        this.onRotate = onRotate;
        this.setEncoding(StandardCharsets.UTF_8.name());
        this.open(this.append);
    }

    public /* synthetic */ RollingFileHandler(Path path, long l, int n, boolean bl, Runnable runnable, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            runnable = null;
        }
        this(path, l, n, bl, runnable);
    }

    @JvmOverloads
    public RollingFileHandler(@NotNull Path logPath, long limit, int count, boolean append) {
        this(logPath, limit, count, append, null, 16, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/diagnostic/RollingFileHandler$MeteredOutputStream;", "Ljava/io/OutputStream;", "delegate", "written", "", "(Ljava/io/OutputStream;J)V", "getWritten", "()J", "setWritten", "(J)V", "close", "", "flush", "write", "b", "", "off", "", "len", "intellij.platform.util"})
    private static final class MeteredOutputStream
    extends OutputStream {
        private final OutputStream delegate;
        private volatile long written;

        @Override
        public void write(int b) {
            this.delegate.write(b);
            long l = this.written;
            this.written = l + 1L;
        }

        @Override
        public void write(@NotNull byte[] b) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            this.delegate.write(b);
            this.written += (long)b.length;
        }

        @Override
        public void write(@NotNull byte[] b, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            this.delegate.write(b, off, len);
            this.written += (long)len;
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public void flush() {
            this.delegate.flush();
        }

        public final long getWritten() {
            return this.written;
        }

        public final void setWritten(long l) {
            this.written = l;
        }

        public MeteredOutputStream(@NotNull OutputStream delegate, long written) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            this.delegate = delegate;
            this.written = written;
        }
    }
}

