/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public abstract class AtomicNullableLazyValue<T>
extends NullableLazyValue<T> {
    private volatile T myValue;
    private volatile boolean myComputed;

    @Deprecated
    protected AtomicNullableLazyValue() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T getValue() {
        boolean computed = this.myComputed;
        T value = this.myValue;
        if (computed) {
            return value;
        }
        AtomicNullableLazyValue atomicNullableLazyValue = this;
        synchronized (atomicNullableLazyValue) {
            computed = this.myComputed;
            value = this.myValue;
            if (!computed) {
                RecursionGuard.StackStamp stamp = RecursionManager.markStack();
                value = this.compute();
                if (stamp.mayCacheNow()) {
                    this.myValue = value;
                    this.myComputed = true;
                }
            }
        }
        return value;
    }

    @Override
    public boolean isComputed() {
        return this.myComputed;
    }

    @Deprecated
    @NotNull
    public static <T> AtomicNullableLazyValue<T> createValue(final @NotNull Factory<? extends T> value) {
        if (value == null) {
            AtomicNullableLazyValue.$$$reportNull$$$0(0);
        }
        return new AtomicNullableLazyValue<T>(){

            @Override
            @Nullable
            protected T compute() {
                return value.create();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/util/AtomicNullableLazyValue", "createValue"));
    }
}

