/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.artifacts;

import com.intellij.util.io.Decompressor;
import java.io.File;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.artifacts.KotlinArtifactsKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0001H\u0000\u001a\f\u0010\u0007\u001a\u00020\u0001*\u00020\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"KOTLINC_DIST_JPS_LIB_XML_NAME", "", "lazyUnpackJar", "Ljava/io/File;", "jar", "holderDir", "dirName", "md5", "kotlin.common"})
public final class KotlinArtifactsKt {
    @NotNull
    public static final String KOTLINC_DIST_JPS_LIB_XML_NAME = "kotlinc_kotlin_dist.xml";

    @NotNull
    public static final File lazyUnpackJar(@NotNull File jar, @NotNull File holderDir, @NotNull String dirName) {
        Intrinsics.checkNotNullParameter((Object)jar, (String)"jar");
        Intrinsics.checkNotNullParameter((Object)holderDir, (String)"holderDir");
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        File hashFile = FilesKt.resolve((File)holderDir, (String)"md5");
        String hash = KotlinArtifactsKt.md5(jar);
        File dirWhereToExtract = FilesKt.resolve((File)holderDir, (String)dirName);
        if (hashFile.exists() && Intrinsics.areEqual((Object)FilesKt.readText$default((File)hashFile, null, (int)1, null), (Object)hash)) {
            return dirWhereToExtract;
        }
        FilesKt.deleteRecursively((File)dirWhereToExtract);
        dirWhereToExtract.mkdirs();
        FilesKt.writeText$default((File)hashFile, (String)hash, null, (int)2, null);
        new Decompressor.Zip(jar).extract(dirWhereToExtract);
        return dirWhereToExtract;
    }

    private static final String md5(File $this$md5) {
        byte[] byArray = MessageDigest.getInstance("MD5").digest(FilesKt.readBytes((File)$this$md5));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"MessageDigest.getInstanc\u2026MD5\").digest(readBytes())");
        return ArraysKt.joinToString$default((byte[])byArray, (CharSequence)"", null, null, (int)0, null, (Function1)md5.1.INSTANCE, (int)30, null);
    }
}

