/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.artifacts;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.openapi.application.PathManager;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.aether.ArtifactRepositoryManager;
import org.jetbrains.idea.maven.aether.ProgressConsumer;
import org.jetbrains.kotlin.idea.artifacts.LibraryFileKind;
import org.jetbrains.kotlin.idea.artifacts.RepoLocation;
import org.jetbrains.kotlin.idea.artifacts.UtilKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a*\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0000\u001a(\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0002\"!\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0013"}, d2={"remoteMavenRepositories", "", "Lorg/eclipse/aether/repository/RemoteRepository;", "getRemoteMavenRepositories", "()Ljava/util/List;", "remoteMavenRepositories$delegate", "Lkotlin/Lazy;", "findMavenLibrary", "Ljava/io/File;", "library", "", "groupId", "artifactId", "kind", "Lorg/jetbrains/kotlin/idea/artifacts/LibraryFileKind;", "resolveArtifact", "version", "substitutePathVariables", "path", "kotlin.common"})
public final class UtilKt {
    private static final Lazy remoteMavenRepositories$delegate = LazyKt.lazy((Function0)remoteMavenRepositories.2.INSTANCE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final File findMavenLibrary(@NotNull String library, @NotNull String groupId, @NotNull String artifactId, @NotNull LibraryFileKind kind) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        File librariesDir = new File(PathManager.getHomePath(), ".idea/libraries");
        if (!librariesDir.exists()) {
            throw (Throwable)new IllegalStateException("Can't find " + librariesDir);
        }
        File libraryFile = new File(librariesDir, library);
        if (!libraryFile.exists()) {
            throw (Throwable)new IllegalStateException("Can't find library " + library);
        }
        Object object = libraryFile;
        object = new FileInputStream((File)object);
        Throwable throwable = null;
        try {
            FileInputStream stream = (FileInputStream)object;
            boolean bl = false;
            stream = new SAXBuilder().build((InputStream)stream);
        }
        catch (Throwable stream) {
            throwable = stream;
            throw stream;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        FileInputStream document = stream;
        String urlScheme = "jar://";
        List allowedJarLocations = CollectionsKt.listOf((Object[])new String[]{urlScheme + "$PROJECT_DIR$/../build/repo", urlScheme + "$MAVEN_REPOSITORY$"});
        FileInputStream fileInputStream = document;
        Intrinsics.checkNotNullExpressionValue((Object)fileInputStream, (String)"document");
        Element element = fileInputStream.getRootElement().getChild("library");
        List bl = element != null && (element = element.getChild(kind.name())) != null ? element.getChildren("root") : null;
        List list = bl;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List roots = list;
        String pathInRepository = StringsKt.replace$default((String)groupId, (char)'.', (char)'/', (boolean)false, (int)4, null) + "/" + artifactId;
        for (Element root : roots) {
            if (root.getAttributeValue("url") == null) {
                continue;
            }
            for (String locationPrefix : allowedJarLocations) {
                String url;
                if (!StringsKt.startsWith$default((String)url, (String)(locationPrefix + "/" + pathInRepository + "/"), (boolean)false, (int)2, null)) continue;
                boolean bl2 = StringsKt.endsWith$default((String)url, (String)"!/", (boolean)false, (int)2, null);
                if (!bl2) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                String path = StringsKt.dropLast((String)StringsKt.drop((String)url, (int)urlScheme.length()), (int)"!/".length());
                File result = new File(UtilKt.substitutePathVariables(path));
                if (!result.exists()) {
                    if (kind == LibraryFileKind.SOURCES) {
                        String version = StringsKt.dropLast((String)StringsKt.drop((String)FilesKt.getNameWithoutExtension((File)result), (int)(artifactId.length() + 1)), (int)kind.getClassifierSuffix().length());
                        return UtilKt.resolveArtifact(groupId, artifactId, version, kind);
                    }
                    throw (Throwable)new IllegalStateException("File " + result + " doesn't exist");
                }
                return result;
            }
        }
        throw (Throwable)new IllegalStateException(kind.name() + " root '" + pathInRepository + "' not found in library " + library);
    }

    public static /* synthetic */ File findMavenLibrary$default(String string, String string2, String string3, LibraryFileKind libraryFileKind, int n, Object object) {
        if ((n & 8) != 0) {
            libraryFileKind = LibraryFileKind.CLASSES;
        }
        return UtilKt.findMavenLibrary(string, string2, string3, libraryFileKind);
    }

    private static final List<RemoteRepository> getRemoteMavenRepositories() {
        Lazy lazy = remoteMavenRepositories$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        return (List)lazy.getValue();
    }

    /*
     * Unable to fully structure code
     */
    private static final String substitutePathVariables(String path) {
        block7: {
            block9: {
                block8: {
                    if (StringsKt.startsWith$default((String)path, (String)(RepoLocation.PROJECT_DIR + "/"), (boolean)false, (int)2, null)) {
                        projectDir = new File(PathManager.getHomePath());
                        v0 = FilesKt.resolve((File)projectDir, (String)StringsKt.drop((String)path, (int)(RepoLocation.PROJECT_DIR.toString().length() + 1))).getAbsolutePath();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"projectDir.resolve(path.\u2026length + 1)).absolutePath");
                        return v0;
                    }
                    if (!StringsKt.startsWith$default((String)path, (String)(RepoLocation.MAVEN_REPOSITORY + "/"), (boolean)false, (int)2, null)) break block7;
                    v1 = System.getProperty("user.home", null);
                    if (v1 != null) {
                        it = var2_3 = v1;
                        $i$a$-let-UtilKt$substitutePathVariables$homeDir$1 = false;
                        v2 = new File(it);
                    } else {
                        v2 = null;
                    }
                    homeDir = v2;
                    $fun$extractLocalRepository$1 = substitutePathVariables.1.INSTANCE;
                    v3 = homeDir;
                    if (v3 == null || (v3 = FilesKt.resolve((File)v3, (String)".m2")) == null || (v3 = FilesKt.resolve((File)v3, (String)"settings.xml")) == null) break block8;
                    $i$a$-let-UtilKt$substitutePathVariables$homeDir$1 = v3;
                    it = $i$a$-let-UtilKt$substitutePathVariables$homeDir$1;
                    $i$a$-takeIf-UtilKt$substitutePathVariables$customM2Repo$1 = false;
                    v3 = it.exists() != false ? $i$a$-let-UtilKt$substitutePathVariables$homeDir$1 : null;
                    if (v3 != null && (v3 = $fun$extractLocalRepository$1.invoke(v3)) != null) break block9;
                }
                if ((v4 = System.getenv("M2_HOME")) == null) ** GOTO lbl-1000
                it = $i$a$-let-UtilKt$substitutePathVariables$homeDir$1 = v4;
                $i$a$-let-UtilKt$substitutePathVariables$customM2Repo$2 = false;
                v4 = FilesKt.resolve((File)new File((String)it), (String)"conf");
                if (v4 == null || (v4 = FilesKt.resolve((File)v4, (String)"settings.xml")) == null) ** GOTO lbl-1000
                it = $i$a$-let-UtilKt$substitutePathVariables$homeDir$1 = v4;
                $i$a$-takeIf-UtilKt$substitutePathVariables$customM2Repo$3 = false;
                v4 = it.exists() != false ? $i$a$-let-UtilKt$substitutePathVariables$homeDir$1 : null;
                if (v4 != null) {
                    v3 = $fun$extractLocalRepository$1.invoke((File)v4);
                } else lbl-1000:
                // 3 sources

                {
                    v3 = null;
                }
            }
            if ((v5 = (customM2Repo = v3)) == null) {
                v6 = homeDir;
                v5 = v6 != null && (v6 = FilesKt.resolve((File)v6, (String)".m2")) != null ? FilesKt.resolve((File)v6, (String)"repository") : null;
            }
            if (v5 == null) {
                var5_9 = "Unable to find maven local repo directory";
                throw new IllegalStateException(var5_9.toString());
            }
            m2Repo = v5;
            return m2Repo.getAbsolutePath() + StringsKt.drop((String)path, (int)RepoLocation.MAVEN_REPOSITORY.toString().length());
        }
        return path;
    }

    private static final File resolveArtifact(String groupId, String artifactId, String version, LibraryFileKind kind) {
        boolean bl;
        ArtifactRepositoryManager repositoryManager = new ArtifactRepositoryManager(JarRepositoryManager.getLocalRepositoryPath(), UtilKt.getRemoteMavenRepositories(), ProgressConsumer.DEAF, false);
        Collection collection = repositoryManager.resolveDependencyAsArtifact(groupId, artifactId, version, SetsKt.setOf((Object)kind.getArtifactKind()), false, CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"repositoryManager.resolv\u2026 false, emptyList()\n    )");
        Collection artifacts = collection;
        boolean bl2 = bl = artifacts.size() == 1;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Single artifact expected for library \"" + groupId + ":" + artifactId + ":" + version + "\", got " + artifacts;
            throw new AssertionError((Object)string);
        }
        Object object = CollectionsKt.single((Iterable)artifacts);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"artifacts.single()");
        File file = ((Artifact)object).getFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"artifacts.single().file");
        return file;
    }
}

