/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.quickfix;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.DeferredType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

public class QuickFixUtil {
    private QuickFixUtil() {
    }

    public static boolean removePossiblyWhiteSpace(ASTDelegatePsiElement element, PsiElement possiblyWhiteSpace) {
        if (possiblyWhiteSpace instanceof PsiWhiteSpace) {
            element.deleteChildInternal(possiblyWhiteSpace.getNode());
            return true;
        }
        return false;
    }

    @Nullable
    public static <T extends PsiElement> T getParentElementOfType(Diagnostic diagnostic, Class<T> aClass) {
        return (T)PsiTreeUtil.getParentOfType((PsiElement)diagnostic.getPsiElement(), aClass, (boolean)false);
    }

    @Nullable
    public static KotlinType getDeclarationReturnType(KtNamedDeclaration declaration) {
        PsiFile file = declaration.getContainingFile();
        if (!(file instanceof KtFile)) {
            return null;
        }
        DeclarationDescriptor descriptor = ResolutionUtils.unsafeResolveToDescriptor((KtDeclaration)declaration, BodyResolveMode.FULL);
        if (!(descriptor instanceof CallableDescriptor)) {
            return null;
        }
        KotlinType type = ((CallableDescriptor)descriptor).getReturnType();
        if (type instanceof DeferredType) {
            type = ((DeferredType)type).getDelegate();
        }
        return type;
    }

    @Nullable
    public static KotlinType findLowerBoundOfOverriddenCallablesReturnTypes(@NotNull CallableDescriptor descriptor) {
        if (descriptor == null) {
            QuickFixUtil.$$$reportNull$$$0(0);
        }
        KotlinType matchingReturnType = null;
        for (CallableDescriptor overriddenDescriptor : descriptor.getOverriddenDescriptors()) {
            KotlinType overriddenReturnType = overriddenDescriptor.getReturnType();
            if (overriddenReturnType == null) {
                return null;
            }
            if (matchingReturnType == null || KotlinTypeChecker.DEFAULT.isSubtypeOf(overriddenReturnType, matchingReturnType)) {
                matchingReturnType = overriddenReturnType;
                continue;
            }
            if (KotlinTypeChecker.DEFAULT.isSubtypeOf(matchingReturnType, overriddenReturnType)) continue;
            return null;
        }
        return matchingReturnType;
    }

    @Nullable
    public static PsiElement safeGetDeclaration(@Nullable CallableDescriptor descriptor) {
        if (descriptor == null || descriptor.getOverriddenDescriptors().size() > 1) {
            return null;
        }
        return DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)descriptor);
    }

    @Nullable
    public static KtParameter getParameterDeclarationForValueArgument(@NotNull ResolvedCall<?> resolvedCall, @Nullable ValueArgument valueArgument) {
        PsiElement declaration;
        if (resolvedCall == null) {
            QuickFixUtil.$$$reportNull$$$0(1);
        }
        return (declaration = QuickFixUtil.safeGetDeclaration((CallableDescriptor)CallUtilKt.getParameterForArgument(resolvedCall, (ValueArgument)valueArgument))) instanceof KtParameter ? (KtParameter)declaration : null;
    }

    private static boolean equalOrLastInBlock(KtExpression block, KtExpression expression) {
        if (block == expression) {
            return true;
        }
        return block instanceof KtBlockExpression && expression.getParent() == block && PsiTreeUtil.getNextSiblingOfType((PsiElement)expression, KtExpression.class) == null;
    }

    @Nullable
    public static KtIfExpression getParentIfForBranch(@Nullable KtExpression expression) {
        KtIfExpression ifExpression = (KtIfExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, KtIfExpression.class, (boolean)true);
        if (ifExpression == null) {
            return null;
        }
        if (QuickFixUtil.equalOrLastInBlock(ifExpression.getThen(), expression) || QuickFixUtil.equalOrLastInBlock(ifExpression.getElse(), expression)) {
            return ifExpression;
        }
        return null;
    }

    @Nullable
    private static KtWhenExpression getParentWhenForBranch(@Nullable KtExpression expression) {
        KtWhenEntry whenEntry = (KtWhenEntry)PsiTreeUtil.getParentOfType((PsiElement)expression, KtWhenEntry.class, (boolean)true);
        if (whenEntry == null) {
            return null;
        }
        KtExpression whenEntryExpression = whenEntry.getExpression();
        if (whenEntryExpression == null) {
            return null;
        }
        if (!QuickFixUtil.equalOrLastInBlock(whenEntryExpression, expression)) {
            return null;
        }
        return (KtWhenExpression)PsiTreeUtil.getParentOfType((PsiElement)whenEntry, KtWhenExpression.class, (boolean)true);
    }

    @Nullable
    private static KtExpression getParentForBranch(@Nullable KtExpression expression) {
        KtIfExpression parent = QuickFixUtil.getParentIfForBranch(expression);
        if (parent != null) {
            return parent;
        }
        return QuickFixUtil.getParentWhenForBranch(expression);
    }

    public static boolean canEvaluateTo(KtExpression parent, KtExpression child) {
        if (parent == null || child == null) {
            return false;
        }
        while (parent != child) {
            PsiElement childParent = child.getParent();
            if (childParent instanceof KtParenthesizedExpression) {
                child = (KtExpression)childParent;
                continue;
            }
            if (childParent instanceof KtDotQualifiedExpression && (child instanceof KtCallExpression || child instanceof KtDotQualifiedExpression)) {
                child = (KtExpression)childParent;
                continue;
            }
            if ((child = QuickFixUtil.getParentForBranch(child)) != null) continue;
            return false;
        }
        return true;
    }

    public static boolean canFunctionOrGetterReturnExpression(@NotNull KtDeclaration functionOrGetter, @NotNull KtExpression expression) {
        if (functionOrGetter == null) {
            QuickFixUtil.$$$reportNull$$$0(2);
        }
        if (expression == null) {
            QuickFixUtil.$$$reportNull$$$0(3);
        }
        if (functionOrGetter instanceof KtFunctionLiteral) {
            PsiElement[] children;
            int length;
            KtBlockExpression functionLiteralBody = ((KtFunctionLiteral)functionOrGetter).getBodyExpression();
            PsiElement returnedElement = null;
            if (functionLiteralBody != null && (length = (children = functionLiteralBody.getChildren()).length) > 0) {
                returnedElement = children[length - 1];
            }
            return returnedElement instanceof KtExpression && QuickFixUtil.canEvaluateTo((KtExpression)returnedElement, expression);
        }
        if (functionOrGetter instanceof KtDeclarationWithInitializer && QuickFixUtil.canEvaluateTo(((KtDeclarationWithInitializer)functionOrGetter).getInitializer(), expression)) {
            return true;
        }
        KtReturnExpression returnExpression = (KtReturnExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, KtReturnExpression.class);
        return returnExpression != null && QuickFixUtil.canEvaluateTo(returnExpression.getReturnedExpression(), expression);
    }

    public static String renderTypeWithFqNameOnClash(KotlinType type, String nameToCheckAgainst) {
        FqName fqNameToCheckAgainst = new FqName(nameToCheckAgainst);
        ClassifierDescriptor typeClassifierDescriptor = type.getConstructor().getDeclarationDescriptor();
        FqName typeFqName = typeClassifierDescriptor != null ? DescriptorUtils.getFqNameSafe((DeclarationDescriptor)typeClassifierDescriptor) : fqNameToCheckAgainst;
        DescriptorRenderer renderer = typeFqName.shortName().equals((Object)fqNameToCheckAgainst.shortName()) ? IdeDescriptorRenderers.SOURCE_CODE : IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_NO_ANNOTATIONS;
        return renderer.renderType(type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedCall";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionOrGetter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/core/quickfix/QuickFixUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findLowerBoundOfOverriddenCallablesReturnTypes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getParameterDeclarationForValueArgument";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "canFunctionOrGetterReturnExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

