/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.decomposition;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.research.kotlinrminer.common.decomposition.CodeElementType;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LocationInfo;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LocationInfoProvider;
import org.jetbrains.research.kotlinrminer.ide.decomposition.OperationInvocation;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclaration;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;

public class AnonymousClassDeclarationObject
implements LocationInfoProvider {
    private final String anonName;
    private final LocationInfo locationInfo;
    private KtElement elementNode;
    private final List<String> variables = new ArrayList<String>();
    private final List<String> types = new ArrayList<String>();
    private final Map<String, List<OperationInvocation>> methodInvocationMap = new LinkedHashMap<String, List<OperationInvocation>>();
    private final List<VariableDeclaration> variableDeclarations = new ArrayList<VariableDeclaration>();
    private final List<AnonymousClassDeclarationObject> anonymousClassDeclarations = new ArrayList<AnonymousClassDeclarationObject>();
    private final List<String> stringLiterals = new ArrayList<String>();
    private final List<String> numberLiterals = new ArrayList<String>();
    private final List<String> nullLiterals = new ArrayList<String>();
    private final List<String> booleanLiterals = new ArrayList<String>();
    private final List<String> typeLiterals = new ArrayList<String>();
    private final List<String> prefixExpressions = new ArrayList<String>();
    private final List<String> postfixExpressions = new ArrayList<String>();
    private final List<KtLambdaExpression> lambdas = new ArrayList<KtLambdaExpression>();
    private final List<String> arrayAccesses = new ArrayList<String>();
    private final List<String> arguments = new ArrayList<String>();

    public AnonymousClassDeclarationObject(KtFile ktFile, String filePath, KtElement anonymous) {
        this.locationInfo = new LocationInfo(ktFile, filePath, anonymous, CodeElementType.ANONYMOUS_CLASS_DECLARATION);
        this.elementNode = anonymous;
        this.anonName = anonymous.toString();
    }

    @Override
    public LocationInfo getLocationInfo() {
        return this.locationInfo;
    }

    public KtElement getElementNode() {
        return this.elementNode;
    }

    public void setElementNode(KtElement node) {
        this.elementNode = node;
    }

    public String toString() {
        return this.anonName;
    }

    public List<VariableDeclaration> getVariableDeclarations() {
        return this.variableDeclarations;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public List<AnonymousClassDeclarationObject> getAnonymousClassDeclarations() {
        return this.anonymousClassDeclarations;
    }

    public Map<String, List<OperationInvocation>> getMethodInvocationMap() {
        return this.methodInvocationMap;
    }

    public List<String> getStringLiterals() {
        return this.stringLiterals;
    }

    public List<String> getNumberLiterals() {
        return this.numberLiterals;
    }

    public List<String> getNullLiterals() {
        return this.nullLiterals;
    }

    public List<String> getBooleanLiterals() {
        return this.booleanLiterals;
    }

    public List<String> getTypeLiterals() {
        return this.typeLiterals;
    }

    public List<String> getVariables() {
        return this.variables;
    }

    public List<String> getPrefixExpressions() {
        return this.prefixExpressions;
    }

    public List<String> getArrayAccesses() {
        return this.arrayAccesses;
    }

    public List<String> getPostfixExpressions() {
        return this.postfixExpressions;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public List<KtLambdaExpression> getLambdas() {
        return this.lambdas;
    }

    @Override
    public CodeRange codeRange() {
        return this.locationInfo.codeRange();
    }
}

