/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.decomposition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.research.kotlinrminer.common.decomposition.CodeElementType;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeFragment;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractExpression;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractStatement;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AnonymousClassDeclarationObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LambdaExpressionObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LocationInfo;
import org.jetbrains.research.kotlinrminer.ide.decomposition.ObjectCreation;
import org.jetbrains.research.kotlinrminer.ide.decomposition.OperationInvocation;
import org.jetbrains.research.kotlinrminer.ide.decomposition.StatementObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclaration;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;

public class CompositeStatementObject
extends AbstractStatement {
    private final List<AbstractStatement> statementList;
    private final List<AbstractExpression> expressionList;
    private final List<VariableDeclaration> variableDeclarations;
    private final LocationInfo locationInfo;

    public CompositeStatementObject(KtFile cu, String filePath, KtElement statement, int depth, CodeElementType codeElementType) {
        this.setDepth(depth);
        this.locationInfo = new LocationInfo(cu, filePath, statement, codeElementType);
        this.statementList = new ArrayList<AbstractStatement>();
        this.expressionList = new ArrayList<AbstractExpression>();
        this.variableDeclarations = new ArrayList<VariableDeclaration>();
    }

    public void addStatement(AbstractStatement statement) {
        statement.setIndex(this.statementList.size());
        this.statementList.add(statement);
        statement.setParent(this);
    }

    public List<AbstractStatement> getStatements() {
        return this.statementList;
    }

    public void addExpression(AbstractExpression expression) {
        expression.setDepth(this.getDepth());
        expression.setIndex(this.getIndex());
        this.expressionList.add(expression);
        expression.setOwner(this);
    }

    public List<AbstractExpression> getExpressions() {
        return this.expressionList;
    }

    public void addVariableDeclaration(VariableDeclaration declaration) {
        this.variableDeclarations.add(declaration);
    }

    @Override
    public List<StatementObject> getLeaves() {
        ArrayList<StatementObject> leaves = new ArrayList<StatementObject>();
        for (AbstractStatement statement : this.statementList) {
            leaves.addAll(statement.getLeaves());
        }
        return leaves;
    }

    @Override
    public List<String> getInfixExpressions() {
        ArrayList<String> infixExpressions = new ArrayList<String>();
        for (AbstractExpression expression : this.expressionList) {
            infixExpressions.addAll(expression.getInfixExpressions());
        }
        return infixExpressions;
    }

    public List<CompositeStatementObject> getInnerNodes() {
        ArrayList<CompositeStatementObject> innerNodes = new ArrayList<CompositeStatementObject>();
        for (AbstractStatement statement : this.statementList) {
            if (!(statement instanceof CompositeStatementObject)) continue;
            CompositeStatementObject composite = (CompositeStatementObject)statement;
            innerNodes.addAll(composite.getInnerNodes());
        }
        innerNodes.add(this);
        return innerNodes;
    }

    public boolean contains(AbstractCodeFragment fragment) {
        if (fragment instanceof StatementObject) {
            return this.getLeaves().contains(fragment);
        }
        if (fragment instanceof CompositeStatementObject) {
            return this.getInnerNodes().contains(fragment);
        }
        if (fragment instanceof AbstractExpression) {
            return this.getExpressions().contains(fragment);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.locationInfo.getCodeElementType().getName());
        if (this.expressionList.size() > 0) {
            sb.append("(");
            for (int i = 0; i < this.expressionList.size() - 1; ++i) {
                sb.append(this.expressionList.get(i).toString()).append("; ");
            }
            sb.append(this.expressionList.get(this.expressionList.size() - 1).toString());
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public List<String> getVariables() {
        ArrayList<String> variables = new ArrayList<String>();
        for (AbstractExpression expression : this.expressionList) {
            variables.addAll(expression.getVariables());
        }
        return variables;
    }

    @Override
    public List<String> getTypes() {
        ArrayList<String> types = new ArrayList<String>();
        for (AbstractExpression expression : this.expressionList) {
            types.addAll(expression.getTypes());
        }
        return types;
    }

    @Override
    public List<VariableDeclaration> getVariableDeclarations() {
        ArrayList<VariableDeclaration> variableDeclarations = new ArrayList<VariableDeclaration>(this.variableDeclarations);
        for (AbstractExpression expression : this.expressionList) {
            variableDeclarations.addAll(expression.getVariableDeclarations());
        }
        return variableDeclarations;
    }

    public List<String> getAllVariables() {
        ArrayList<String> variables = new ArrayList<String>(this.getVariables());
        for (AbstractStatement statement : this.statementList) {
            if (statement instanceof CompositeStatementObject) {
                CompositeStatementObject composite = (CompositeStatementObject)statement;
                variables.addAll(composite.getAllVariables());
                continue;
            }
            if (!(statement instanceof StatementObject)) continue;
            StatementObject statementObject = (StatementObject)statement;
            variables.addAll(statementObject.getVariables());
        }
        return variables;
    }

    public List<LambdaExpressionObject> getAllLambdas() {
        ArrayList<LambdaExpressionObject> lambdas = new ArrayList<LambdaExpressionObject>(this.getLambdas());
        for (AbstractStatement statement : this.statementList) {
            if (statement instanceof CompositeStatementObject) {
                CompositeStatementObject composite = (CompositeStatementObject)statement;
                lambdas.addAll(composite.getAllLambdas());
                continue;
            }
            if (!(statement instanceof StatementObject)) continue;
            StatementObject statementObject = (StatementObject)statement;
            lambdas.addAll(statementObject.getLambdas());
        }
        return lambdas;
    }

    public List<VariableDeclaration> getAllVariableDeclarations() {
        ArrayList<VariableDeclaration> variableDeclarations = new ArrayList<VariableDeclaration>(this.getVariableDeclarations());
        for (AbstractStatement statement : this.statementList) {
            if (statement instanceof CompositeStatementObject) {
                CompositeStatementObject composite = (CompositeStatementObject)statement;
                variableDeclarations.addAll(composite.getAllVariableDeclarations());
                continue;
            }
            if (!(statement instanceof StatementObject)) continue;
            StatementObject statementObject = (StatementObject)statement;
            variableDeclarations.addAll(statementObject.getVariableDeclarations());
            for (LambdaExpressionObject lambda2 : statementObject.getLambdas()) {
                if (lambda2.getBody() == null) continue;
                variableDeclarations.addAll(lambda2.getBody().getAllVariableDeclarations());
            }
        }
        return variableDeclarations;
    }

    public List<VariableDeclaration> getVariableDeclarationsInScope(LocationInfo location) {
        ArrayList<VariableDeclaration> variableDeclarations = new ArrayList<VariableDeclaration>();
        for (VariableDeclaration variableDeclaration : this.getAllVariableDeclarations()) {
            if (!variableDeclaration.getScope().subsumes(location)) continue;
            variableDeclarations.add(variableDeclaration);
        }
        return variableDeclarations;
    }

    @Override
    public int statementCount() {
        int count = 0;
        if (!this.getString().equals("{")) {
            ++count;
        }
        for (AbstractStatement statement : this.statementList) {
            count += statement.statementCount();
        }
        return count;
    }

    @Override
    public LocationInfo getLocationInfo() {
        return this.locationInfo;
    }

    @Override
    public VariableDeclaration getVariableDeclaration(String variableName) {
        List<VariableDeclaration> variableDeclarations = this.getAllVariableDeclarations();
        for (VariableDeclaration declaration : variableDeclarations) {
            if (!declaration.getVariableName().equals(variableName)) continue;
            return declaration;
        }
        return null;
    }

    public Map<String, Set<String>> aliasedAttributes() {
        LinkedHashMap<String, Set<String>> map = new LinkedHashMap<String, Set<String>>();
        for (StatementObject statement : this.getLeaves()) {
            String firstLine;
            String s = statement.getString();
            if (!s.startsWith("this.") || !s.endsWith("\n") || !(firstLine = s.substring(0, s.indexOf("\n"))).contains("=")) continue;
            String attribute = s.substring(5, s.indexOf("="));
            String value = s.substring(s.indexOf("=") + 1, s.indexOf("\n"));
            if (map.containsKey(value)) {
                ((Set)map.get(value)).add(attribute);
                continue;
            }
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            set.add(attribute);
            map.put(value, set);
        }
        LinkedHashSet<String> keysToBeRemoved = new LinkedHashSet<String>();
        for (String key : map.keySet()) {
            if (((Set)map.get(key)).size() > 1) continue;
            keysToBeRemoved.add(key);
        }
        for (String key : keysToBeRemoved) {
            map.remove(key);
        }
        return map;
    }

    @Override
    public CodeRange codeRange() {
        return this.locationInfo.codeRange();
    }

    public boolean isLoop() {
        return this.locationInfo.getCodeElementType().equals((Object)CodeElementType.ENHANCED_FOR_STATEMENT) || this.locationInfo.getCodeElementType().equals((Object)CodeElementType.FOR_STATEMENT) || this.locationInfo.getCodeElementType().equals((Object)CodeElementType.WHILE_STATEMENT) || this.locationInfo.getCodeElementType().equals((Object)CodeElementType.DO_STATEMENT);
    }

    public CompositeStatementObject loopWithVariables(String currentElementName, String collectionName) {
        for (CompositeStatementObject innerNode : this.getInnerNodes()) {
            if (innerNode.getLocationInfo().getCodeElementType().equals((Object)CodeElementType.ENHANCED_FOR_STATEMENT)) {
                boolean currentElementNameMatched = false;
                for (VariableDeclaration variableDeclaration : innerNode.getVariableDeclarations()) {
                    if (!variableDeclaration.getVariableName().equals(currentElementName)) continue;
                    currentElementNameMatched = true;
                    break;
                }
                boolean collectionNameMatched = false;
                for (AbstractExpression expression : innerNode.getExpressions()) {
                    if (!expression.getVariables().contains(collectionName)) continue;
                    collectionNameMatched = true;
                    break;
                }
                if (!currentElementNameMatched || !collectionNameMatched) continue;
                return innerNode;
            }
            if (!innerNode.getLocationInfo().getCodeElementType().equals((Object)CodeElementType.FOR_STATEMENT) && !innerNode.getLocationInfo().getCodeElementType().equals((Object)CodeElementType.WHILE_STATEMENT)) continue;
            boolean collectionNameMatched = false;
            for (AbstractExpression abstractExpression : innerNode.getExpressions()) {
                if (!abstractExpression.getVariables().contains(collectionName)) continue;
                collectionNameMatched = true;
                break;
            }
            boolean currentElementNameMatched = false;
            for (StatementObject statement : innerNode.getLeaves()) {
                VariableDeclaration variableDeclaration = statement.getVariableDeclaration(currentElementName);
                if (variableDeclaration == null || !statement.getVariables().contains(collectionName)) continue;
                currentElementNameMatched = true;
                break;
            }
            if (!currentElementNameMatched || !collectionNameMatched) continue;
            return innerNode;
        }
        return null;
    }

    public Map<String, List<OperationInvocation>> getAllMethodInvocations() {
        LinkedHashMap<String, List<OperationInvocation>> map = new LinkedHashMap<String, List<OperationInvocation>>(this.getMethodInvocationMap());
        for (AbstractStatement statement : this.statementList) {
            ArrayList list;
            if (statement instanceof CompositeStatementObject) {
                CompositeStatementObject composite = (CompositeStatementObject)statement;
                Map<String, List<OperationInvocation>> compositeMap = composite.getAllMethodInvocations();
                for (String key : compositeMap.keySet()) {
                    if (map.containsKey(key)) {
                        ((List)map.get(key)).addAll((Collection)compositeMap.get(key));
                        continue;
                    }
                    list = new ArrayList(compositeMap.get(key));
                    map.put(key, list);
                }
                continue;
            }
            if (!(statement instanceof StatementObject)) continue;
            StatementObject statementObject = (StatementObject)statement;
            Map<String, List<OperationInvocation>> statementMap = statementObject.getMethodInvocationMap();
            for (String key : statementMap.keySet()) {
                if (map.containsKey(key)) {
                    ((List)map.get(key)).addAll((Collection)statementMap.get(key));
                    continue;
                }
                list = new ArrayList(statementMap.get(key));
                map.put(key, list);
            }
            for (LambdaExpressionObject lambda2 : statementObject.getLambdas()) {
                if (lambda2.getBody() == null) continue;
                Map<String, List<OperationInvocation>> lambdaMap = lambda2.getBody().getCompositeStatement().getAllMethodInvocations();
                for (String key : lambdaMap.keySet()) {
                    if (map.containsKey(key)) {
                        ((List)map.get(key)).addAll((Collection)lambdaMap.get(key));
                        continue;
                    }
                    ArrayList list2 = new ArrayList(lambdaMap.get(key));
                    map.put(key, list2);
                }
            }
        }
        return map;
    }

    @Override
    public List<String> stringRepresentation() {
        ArrayList<String> stringRepresentation = new ArrayList<String>();
        stringRepresentation.add(this.toString());
        for (AbstractStatement statement : this.statementList) {
            stringRepresentation.addAll(statement.stringRepresentation());
        }
        return stringRepresentation;
    }

    @Override
    public Map<String, List<OperationInvocation>> getMethodInvocationMap() {
        LinkedHashMap<String, List<OperationInvocation>> map = new LinkedHashMap<String, List<OperationInvocation>>();
        for (AbstractExpression expression : this.expressionList) {
            Map<String, List<OperationInvocation>> expressionMap = expression.getMethodInvocationMap();
            for (String key : expressionMap.keySet()) {
                if (map.containsKey(key)) {
                    ((List)map.get(key)).addAll((Collection)expressionMap.get(key));
                    continue;
                }
                ArrayList list = new ArrayList(expressionMap.get(key));
                map.put(key, list);
            }
        }
        return map;
    }

    @Override
    public List<AnonymousClassDeclarationObject> getAnonymousClassDeclarations() {
        return new ArrayList<AnonymousClassDeclarationObject>();
    }

    @Override
    public List<String> getStringLiterals() {
        ArrayList<String> stringLiterals = new ArrayList<String>();
        for (AbstractExpression expression : this.expressionList) {
            stringLiterals.addAll(expression.getStringLiterals());
        }
        return stringLiterals;
    }

    @Override
    public List<String> getNumberLiterals() {
        ArrayList<String> numberLiterals = new ArrayList<String>();
        for (AbstractExpression expression : this.expressionList) {
            numberLiterals.addAll(expression.getNumberLiterals());
        }
        return numberLiterals;
    }

    @Override
    public List<String> getNullLiterals() {
        ArrayList<String> nullLiterals = new ArrayList<String>();
        for (AbstractExpression expression : this.expressionList) {
            nullLiterals.addAll(expression.getNullLiterals());
        }
        return nullLiterals;
    }

    @Override
    public List<String> getBooleanLiterals() {
        ArrayList<String> booleanLiterals = new ArrayList<String>();
        for (AbstractExpression expression : this.expressionList) {
            booleanLiterals.addAll(expression.getBooleanLiterals());
        }
        return booleanLiterals;
    }

    @Override
    public List<String> getTypeLiterals() {
        ArrayList<String> typeLiterals = new ArrayList<String>();
        for (AbstractExpression expression : this.expressionList) {
            typeLiterals.addAll(expression.getTypeLiterals());
        }
        return typeLiterals;
    }

    @Override
    public Map<String, List<ObjectCreation>> getCreationMap() {
        return new HashMap<String, List<ObjectCreation>>();
    }

    @Override
    public List<String> getArrayAccesses() {
        ArrayList<String> arrayAccesses = new ArrayList<String>();
        for (AbstractExpression expression : this.expressionList) {
            arrayAccesses.addAll(expression.getArrayAccesses());
        }
        return arrayAccesses;
    }

    @Override
    public List<String> getPrefixExpressions() {
        ArrayList<String> prefixExpressions = new ArrayList<String>();
        for (AbstractExpression expression : this.expressionList) {
            prefixExpressions.addAll(expression.getPrefixExpressions());
        }
        return prefixExpressions;
    }

    @Override
    public List<String> getPostfixExpressions() {
        ArrayList<String> postfixExpressions = new ArrayList<String>();
        for (AbstractExpression expression : this.expressionList) {
            postfixExpressions.addAll(expression.getPostfixExpressions());
        }
        return postfixExpressions;
    }

    @Override
    public List<String> getInfixOperators() {
        ArrayList<String> infixOperators = new ArrayList<String>();
        for (AbstractExpression expression : this.expressionList) {
            infixOperators.addAll(expression.getInfixOperators());
        }
        return infixOperators;
    }

    @Override
    public List<String> getArguments() {
        ArrayList<String> arguments = new ArrayList<String>();
        for (AbstractExpression expression : this.expressionList) {
            arguments.addAll(expression.getArguments());
        }
        return arguments;
    }

    @Override
    public List<LambdaExpressionObject> getLambdas() {
        ArrayList<LambdaExpressionObject> lambdas = new ArrayList<LambdaExpressionObject>();
        for (AbstractExpression expression : this.expressionList) {
            lambdas.addAll(expression.getLambdas());
        }
        return lambdas;
    }
}

