/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.decomposition;

import org.jetbrains.research.kotlinrminer.common.util.StringDistance;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCall;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLType;

public class ObjectCreation
extends AbstractCall {
    private UMLType type;
    private String anonymousClassDeclaration;
    private final boolean isArray = false;

    public UMLType getType() {
        return this.type;
    }

    public String getAnonymousClassDeclaration() {
        return this.anonymousClassDeclaration;
    }

    public boolean isArray() {
        return false;
    }

    public boolean identicalArrayInitializer(ObjectCreation other) {
        return this.isArray;
    }

    @Override
    public boolean identicalName(AbstractCall call) {
        return this.getType().equals(((ObjectCreation)call).getType());
    }

    @Override
    public String getName() {
        return this.getType().toString();
    }

    @Override
    public double normalizedNameDistance(AbstractCall call) {
        String s1 = this.getType().toString().toLowerCase();
        String s2 = ((ObjectCreation)call).getType().toString().toLowerCase();
        int distance = StringDistance.editDistance(s1, s2);
        return (double)distance / (double)Math.max(s1.length(), s2.length());
    }

    @Override
    public AbstractCall update(String oldExpression, String newExpression) {
        ObjectCreation newObjectCreation = new ObjectCreation();
        newObjectCreation.type = this.type;
        newObjectCreation.locationInfo = this.locationInfo;
        this.update(newObjectCreation, oldExpression, newExpression);
        return newObjectCreation;
    }
}

