/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.decomposition;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.kotlin.psi.KtAnnotation;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.research.kotlinrminer.common.decomposition.CodeElementType;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractExpression;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LocationInfo;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LocationInfoProvider;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclarationProvider;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableScope;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAnnotation;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLType;

public class VariableDeclaration
implements LocationInfoProvider,
VariableDeclarationProvider {
    private String variableName;
    private AbstractExpression initializer;
    private UMLType type;
    private boolean varargsParameter;
    private LocationInfo locationInfo;
    private boolean isParameter;
    private boolean isAttribute;
    private boolean isEnumConstant;
    private VariableScope scope;
    private final List<UMLAnnotation> annotations = new ArrayList<UMLAnnotation>();

    public VariableDeclaration(KtFile ktFile, String filePath, KtElement fragment) {
        if (fragment instanceof KtParameter) {
            KtParameter parameter = (KtParameter)fragment;
            KtModifierList extendedModifiers = parameter.getModifierList();
            if (extendedModifiers != null) {
                List annotations = extendedModifiers.getAnnotations();
                annotations.forEach(ktAnnotation -> this.annotations.add(new UMLAnnotation(ktFile, filePath, (KtAnnotation)ktAnnotation)));
            }
            this.locationInfo = new LocationInfo(ktFile, filePath, fragment, CodeElementType.SINGLE_VARIABLE_DECLARATION);
            this.variableName = String.valueOf(fragment.getName());
            this.type = UMLType.extractTypeObject(ktFile, filePath, (KtElement)parameter.getTypeReference(), 0);
            int startOffset = fragment.getStartOffsetInParent();
            int endOffset = startOffset + fragment.getTextLength();
            this.scope = new VariableScope(ktFile, filePath, startOffset, endOffset);
        } else if (fragment instanceof KtProperty) {
            KtProperty property = (KtProperty)fragment;
            KtModifierList extendedModifiers = property.getModifierList();
            if (extendedModifiers != null) {
                List annotations = extendedModifiers.getAnnotations();
                annotations.forEach(ktAnnotation -> this.annotations.add(new UMLAnnotation(ktFile, filePath, (KtAnnotation)ktAnnotation)));
            }
            this.locationInfo = new LocationInfo(ktFile, filePath, fragment, CodeElementType.FIELD_DECLARATION);
            this.variableName = String.valueOf(((KtProperty)fragment).getNameIdentifier().getText());
            this.initializer = property.getInitializer() != null ? new AbstractExpression(ktFile, filePath, property.getInitializer(), CodeElementType.VARIABLE_DECLARATION_INITIALIZER) : null;
            this.type = UMLType.extractTypeObject(ktFile, filePath, (KtElement)property.getTypeReference(), 0);
            int startOffset = fragment.getStartOffsetInParent();
            int endOffset = startOffset + fragment.getTextLength();
            this.scope = new VariableScope(ktFile, filePath, startOffset, endOffset);
        } else if (fragment instanceof KtVariableDeclaration) {
            KtVariableDeclaration variableDeclaration = (KtVariableDeclaration)fragment;
            variableDeclaration.getAnnotations().forEach(ktAnnotation -> this.annotations.add(new UMLAnnotation(ktFile, filePath, (KtAnnotation)ktAnnotation)));
            this.locationInfo = new LocationInfo(ktFile, filePath, fragment, CodeElementType.VARIABLE_DECLARATION_EXPRESSION);
            this.variableName = fragment.getName();
            this.initializer = variableDeclaration.getInitializer() != null ? new AbstractExpression(ktFile, filePath, variableDeclaration.getInitializer(), CodeElementType.VARIABLE_DECLARATION_INITIALIZER) : null;
            this.type = UMLType.extractTypeObject(ktFile, filePath, (KtElement)variableDeclaration.getTypeReference(), 0);
            int startOffset = fragment.getStartOffsetInParent();
            int endOffset = startOffset + fragment.getTextLength();
            this.scope = new VariableScope(ktFile, filePath, startOffset, endOffset);
        }
    }

    public VariableDeclaration(KtFile cu, String filePath, KtParameter fragment, boolean varargs) {
        this(cu, filePath, (KtElement)fragment);
        this.varargsParameter = varargs;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public AbstractExpression getInitializer() {
        return this.initializer;
    }

    public UMLType getType() {
        return this.type;
    }

    public VariableScope getScope() {
        return this.scope;
    }

    public boolean isParameter() {
        return this.isParameter;
    }

    public void setParameter(boolean isParameter) {
        this.isParameter = isParameter;
    }

    public boolean isAttribute() {
        return this.isAttribute;
    }

    public boolean isEnumConstant() {
        return this.isEnumConstant;
    }

    public void setAttribute(boolean isAttribute) {
        this.isAttribute = isAttribute;
    }

    public boolean isVarargsParameter() {
        return this.varargsParameter;
    }

    public List<UMLAnnotation> getAnnotations() {
        return this.annotations;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        result = 31 * result + (this.variableName == null ? 0 : this.variableName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableDeclaration other = (VariableDeclaration)obj;
        if (this.scope == null ? other.scope != null : !this.scope.equals(other.scope)) {
            return false;
        }
        if (this.variableName == null) {
            return other.variableName == null;
        }
        return this.variableName.equals(other.variableName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.variableName).append(" : ").append(this.type);
        if (this.varargsParameter) {
            sb.append("...");
        }
        return sb.toString();
    }

    public String toQualifiedString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.variableName).append(" : ").append(this.type.toQualifiedString());
        if (this.varargsParameter) {
            sb.append("...");
        }
        return sb.toString();
    }

    @Override
    public LocationInfo getLocationInfo() {
        return this.locationInfo;
    }

    @Override
    public CodeRange codeRange() {
        return this.locationInfo.codeRange();
    }

    public boolean equalVariableDeclarationType(VariableDeclaration other) {
        return this.locationInfo.getCodeElementType().equals((Object)other.locationInfo.getCodeElementType());
    }

    @Override
    public VariableDeclaration getVariableDeclaration() {
        return this;
    }
}

