/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.decomposition;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.research.kotlinrminer.common.decomposition.CodeElementType;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeFragment;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeMapping;
import org.jetbrains.research.kotlinrminer.ide.decomposition.UMLOperationBodyMapper;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclaration;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableScope;

public class VariableReferenceExtractor {
    public static Set<AbstractCodeMapping> findReferences(VariableDeclaration declaration1, VariableDeclaration declaration2, Set<AbstractCodeMapping> mappings) {
        LinkedHashSet<AbstractCodeMapping> references = new LinkedHashSet<AbstractCodeMapping>();
        VariableScope scope1 = declaration1.getScope();
        VariableScope scope2 = declaration2.getScope();
        for (AbstractCodeMapping mapping : mappings) {
            AbstractCodeFragment fragment1 = mapping.getFragment1();
            AbstractCodeFragment fragment2 = mapping.getFragment2();
            if (!scope1.subsumes(fragment1.getLocationInfo()) || !scope2.subsumes(fragment2.getLocationInfo()) || !VariableReferenceExtractor.usesVariable(fragment1, declaration1) || !VariableReferenceExtractor.usesVariable(fragment2, declaration2)) continue;
            references.add(mapping);
        }
        return references;
    }

    private static boolean usesVariable(AbstractCodeFragment fragment, VariableDeclaration declaration) {
        List<String> variables = fragment.getVariables();
        return variables.contains(declaration.getVariableName()) || declaration.isAttribute() && variables.contains("this." + declaration.getVariableName());
    }

    public static Set<AbstractCodeMapping> findReturnReferences(Set<AbstractCodeMapping> mappings) {
        LinkedHashSet<AbstractCodeMapping> references = new LinkedHashSet<AbstractCodeMapping>();
        for (AbstractCodeMapping mapping : mappings) {
            if (!mapping.getFragment1().getLocationInfo().getCodeElementType().equals((Object)CodeElementType.RETURN_STATEMENT) || !mapping.getFragment2().getLocationInfo().getCodeElementType().equals((Object)CodeElementType.RETURN_STATEMENT)) continue;
            references.add(mapping);
        }
        return references;
    }

    public static Set<AbstractCodeMapping> findReferences(VariableDeclaration declaration1, VariableDeclaration declaration2, List<UMLOperationBodyMapper> operationBodyMapperList) {
        LinkedHashSet<AbstractCodeMapping> references = new LinkedHashSet<AbstractCodeMapping>();
        for (UMLOperationBodyMapper mapper : operationBodyMapperList) {
            references.addAll(VariableReferenceExtractor.findReferences(declaration1, declaration2, mapper.getMappings()));
        }
        return references;
    }
}

