/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.decomposition;

import com.intellij.psi.stubs.IStubElementType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AnonymousClassDeclarationObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LambdaExpressionObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.ObjectCreation;
import org.jetbrains.research.kotlinrminer.ide.decomposition.OperationInvocation;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclaration;

public class Visitor
extends KtVisitor {
    private final String filePath;
    private final KtFile ktFile;
    private final List<String> variables = new ArrayList<String>();
    private final List<String> types = new ArrayList<String>();
    private final Map<String, List<OperationInvocation>> methodInvocationMap = new LinkedHashMap<String, List<OperationInvocation>>();
    private final List<VariableDeclaration> variableDeclarations = new ArrayList<VariableDeclaration>();
    private final List<String> stringLiterals = new ArrayList<String>();
    private final List<String> numberLiterals = new ArrayList<String>();
    private final List<String> nullLiterals = new ArrayList<String>();
    private final List<String> booleanLiterals = new ArrayList<String>();
    private final List<String> typeLiterals = new ArrayList<String>();
    private final List<String> arrayAccesses = new ArrayList<String>();
    private final List<String> prefixExpressions = new ArrayList<String>();
    private final List<String> postfixExpressions = new ArrayList<String>();
    private final List<String> infixOperators = new ArrayList<String>();
    private final List<String> arguments = new ArrayList<String>();
    private final List<LambdaExpressionObject> lambdas = new ArrayList<LambdaExpressionObject>();
    private final DefaultMutableTreeNode root;
    private final DefaultMutableTreeNode current = this.root = new DefaultMutableTreeNode();
    private final Map<String, List<ObjectCreation>> creationMap = new LinkedHashMap<String, List<ObjectCreation>>();

    public Visitor(KtFile file, String filePath) {
        this.ktFile = file;
        this.filePath = filePath;
    }

    public Object visitExpression(@NotNull KtExpression expression, Object data) {
        if (expression == null) {
            Visitor.$$$reportNull$$$0(0);
        }
        if (expression instanceof KtBinaryExpression) {
            this.processBinaryExpression((KtBinaryExpression)expression, data);
        } else if (expression instanceof KtReturnExpression) {
            this.processReturnExpression((KtReturnExpression)expression, data);
        } else if (expression instanceof KtDotQualifiedExpression) {
            this.processDotQualifiedExpression((KtDotQualifiedExpression)expression, data);
        } else if (expression instanceof KtCallExpression) {
            this.processCallExpression((KtCallExpression)expression);
        } else if (expression instanceof KtPrefixExpression) {
            this.processPrefixExpression((KtPrefixExpression)expression, data);
        } else if (expression instanceof KtPostfixExpression) {
            this.processPostfixExpression((KtPostfixExpression)expression);
        } else if (expression instanceof KtThisExpression) {
            this.processThisExpression((KtThisExpression)expression);
        } else if (expression instanceof KtConstantExpression) {
            this.processConstantExpression((KtConstantExpression)expression);
        } else if (expression instanceof KtNameReferenceExpression) {
            this.processReferenceExpression((KtReferenceExpression)((KtNameReferenceExpression)expression));
        } else if (expression instanceof KtParenthesizedExpression) {
            this.visitExpression(((KtParenthesizedExpression)expression).getExpression(), data);
        } else if (expression instanceof KtStringTemplateExpression) {
            this.stringLiterals.add(expression.getText());
        } else if (expression instanceof KtArrayAccessExpression) {
            this.arrayAccesses.add(expression.getText());
            if (this.current.getUserObject() != null) {
                AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                anonymous.getArrayAccesses().add(expression.getText());
            }
        } else if (expression instanceof KtProperty) {
            this.processPropertyExpression((KtProperty)expression, data);
        } else if (expression instanceof KtVariableDeclaration) {
            VariableDeclaration variableDeclaration = new VariableDeclaration(this.ktFile, this.filePath, (KtElement)expression);
            this.variableDeclarations.add(variableDeclaration);
            this.visitElement(((KtProperty)expression).getIdentifyingElement());
        } else if (expression instanceof KtSafeQualifiedExpression) {
            this.processSafeQualifiedExpression((KtSafeQualifiedExpression)expression, data);
        } else if (expression instanceof KtLambdaExpression) {
            this.processLambdaExpression((KtLambdaExpression)expression);
        }
        return super.visitExpression(expression, data);
    }

    private void processDotQualifiedExpression(KtDotQualifiedExpression expression, Object data) {
        this.visitExpression(expression.getReceiverExpression(), data);
        if (expression.getSelectorExpression() != null) {
            this.visitExpression(expression.getSelectorExpression(), data);
        }
    }

    private void processReferenceExpression(KtReferenceExpression expression) {
        if (expression instanceof KtNameReferenceExpression) {
            this.variables.add(expression.getText());
        }
    }

    private void processReturnExpression(KtReturnExpression expression, Object data) {
        if (expression.getReturnedExpression() != null) {
            this.visitExpression(expression.getReturnedExpression(), data);
        }
    }

    private void processBinaryExpression(KtBinaryExpression expression, Object data) {
        String operationToken = expression.getOperationToken().toString();
        if (!operationToken.equals("EQ")) {
            this.infixOperators.add(operationToken);
        }
        if (expression.getLeft() != null) {
            this.visitExpression(expression.getLeft(), data);
        }
        if (expression.getRight() != null) {
            this.visitExpression(expression.getRight(), data);
        }
    }

    private void processPropertyExpression(KtProperty ktProperty, Object data) {
        if (ktProperty.getInitializer() != null) {
            this.visitExpression(ktProperty.getInitializer(), data);
        }
        if (ktProperty.getDelegateExpression() != null) {
            this.visitExpression(ktProperty.getDelegateExpression(), data);
        }
        if (ktProperty.getNameIdentifier() != null) {
            VariableDeclaration variableDeclaration = new VariableDeclaration(this.ktFile, this.filePath, (KtElement)ktProperty);
            this.variableDeclarations.add(variableDeclaration);
            this.variables.add(ktProperty.getNameIdentifier().getText());
        }
    }

    private void processSafeQualifiedExpression(KtSafeQualifiedExpression safeQualifiedExpression, Object data) {
        if (safeQualifiedExpression.getSelectorExpression() != null) {
            this.visitExpression(safeQualifiedExpression.getSelectorExpression(), data);
        }
        this.visitExpression(safeQualifiedExpression.getReceiverExpression(), data);
    }

    private void processLambdaExpression(KtLambdaExpression expression) {
        LambdaExpressionObject lambda2 = new LambdaExpressionObject(this.ktFile, this.filePath, expression);
        this.lambdas.add(lambda2);
        if (expression.getBodyExpression() != null) {
            this.visitExpression((KtExpression)expression.getBodyExpression(), null);
        }
    }

    private void visitArgument(KtValueArgument argument) {
        this.processElementType(argument.getElementType(), argument);
        KtExpression argumentExpression = argument.getArgumentExpression();
        if (argumentExpression instanceof KtConstantExpression) {
            KtConstantExpression constantExpression = (KtConstantExpression)argumentExpression;
            this.processElementType(constantExpression.getElementType(), argument);
        } else if (argumentExpression instanceof KtStringTemplateExpression) {
            KtStringTemplateExpression stringTemplateExpression = (KtStringTemplateExpression)argumentExpression;
            this.processElementType(stringTemplateExpression.getElementType(), argument);
        } else if (argument instanceof KtLambdaArgument) {
            KtLambdaArgument lambdaArgument = (KtLambdaArgument)argument;
            if (lambdaArgument.getLambdaExpression() != null) {
                this.visitExpression((KtExpression)lambdaArgument.getLambdaExpression(), null);
            }
        } else if (argument.getArgumentExpression() instanceof KtObjectLiteralExpression) {
            KtObjectLiteralExpression ktObjectLiteralExpression = (KtObjectLiteralExpression)argument.getArgumentExpression();
        } else if (argumentExpression instanceof KtCallExpression) {
            this.processCallExpression((KtCallExpression)argumentExpression);
        }
    }

    private void processElementType(IStubElementType type, KtValueArgument argument) {
        if (type == KtStubElementTypes.INTEGER_CONSTANT || type == KtStubElementTypes.FLOAT_CONSTANT) {
            this.numberLiterals.add(argument.getText());
            if (this.current.getUserObject() != null) {
                AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                anonymous.getNumberLiterals().add(argument.getText());
            }
        } else if (type == KtStubElementTypes.STRING_TEMPLATE) {
            this.stringLiterals.add(argument.getText());
            if (this.current.getUserObject() != null) {
                AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                anonymous.getStringLiterals().add(argument.getText());
            }
        }
    }

    private void processCallExpression(KtCallExpression expression) {
        List arguments = expression.getValueArguments();
        for (KtValueArgument argument : arguments) {
            this.processArgument(argument);
        }
        String methodInvocation = Visitor.processMethodInvocation(expression);
        OperationInvocation invocation = new OperationInvocation(this.ktFile, this.filePath, expression);
        if (this.methodInvocationMap.containsKey(methodInvocation)) {
            this.methodInvocationMap.get(methodInvocation).add(invocation);
        } else {
            ArrayList<OperationInvocation> list = new ArrayList<OperationInvocation>();
            list.add(invocation);
            this.methodInvocationMap.put(methodInvocation, list);
        }
    }

    private void processPrefixExpression(KtPrefixExpression expression, Object data) {
        this.prefixExpressions.add(expression.getText());
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getPrefixExpressions().add(expression.getText());
        }
        if (expression.getBaseExpression() != null) {
            this.visitExpression(expression.getBaseExpression(), data);
        }
    }

    private void processPostfixExpression(KtPostfixExpression expression) {
        this.postfixExpressions.add(expression.getText());
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getPostfixExpressions().add(expression.getText());
        }
    }

    private void processConstantExpression(KtConstantExpression expression) {
        IStubElementType elementType = expression.getElementType();
        if (elementType == KtStubElementTypes.BOOLEAN_CONSTANT) {
            this.booleanLiterals.add(expression.getText());
            if (this.current.getUserObject() != null) {
                AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                anonymous.getBooleanLiterals().add(expression.getText());
            }
        } else if (elementType == KtStubElementTypes.NULL) {
            this.nullLiterals.add(expression.getText());
            if (this.current.getUserObject() != null) {
                AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                anonymous.getNullLiterals().add(expression.getText());
            }
        } else if (elementType == KtStubElementTypes.INTEGER_CONSTANT || elementType == KtStubElementTypes.FLOAT_CONSTANT) {
            this.numberLiterals.add(expression.getText());
            if (this.current.getUserObject() != null) {
                AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                anonymous.getNumberLiterals().add(expression.getText());
            }
        } else if (elementType == KtStubElementTypes.STRING_TEMPLATE) {
            this.stringLiterals.add(expression.getText());
            if (this.current.getUserObject() != null) {
                AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                anonymous.getStringLiterals().add(expression.getText());
            }
        }
    }

    private void processThisExpression(KtThisExpression expression) {
        if (!(expression.getParent() instanceof KtPropertyAccessor)) {
            this.variables.add(expression.getText());
            if (this.current.getUserObject() != null) {
                AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                anonymous.getVariables().add(expression.getText());
            }
        }
    }

    private void processArgument(KtValueArgument argument) {
        this.arguments.add(argument.getText());
        this.visitArgument(argument);
        if (argument.getArgumentExpression() instanceof KtNameReferenceExpression) {
            this.variables.add(argument.getText());
        }
    }

    private static String processMethodInvocation(KtCallExpression node) {
        StringBuilder sb = new StringBuilder();
        if (node.getPrevSibling() != null && node.getPrevSibling().getParent() != null) {
            if (node.getPrevSibling().getParent() instanceof KtDotQualifiedExpression) {
                sb.append(node.getPrevSibling().getParent().getText());
            } else {
                sb.append(node.getCalleeExpression().getContext().getText());
            }
        } else {
            sb.append(node.getCalleeExpression().getContext().getText());
        }
        return sb.toString();
    }

    public List<String> getVariables() {
        return this.variables;
    }

    public List<String> getArrayAccesses() {
        return this.arrayAccesses;
    }

    public List<String> getPrefixExpressions() {
        return this.prefixExpressions;
    }

    public List<String> getPostfixExpressions() {
        return this.postfixExpressions;
    }

    public List<String> getStringLiterals() {
        return this.stringLiterals;
    }

    public List<String> getNumberLiterals() {
        return this.numberLiterals;
    }

    public List<String> getNullLiterals() {
        return this.nullLiterals;
    }

    public List<String> getBooleanLiterals() {
        return this.booleanLiterals;
    }

    public List<String> getTypeLiterals() {
        return this.typeLiterals;
    }

    public List<VariableDeclaration> getVariableDeclarations() {
        return this.variableDeclarations;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public List<LambdaExpressionObject> getLambdas() {
        return this.lambdas;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public Map<String, List<ObjectCreation>> getCreationMap() {
        return this.creationMap;
    }

    public Map<String, List<OperationInvocation>> getMethodInvocationMap() {
        return this.methodInvocationMap;
    }

    public List<String> getInfixOperators() {
        return this.infixOperators;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/research/kotlinrminer/ide/decomposition/Visitor", "visitExpression"));
    }
}

