/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.research.kotlinrminer.common.replacement.Replacement;
import org.jetbrains.research.kotlinrminer.ide.RefactoringMinerTimedOutException;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeFragment;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeMapping;
import org.jetbrains.research.kotlinrminer.ide.decomposition.CompositeStatementObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LambdaExpressionObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.OperationInvocation;
import org.jetbrains.research.kotlinrminer.ide.decomposition.StatementObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.UMLOperationBodyMapper;
import org.jetbrains.research.kotlinrminer.ide.diff.CallTree;
import org.jetbrains.research.kotlinrminer.ide.diff.CallTreeNode;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLClassBaseDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLModelDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.ExtractOperationRefactoring;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLParameter;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLType;

public class ExtractOperationDetection {
    private final UMLOperationBodyMapper mapper;
    private final List<UMLOperation> addedOperations;
    private final UMLClassBaseDiff classDiff;
    private final UMLModelDiff modelDiff;
    private final List<OperationInvocation> operationInvocations;
    private final Map<CallTreeNode, CallTree> callTreeMap = new LinkedHashMap<CallTreeNode, CallTree>();

    public ExtractOperationDetection(UMLOperationBodyMapper mapper, List<UMLOperation> addedOperations, UMLClassBaseDiff classDiff, UMLModelDiff modelDiff) {
        this.mapper = mapper;
        this.addedOperations = addedOperations;
        this.classDiff = classDiff;
        this.modelDiff = modelDiff;
        this.operationInvocations = ExtractOperationDetection.getInvocationsInSourceOperationAfterExtraction(mapper);
    }

    public List<ExtractOperationRefactoring> check(UMLOperation addedOperation) throws RefactoringMinerTimedOutException {
        List<OperationInvocation> addedOperationInvocations;
        ArrayList<ExtractOperationRefactoring> refactorings = new ArrayList<ExtractOperationRefactoring>();
        if (!(this.mapper.getNonMappedLeavesT1().isEmpty() && this.mapper.getNonMappedInnerNodesT1().isEmpty() && this.mapper.getReplacementsInvolvingMethodInvocation().isEmpty() || (addedOperationInvocations = this.matchingInvocations(addedOperation, this.operationInvocations, this.mapper.getOperation2().variableTypeMap())).size() <= 0)) {
            int otherAddedMethodsCalled = 0;
            for (UMLOperation addedOperation2 : this.addedOperations) {
                List<OperationInvocation> addedOperationInvocations2;
                if (addedOperation.equals(addedOperation2) || (addedOperationInvocations2 = this.matchingInvocations(addedOperation2, this.operationInvocations, this.mapper.getOperation2().variableTypeMap())).size() <= 0) continue;
                ++otherAddedMethodsCalled;
            }
            if (otherAddedMethodsCalled == 0) {
                for (OperationInvocation addedOperationInvocation : addedOperationInvocations) {
                    this.processAddedOperation(this.mapper, addedOperation, refactorings, addedOperationInvocations, addedOperationInvocation);
                }
            } else {
                this.processAddedOperation(this.mapper, addedOperation, refactorings, addedOperationInvocations, addedOperationInvocations.get(0));
            }
        }
        return refactorings;
    }

    private void processAddedOperation(UMLOperationBodyMapper mapper, UMLOperation addedOperation, List<ExtractOperationRefactoring> refactorings, List<OperationInvocation> addedOperationInvocations, OperationInvocation addedOperationInvocation) throws RefactoringMinerTimedOutException {
        CallTree callTree;
        CallTreeNode root = new CallTreeNode(mapper.getOperation1(), addedOperation, addedOperationInvocation);
        if (this.callTreeMap.containsKey(root)) {
            callTree = this.callTreeMap.get(root);
        } else {
            callTree = new CallTree(root);
            this.generateCallTree(addedOperation, root, callTree);
            this.callTreeMap.put(root, callTree);
        }
        UMLOperationBodyMapper operationBodyMapper = this.createMapperForExtractedMethod(mapper, mapper.getOperation1(), addedOperation, addedOperationInvocation);
        if (operationBodyMapper != null) {
            ArrayList<AbstractCodeMapping> additionalExactMatches = new ArrayList<AbstractCodeMapping>();
            List<CallTreeNode> nodesInBreadthFirstOrder = callTree.getNodesInBreadthFirstOrder();
            for (int i = 1; i < nodesInBreadthFirstOrder.size(); ++i) {
                UMLOperationBodyMapper nestedMapper;
                CallTreeNode node = nodesInBreadthFirstOrder.get(i);
                if (this.matchingInvocations(node.getInvokedOperation(), this.operationInvocations, mapper.getOperation2().variableTypeMap()).size() != 0 || (nestedMapper = this.createMapperForExtractedMethod(mapper, node.getOriginalOperation(), node.getInvokedOperation(), node.getInvocation())) == null) continue;
                additionalExactMatches.addAll(nestedMapper.getExactMatches());
                if (this.extractMatchCondition(nestedMapper, new ArrayList<AbstractCodeMapping>()) && this.extractMatchCondition(operationBodyMapper, additionalExactMatches)) {
                    List<OperationInvocation> nestedMatchingInvocations = this.matchingInvocations(node.getInvokedOperation(), node.getOriginalOperation().getAllOperationInvocations(), node.getOriginalOperation().variableTypeMap());
                    ExtractOperationRefactoring nestedRefactoring = new ExtractOperationRefactoring(nestedMapper, mapper.getOperation2(), nestedMatchingInvocations);
                    refactorings.add(nestedRefactoring);
                    operationBodyMapper.addChildMapper(nestedMapper);
                }
                for (AbstractCodeMapping mapping : nestedMapper.getMappings()) {
                    if (mapping.isExact() && !mapping.getFragment1().getString().equals("{")) continue;
                    AbstractCodeFragment fragment1 = mapping.getFragment1();
                    if (fragment1 instanceof StatementObject) {
                        if (mapper.getNonMappedLeavesT1().contains(fragment1)) continue;
                        mapper.getNonMappedLeavesT1().add((StatementObject)fragment1);
                        continue;
                    }
                    if (!(fragment1 instanceof CompositeStatementObject) || mapper.getNonMappedInnerNodesT1().contains(fragment1)) continue;
                    mapper.getNonMappedInnerNodesT1().add((CompositeStatementObject)fragment1);
                }
            }
            UMLOperation delegateMethod = this.findDelegateMethod(mapper.getOperation1(), addedOperation, addedOperationInvocation);
            if (this.extractMatchCondition(operationBodyMapper, additionalExactMatches)) {
                if (delegateMethod == null) {
                    refactorings.add(new ExtractOperationRefactoring(operationBodyMapper, mapper.getOperation2(), addedOperationInvocations));
                } else {
                    refactorings.add(new ExtractOperationRefactoring(operationBodyMapper, addedOperation, mapper.getOperation1(), mapper.getOperation2(), addedOperationInvocations));
                }
            }
        }
    }

    public static List<OperationInvocation> getInvocationsInSourceOperationAfterExtraction(UMLOperationBodyMapper mapper) {
        List<OperationInvocation> operationInvocations = mapper.getOperation2().getAllOperationInvocations();
        for (StatementObject statement : mapper.getNonMappedLeavesT2()) {
            ExtractOperationDetection.addStatementInvocations(operationInvocations, statement);
        }
        return operationInvocations;
    }

    public static void addStatementInvocations(List<OperationInvocation> operationInvocations, StatementObject statement) {
        Map<String, List<OperationInvocation>> statementMethodInvocationMap = statement.getMethodInvocationMap();
        for (String key : statementMethodInvocationMap.keySet()) {
            for (OperationInvocation operationInvocation : statementMethodInvocationMap.get(key)) {
                if (ExtractOperationDetection.containsInvocation(operationInvocations, operationInvocation)) continue;
                operationInvocations.add(operationInvocation);
            }
        }
        List<LambdaExpressionObject> lambdas = statement.getLambdas();
        for (LambdaExpressionObject lambda2 : lambdas) {
            if (lambda2.getBody() != null) {
                for (OperationInvocation statementInvocation : lambda2.getBody().getAllOperationInvocations()) {
                    if (ExtractOperationDetection.containsInvocation(operationInvocations, statementInvocation)) continue;
                    operationInvocations.add(statementInvocation);
                }
            }
            if (lambda2.getExpression() == null) continue;
            Map<String, List<OperationInvocation>> map = lambda2.getExpression().getMethodInvocationMap();
            for (String key : map.keySet()) {
                for (OperationInvocation statementInvocation : map.get(key)) {
                    if (ExtractOperationDetection.containsInvocation(operationInvocations, statementInvocation)) continue;
                    operationInvocations.add(statementInvocation);
                }
            }
        }
    }

    public static boolean containsInvocation(List<OperationInvocation> operationInvocations, OperationInvocation invocation) {
        for (OperationInvocation operationInvocation : operationInvocations) {
            if (!operationInvocation.getLocationInfo().equals(invocation.getLocationInfo())) continue;
            return true;
        }
        return false;
    }

    private List<OperationInvocation> matchingInvocations(UMLOperation operation, List<OperationInvocation> operationInvocations, Map<String, UMLType> variableTypeMap) {
        ArrayList<OperationInvocation> addedOperationInvocations = new ArrayList<OperationInvocation>();
        for (OperationInvocation invocation : operationInvocations) {
            if (!invocation.matchesOperation(operation, variableTypeMap, this.modelDiff)) continue;
            addedOperationInvocations.add(invocation);
        }
        return addedOperationInvocations;
    }

    private void generateCallTree(UMLOperation operation, CallTreeNode parent, CallTree callTree) {
        List<OperationInvocation> invocations = operation.getAllOperationInvocations();
        for (UMLOperation addedOperation : this.addedOperations) {
            for (OperationInvocation invocation : invocations) {
                if (!invocation.matchesOperation(addedOperation, operation.variableTypeMap(), this.modelDiff) || callTree.contains(addedOperation)) continue;
                CallTreeNode node = new CallTreeNode(operation, addedOperation, invocation);
                parent.addChild(node);
                this.generateCallTree(addedOperation, node, callTree);
            }
        }
    }

    private UMLOperationBodyMapper createMapperForExtractedMethod(UMLOperationBodyMapper mapper, UMLOperation originalOperation, UMLOperation addedOperation, OperationInvocation addedOperationInvocation) throws RefactoringMinerTimedOutException {
        List<UMLParameter> originalMethodParameters = originalOperation.getParametersWithoutReturnType();
        LinkedHashMap<UMLParameter, UMLParameter> originalMethodParametersPassedAsArgumentsMappedToCalledMethodParameters = new LinkedHashMap<UMLParameter, UMLParameter>();
        List<String> arguments = addedOperationInvocation.getArguments();
        List<UMLParameter> parameters = addedOperation.getParametersWithoutReturnType();
        LinkedHashMap<String, String> parameterToArgumentMap = new LinkedHashMap<String, String>();
        int size = Math.min(arguments.size(), parameters.size());
        for (int i = 0; i < size; ++i) {
            String argumentName = arguments.get(i);
            String parameterName = parameters.get(i).getName();
            parameterToArgumentMap.put(parameterName, argumentName);
            for (UMLParameter originalMethodParameter : originalMethodParameters) {
                if (!originalMethodParameter.getName().equals(argumentName)) continue;
                originalMethodParametersPassedAsArgumentsMappedToCalledMethodParameters.put(originalMethodParameter, parameters.get(i));
            }
        }
        if (this.parameterTypesMatch(originalMethodParametersPassedAsArgumentsMappedToCalledMethodParameters)) {
            UMLOperation delegateMethod = this.findDelegateMethod(originalOperation, addedOperation, addedOperationInvocation);
            return new UMLOperationBodyMapper(mapper, delegateMethod != null ? delegateMethod : addedOperation, new LinkedHashMap<String, String>(), parameterToArgumentMap, this.classDiff);
        }
        return null;
    }

    private boolean extractMatchCondition(UMLOperationBodyMapper operationBodyMapper, List<AbstractCodeMapping> additionalExactMatches) {
        int mappings = operationBodyMapper.mappingsWithoutBlocks();
        int nonMappedElementsT1 = operationBodyMapper.nonMappedElementsT1();
        int nonMappedElementsT2 = operationBodyMapper.nonMappedElementsT2();
        ArrayList<AbstractCodeMapping> exactMatchList = new ArrayList<AbstractCodeMapping>(operationBodyMapper.getExactMatches());
        boolean exceptionHandlingExactMatch = false;
        boolean throwsNewExceptionExactMatch = false;
        if (exactMatchList.size() == 1) {
            AbstractCodeMapping mapping = (AbstractCodeMapping)exactMatchList.get(0);
            if (mapping.getFragment1() instanceof StatementObject && mapping.getFragment2() instanceof StatementObject) {
                StatementObject statement1 = (StatementObject)mapping.getFragment1();
                StatementObject statement2 = (StatementObject)mapping.getFragment2();
                if (statement1.getParent().getString().startsWith("catch(") && statement2.getParent().getString().startsWith("catch(")) {
                    exceptionHandlingExactMatch = true;
                }
            }
            if (mapping.getFragment1().throwsNewException() && mapping.getFragment2().throwsNewException()) {
                throwsNewExceptionExactMatch = true;
            }
        }
        exactMatchList.addAll(additionalExactMatches);
        int exactMatches = exactMatchList.size();
        return mappings > 0 && (mappings > nonMappedElementsT2 || mappings > 1 && mappings >= nonMappedElementsT2 || exactMatches >= mappings && nonMappedElementsT1 == 0 || exactMatches == 1 && !throwsNewExceptionExactMatch && nonMappedElementsT2 - exactMatches <= 10 || !exceptionHandlingExactMatch && exactMatches > 1 && additionalExactMatches.size() < exactMatches && nonMappedElementsT2 - exactMatches < 20 || mappings == 1 && mappings > operationBodyMapper.nonMappedLeafElementsT2()) || this.argumentExtractedWithDefaultReturnAdded(operationBodyMapper);
    }

    private boolean argumentExtractedWithDefaultReturnAdded(UMLOperationBodyMapper operationBodyMapper) {
        ArrayList<AbstractCodeMapping> totalMappings = new ArrayList<AbstractCodeMapping>(operationBodyMapper.getMappings());
        ArrayList<CompositeStatementObject> nonMappedInnerNodesT2 = new ArrayList<CompositeStatementObject>(operationBodyMapper.getNonMappedInnerNodesT2());
        nonMappedInnerNodesT2.removeIf(compositeStatementObject -> compositeStatementObject.toString().equals("{"));
        List<StatementObject> nonMappedLeavesT2 = operationBodyMapper.getNonMappedLeavesT2();
        return totalMappings.size() == 1 && ((AbstractCodeMapping)totalMappings.get(0)).containsReplacement(Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_RETURN_EXPRESSION) && nonMappedInnerNodesT2.size() == 1 && ((CompositeStatementObject)nonMappedInnerNodesT2.get(0)).toString().startsWith("if") && nonMappedLeavesT2.size() == 1 && nonMappedLeavesT2.get(0).toString().startsWith("return ");
    }

    private UMLOperation findDelegateMethod(UMLOperation originalOperation, UMLOperation addedOperation, OperationInvocation addedOperationInvocation) {
        OperationInvocation delegateMethodInvocation = addedOperation.isDelegate();
        if (originalOperation.isDelegate() == null && delegateMethodInvocation != null && !originalOperation.getAllOperationInvocations().contains(addedOperationInvocation)) {
            for (UMLOperation operation : this.addedOperations) {
                if (!delegateMethodInvocation.matchesOperation(operation, addedOperation.variableTypeMap(), this.modelDiff)) continue;
                return operation;
            }
        }
        return null;
    }

    private boolean parameterTypesMatch(Map<UMLParameter, UMLParameter> originalMethodParametersPassedAsArgumentsMappedToCalledMethodParameters) {
        for (UMLParameter key : originalMethodParametersPassedAsArgumentsMappedToCalledMethodParameters.keySet()) {
            UMLParameter value = originalMethodParametersPassedAsArgumentsMappedToCalledMethodParameters.get(key);
            if (key.getType().equals(value.getType()) || key.getType().equalsWithSubType(value.getType()) || this.modelDiff.isSubclassOf(key.getType().getClassType(), value.getType().getClassType())) continue;
            return false;
        }
        return true;
    }
}

