/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff;

import org.jetbrains.research.kotlinrminer.common.util.PrefixSuffixUtils;
import org.jetbrains.research.kotlinrminer.ide.diff.RenamePattern;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLClass;

public class MovedClassToAnotherSourceFolder {
    private final UMLClass originalClass;
    private final UMLClass movedClass;
    private final String originalPath;
    private final String movedPath;

    public MovedClassToAnotherSourceFolder(UMLClass originalClass, UMLClass movedClass, String originalPath, String movedPath) {
        this.originalClass = originalClass;
        this.movedClass = movedClass;
        this.originalPath = originalPath;
        this.movedPath = movedPath;
    }

    public String getOriginalClassName() {
        return this.originalClass.getQualifiedName();
    }

    public String getMovedClassName() {
        return this.movedClass.getQualifiedName();
    }

    public UMLClass getOriginalClass() {
        return this.originalClass;
    }

    public UMLClass getMovedClass() {
        return this.movedClass;
    }

    public RenamePattern getRenamePattern() {
        int separatorPos = PrefixSuffixUtils.separatorPosOfCommonSuffix('/', this.originalPath, this.movedPath);
        if (separatorPos == -1) {
            return new RenamePattern(this.originalPath, this.movedPath);
        }
        String original = this.originalPath.substring(0, this.originalPath.length() - separatorPos);
        String moved = this.movedPath.substring(0, this.movedPath.length() - separatorPos);
        return new RenamePattern(original, moved);
    }
}

