/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff;

import org.jetbrains.research.kotlinrminer.ide.uml.UMLGeneralization;

public class UMLGeneralizationDiff
implements Comparable<UMLGeneralizationDiff> {
    private final UMLGeneralization removedGeneralization;
    private final UMLGeneralization addedGeneralization;
    private boolean parentChanged;
    private boolean childChanged;

    public UMLGeneralizationDiff(UMLGeneralization removedGeneralization, UMLGeneralization addedGeneralization) {
        this.removedGeneralization = removedGeneralization;
        this.addedGeneralization = addedGeneralization;
        this.parentChanged = false;
        this.childChanged = false;
        if (!removedGeneralization.getParent().equals(addedGeneralization.getParent())) {
            this.parentChanged = true;
        }
        if (!removedGeneralization.getChild().equals(addedGeneralization.getChild())) {
            this.childChanged = true;
        }
    }

    public UMLGeneralization getRemovedGeneralization() {
        return this.removedGeneralization;
    }

    public UMLGeneralization getAddedGeneralization() {
        return this.addedGeneralization;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.parentChanged || this.childChanged) {
            sb.append("generalization ").append(this.removedGeneralization).append(":").append("\n");
        }
        if (this.childChanged) {
            sb.append("\t").append("child changed from ").append(this.removedGeneralization.getChild()).append(" to ").append(this.addedGeneralization.getChild()).append("\n");
        }
        if (this.parentChanged) {
            sb.append("\t").append("parent changed from ").append(this.removedGeneralization.getParent()).append(" to ").append(this.addedGeneralization.getParent()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public int compareTo(UMLGeneralizationDiff generalizationDiff) {
        int compare = this.removedGeneralization.compareTo(generalizationDiff.removedGeneralization);
        if (compare == 0) {
            return this.addedGeneralization.compareTo(generalizationDiff.addedGeneralization);
        }
        return compare;
    }
}

