/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeMapping;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLAnnotationDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLAnnotationListDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLParameterDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.AddMethodAnnotationRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.AddParameterRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.ModifyMethodAnnotationRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.RemoveMethodAnnotationRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.RemoveParameterRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.ReorderParameterRefactoring;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAnnotation;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLParameter;

public class UMLOperationDiff {
    private final UMLOperation removedOperation;
    private final UMLOperation addedOperation;
    private final List<UMLParameter> addedParameters;
    private final List<UMLParameter> removedParameters;
    private final List<UMLParameterDiff> parameterDiffList;
    private final UMLAnnotationListDiff annotationListDiff;
    private boolean visibilityChanged;
    private boolean abstractionChanged;
    private boolean returnTypeChanged;
    private boolean qualifiedReturnTypeChanged;
    private final boolean operationRenamed;
    private boolean parametersReordered;
    private Set<AbstractCodeMapping> mappings = new LinkedHashSet<AbstractCodeMapping>();

    public UMLOperationDiff(UMLOperation removedOperation, UMLOperation addedOperation) {
        UMLParameterDiff parameterDiff;
        UMLParameter addedParameter;
        Iterator<UMLParameter> addedParameterIterator;
        UMLParameter removedParameter;
        this.removedOperation = removedOperation;
        this.addedOperation = addedOperation;
        this.addedParameters = new ArrayList<UMLParameter>();
        this.removedParameters = new ArrayList<UMLParameter>();
        this.parameterDiffList = new ArrayList<UMLParameterDiff>();
        this.visibilityChanged = false;
        this.abstractionChanged = false;
        this.returnTypeChanged = false;
        boolean bl = this.operationRenamed = !removedOperation.getName().equals(addedOperation.getName());
        if (!removedOperation.getVisibility().equals(addedOperation.getVisibility())) {
            this.visibilityChanged = true;
        }
        if (removedOperation.isAbstract() != addedOperation.isAbstract()) {
            this.abstractionChanged = true;
        }
        if (!removedOperation.equalReturnParameter(addedOperation)) {
            this.returnTypeChanged = true;
        } else if (!removedOperation.equalQualifiedReturnParameter(addedOperation)) {
            this.qualifiedReturnTypeChanged = true;
        }
        this.annotationListDiff = new UMLAnnotationListDiff(removedOperation.getAnnotations(), addedOperation.getAnnotations());
        List<AbstractMap.SimpleEntry<UMLParameter, UMLParameter>> matchedParameters = this.updateAddedRemovedParameters(removedOperation, addedOperation);
        for (AbstractMap.SimpleEntry<UMLParameter, UMLParameter> matchedParameter : matchedParameters) {
            UMLParameter parameter1 = matchedParameter.getKey();
            UMLParameter parameter2 = matchedParameter.getValue();
            UMLParameterDiff parameterDiff2 = new UMLParameterDiff(parameter1, parameter2, removedOperation, addedOperation, this.mappings);
            this.parameterDiffList.add(parameterDiff2);
        }
        int matchedParameterCount = matchedParameters.size() / 2;
        List<String> parameterNames1 = removedOperation.getParameterNameList();
        List<String> parameterNames2 = addedOperation.getParameterNameList();
        if (this.removedParameters.isEmpty() && this.addedParameters.isEmpty() && matchedParameterCount == parameterNames1.size() && matchedParameterCount == parameterNames2.size() && parameterNames1.size() > 1 && !parameterNames1.equals(parameterNames2)) {
            this.parametersReordered = true;
        }
        Iterator<UMLParameter> removedParameterIterator = this.removedParameters.iterator();
        block1: while (removedParameterIterator.hasNext()) {
            removedParameter = removedParameterIterator.next();
            addedParameterIterator = this.addedParameters.iterator();
            while (addedParameterIterator.hasNext()) {
                addedParameter = addedParameterIterator.next();
                if (!removedParameter.getName().equals(addedParameter.getName())) continue;
                parameterDiff = new UMLParameterDiff(removedParameter, addedParameter, removedOperation, addedOperation, this.mappings);
                this.parameterDiffList.add(parameterDiff);
                addedParameterIterator.remove();
                removedParameterIterator.remove();
                continue block1;
            }
        }
        removedParameterIterator = this.removedParameters.iterator();
        block3: while (removedParameterIterator.hasNext()) {
            removedParameter = removedParameterIterator.next();
            addedParameterIterator = this.addedParameters.iterator();
            while (addedParameterIterator.hasNext()) {
                addedParameter = addedParameterIterator.next();
                if (!removedParameter.getType().equalsQualified(addedParameter.getType()) || this.existsAnotherAddedParameterWithTheSameType(addedParameter)) continue;
                parameterDiff = new UMLParameterDiff(removedParameter, addedParameter, removedOperation, addedOperation, this.mappings);
                this.parameterDiffList.add(parameterDiff);
                addedParameterIterator.remove();
                removedParameterIterator.remove();
                continue block3;
            }
        }
        List<UMLParameter> removedParametersWithoutReturnType = removedOperation.getParametersWithoutReturnType();
        List<UMLParameter> addedParametersWithoutReturnType = addedOperation.getParametersWithoutReturnType();
        if (matchedParameterCount == removedParametersWithoutReturnType.size() - 1 && matchedParameterCount == addedParametersWithoutReturnType.size() - 1) {
            Iterator<UMLParameter> removedParameterIterator2 = this.removedParameters.iterator();
            block5: while (removedParameterIterator2.hasNext()) {
                UMLParameter removedParameter2 = removedParameterIterator2.next();
                int indexOfRemovedParameter = removedParametersWithoutReturnType.indexOf(removedParameter2);
                Iterator<UMLParameter> addedParameterIterator2 = this.addedParameters.iterator();
                while (addedParameterIterator2.hasNext()) {
                    UMLParameter addedParameter2 = addedParameterIterator2.next();
                    int indexOfAddedParameter = addedParametersWithoutReturnType.indexOf(addedParameter2);
                    if (indexOfRemovedParameter != indexOfAddedParameter) continue;
                    UMLParameterDiff parameterDiff3 = new UMLParameterDiff(removedParameter2, addedParameter2, removedOperation, addedOperation, this.mappings);
                    this.parameterDiffList.add(parameterDiff3);
                    addedParameterIterator2.remove();
                    removedParameterIterator2.remove();
                    continue block5;
                }
            }
        }
    }

    public UMLOperationDiff(UMLOperation removedOperation, UMLOperation addedOperation, Set<AbstractCodeMapping> mappings) {
        this(removedOperation, addedOperation);
        this.mappings = mappings;
    }

    private boolean existsAnotherAddedParameterWithTheSameType(UMLParameter parameter) {
        if (this.removedOperation.hasTwoParametersWithTheSameType() && this.addedOperation.hasTwoParametersWithTheSameType()) {
            return false;
        }
        for (UMLParameter addedParameter : this.addedParameters) {
            if (addedParameter.getName().equals(parameter.getName()) || !addedParameter.getType().equalsQualified(parameter.getType())) continue;
            return true;
        }
        return false;
    }

    private List<AbstractMap.SimpleEntry<UMLParameter, UMLParameter>> updateAddedRemovedParameters(UMLOperation removedOperation, UMLOperation addedOperation) {
        boolean found;
        ArrayList<AbstractMap.SimpleEntry<UMLParameter, UMLParameter>> matchedParameters = new ArrayList<AbstractMap.SimpleEntry<UMLParameter, UMLParameter>>();
        for (UMLParameter parameter1 : removedOperation.getParameters()) {
            if (parameter1.getKind().equals("return")) continue;
            found = false;
            for (UMLParameter parameter2 : addedOperation.getParameters()) {
                if (!parameter1.equalsIncludingName(parameter2)) continue;
                matchedParameters.add(new AbstractMap.SimpleEntry<UMLParameter, UMLParameter>(parameter1, parameter2));
                found = true;
                break;
            }
            if (found) continue;
            this.removedParameters.add(parameter1);
        }
        for (UMLParameter parameter1 : addedOperation.getParameters()) {
            if (parameter1.getKind().equals("return")) continue;
            found = false;
            for (UMLParameter parameter2 : removedOperation.getParameters()) {
                if (!parameter1.equalsIncludingName(parameter2)) continue;
                matchedParameters.add(new AbstractMap.SimpleEntry<UMLParameter, UMLParameter>(parameter2, parameter1));
                found = true;
                break;
            }
            if (found) continue;
            this.addedParameters.add(parameter1);
        }
        return matchedParameters;
    }

    public List<UMLParameterDiff> getParameterDiffList() {
        return this.parameterDiffList;
    }

    public UMLOperation getRemovedOperation() {
        return this.removedOperation;
    }

    public UMLOperation getAddedOperation() {
        return this.addedOperation;
    }

    public List<UMLParameter> getAddedParameters() {
        return this.addedParameters;
    }

    public List<UMLParameter> getRemovedParameters() {
        return this.removedParameters;
    }

    public boolean isOperationRenamed() {
        return this.operationRenamed;
    }

    public boolean isEmpty() {
        return this.addedParameters.isEmpty() && this.removedParameters.isEmpty() && this.parameterDiffList.isEmpty() && !this.visibilityChanged && !this.abstractionChanged && !this.returnTypeChanged && !this.operationRenamed && this.annotationListDiff.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isEmpty()) {
            sb.append("\t").append(this.removedOperation).append("\n");
        }
        if (this.operationRenamed) {
            sb.append("\t").append("renamed from ").append(this.removedOperation.getName()).append(" to ").append(this.addedOperation.getName()).append("\n");
        }
        if (this.visibilityChanged) {
            sb.append("\t").append("visibility changed from ").append(this.removedOperation.getVisibility()).append(" to ").append(this.addedOperation.getVisibility()).append("\n");
        }
        if (this.abstractionChanged) {
            sb.append("\t").append("abstraction changed from ").append(this.removedOperation.isAbstract() ? "abstract" : "concrete").append(" to ").append(this.addedOperation.isAbstract() ? "abstract" : "concrete").append("\n");
        }
        if (this.returnTypeChanged || this.qualifiedReturnTypeChanged) {
            sb.append("\t").append("return type changed from ").append(this.removedOperation.getReturnParameter()).append(" to ").append(this.addedOperation.getReturnParameter()).append("\n");
        }
        for (UMLParameter umlParameter : this.removedParameters) {
            sb.append("\t").append("parameter ").append(umlParameter).append(" removed").append("\n");
        }
        for (UMLParameter umlParameter : this.addedParameters) {
            sb.append("\t").append("parameter ").append(umlParameter).append(" added").append("\n");
        }
        for (UMLParameterDiff parameterDiff : this.parameterDiffList) {
            sb.append(parameterDiff);
        }
        for (UMLAnnotation annotation : this.annotationListDiff.getRemovedAnnotations()) {
            sb.append("\t").append("annotation ").append(annotation).append(" removed").append("\n");
        }
        for (UMLAnnotation annotation : this.annotationListDiff.getAddedAnnotations()) {
            sb.append("\t").append("annotation ").append(annotation).append(" added").append("\n");
        }
        for (UMLAnnotationDiff annotationDiff : this.annotationListDiff.getAnnotationDiffList()) {
            sb.append("\t").append("annotation ").append(annotationDiff.getRemovedAnnotation()).append(" modified to ").append(annotationDiff.getAddedAnnotation()).append("\n");
        }
        return sb.toString();
    }

    public Set<Refactoring> getRefactorings() {
        Refactoring refactoring;
        LinkedHashSet<Refactoring> refactorings = new LinkedHashSet<Refactoring>();
        for (UMLParameterDiff parameterDiff : this.getParameterDiffList()) {
            refactorings.addAll(parameterDiff.getRefactorings());
        }
        if (this.removedParameters.isEmpty()) {
            for (UMLParameter umlParameter : this.addedParameters) {
                refactoring = new AddParameterRefactoring(umlParameter, this.removedOperation, this.addedOperation);
                refactorings.add(refactoring);
            }
        }
        if (this.addedParameters.isEmpty()) {
            for (UMLParameter umlParameter : this.removedParameters) {
                refactoring = new RemoveParameterRefactoring(umlParameter, this.removedOperation, this.addedOperation);
                refactorings.add(refactoring);
            }
        }
        if (this.parametersReordered) {
            ReorderParameterRefactoring refactoring2 = new ReorderParameterRefactoring(this.removedOperation, this.addedOperation);
            refactorings.add(refactoring2);
        }
        for (UMLAnnotation annotation : this.annotationListDiff.getAddedAnnotations()) {
            refactoring = new AddMethodAnnotationRefactoring(annotation, this.removedOperation, this.addedOperation);
            refactorings.add(refactoring);
        }
        for (UMLAnnotation annotation : this.annotationListDiff.getRemovedAnnotations()) {
            refactoring = new RemoveMethodAnnotationRefactoring(annotation, this.removedOperation, this.addedOperation);
            refactorings.add(refactoring);
        }
        for (UMLAnnotationDiff annotationDiff : this.annotationListDiff.getAnnotationDiffList()) {
            refactoring = new ModifyMethodAnnotationRefactoring(annotationDiff.getRemovedAnnotation(), annotationDiff.getAddedAnnotation(), this.removedOperation, this.addedOperation);
            refactorings.add(refactoring);
        }
        return refactorings;
    }
}

