/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff.refactoring;

import java.util.Set;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeMapping;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAttribute;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;

public class CandidateMergeVariableRefactoring {
    private final Set<String> mergedVariables;
    private final String newVariable;
    private final UMLOperation operationBefore;
    private final UMLOperation operationAfter;
    private final Set<AbstractCodeMapping> variableReferences;
    private Set<UMLAttribute> mergedAttributes;
    private UMLAttribute newAttribute;

    public CandidateMergeVariableRefactoring(Set<String> mergedVariables, String newVariable, UMLOperation operationBefore, UMLOperation operationAfter, Set<AbstractCodeMapping> variableReferences) {
        this.mergedVariables = mergedVariables;
        this.newVariable = newVariable;
        this.operationBefore = operationBefore;
        this.operationAfter = operationAfter;
        this.variableReferences = variableReferences;
    }

    public Set<String> getMergedVariables() {
        return this.mergedVariables;
    }

    public String getNewVariable() {
        return this.newVariable;
    }

    public UMLOperation getOperationBefore() {
        return this.operationBefore;
    }

    public UMLOperation getOperationAfter() {
        return this.operationAfter;
    }

    public Set<AbstractCodeMapping> getVariableReferences() {
        return this.variableReferences;
    }

    public Set<UMLAttribute> getMergedAttributes() {
        return this.mergedAttributes;
    }

    public void setMergedAttributes(Set<UMLAttribute> mergedAttributes) {
        this.mergedAttributes = mergedAttributes;
    }

    public UMLAttribute getNewAttribute() {
        return this.newAttribute;
    }

    public void setNewAttribute(UMLAttribute newAttribute) {
        this.newAttribute = newAttribute;
    }

    public String toString() {
        return "Merge Attribute\t" + this.mergedVariables + " to " + this.newVariable + " in method " + this.operationAfter + " in class " + this.operationAfter.getClassName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mergedVariables == null ? 0 : this.mergedVariables.hashCode());
        result = 31 * result + (this.newVariable == null ? 0 : this.newVariable.hashCode());
        result = 31 * result + (this.operationAfter == null ? 0 : this.operationAfter.hashCode());
        result = 31 * result + (this.operationBefore == null ? 0 : this.operationBefore.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CandidateMergeVariableRefactoring other = (CandidateMergeVariableRefactoring)obj;
        if (this.mergedVariables == null ? other.mergedVariables != null : !this.mergedVariables.equals(other.mergedVariables)) {
            return false;
        }
        if (this.newVariable == null ? other.newVariable != null : !this.newVariable.equals(other.newVariable)) {
            return false;
        }
        if (this.operationAfter == null ? other.operationAfter != null : !this.operationAfter.equals(other.operationAfter)) {
            return false;
        }
        if (this.operationBefore == null) {
            return other.operationBefore == null;
        }
        return this.operationBefore.equals(other.operationBefore);
    }
}

