/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff.refactoring;

import java.util.Set;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeMapping;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAttribute;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;

public class CandidateSplitVariableRefactoring {
    private final String oldVariable;
    private final Set<String> splitVariables;
    private final UMLOperation operationBefore;
    private final UMLOperation operationAfter;
    private final Set<AbstractCodeMapping> variableReferences;
    private UMLAttribute oldAttribute;
    private Set<UMLAttribute> splitAttributes;

    public CandidateSplitVariableRefactoring(String oldVariable, Set<String> splitVariables, UMLOperation operationBefore, UMLOperation operationAfter, Set<AbstractCodeMapping> variableReferences) {
        this.oldVariable = oldVariable;
        this.splitVariables = splitVariables;
        this.operationBefore = operationBefore;
        this.operationAfter = operationAfter;
        this.variableReferences = variableReferences;
    }

    public String getOldVariable() {
        return this.oldVariable;
    }

    public Set<String> getSplitVariables() {
        return this.splitVariables;
    }

    public UMLOperation getOperationBefore() {
        return this.operationBefore;
    }

    public UMLOperation getOperationAfter() {
        return this.operationAfter;
    }

    public Set<AbstractCodeMapping> getVariableReferences() {
        return this.variableReferences;
    }

    public Set<UMLAttribute> getSplitAttributes() {
        return this.splitAttributes;
    }

    public void setSplitAttributes(Set<UMLAttribute> splitAttributes) {
        this.splitAttributes = splitAttributes;
    }

    public UMLAttribute getOldAttribute() {
        return this.oldAttribute;
    }

    public void setOldAttribute(UMLAttribute oldAttribute) {
        this.oldAttribute = oldAttribute;
    }

    public String toString() {
        return "Split Attribute\t" + this.oldVariable + " to " + this.splitVariables + " in method " + this.operationAfter + " in class " + this.operationAfter.getClassName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.oldVariable == null ? 0 : this.oldVariable.hashCode());
        result = 31 * result + (this.operationAfter == null ? 0 : this.operationAfter.hashCode());
        result = 31 * result + (this.operationBefore == null ? 0 : this.operationBefore.hashCode());
        result = 31 * result + (this.splitVariables == null ? 0 : this.splitVariables.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CandidateSplitVariableRefactoring other = (CandidateSplitVariableRefactoring)obj;
        if (this.oldVariable == null ? other.oldVariable != null : !this.oldVariable.equals(other.oldVariable)) {
            return false;
        }
        if (this.operationAfter == null ? other.operationAfter != null : !this.operationAfter.equals(other.operationAfter)) {
            return false;
        }
        if (this.operationBefore == null ? other.operationBefore != null : !this.operationBefore.equals(other.operationBefore)) {
            return false;
        }
        if (this.splitVariables == null) {
            return other.splitVariables == null;
        }
        return this.splitVariables.equals(other.splitVariables);
    }
}

