/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff.refactoring;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jetbrains.research.kotlinrminer.common.RefactoringType;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLClassBaseDiff;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAttribute;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLClass;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;

public class ExtractClassRefactoring
implements Refactoring {
    private final UMLClass extractedClass;
    private final UMLClassBaseDiff classDiff;
    private final Set<UMLOperation> extractedOperations;
    private final Set<UMLAttribute> extractedAttributes;
    private final UMLAttribute attributeOfExtractedClassTypeInOriginalClass;

    public ExtractClassRefactoring(UMLClass extractedClass, UMLClassBaseDiff classDiff, Set<UMLOperation> extractedOperations, Set<UMLAttribute> extractedAttributes, UMLAttribute attributeOfExtractedClassType) {
        this.extractedClass = extractedClass;
        this.classDiff = classDiff;
        this.extractedOperations = extractedOperations;
        this.extractedAttributes = extractedAttributes;
        this.attributeOfExtractedClassTypeInOriginalClass = attributeOfExtractedClassType;
    }

    @Override
    public String toString() {
        return this.getName() + " " + this.extractedClass + " from class " + this.classDiff.getOriginalClass();
    }

    @Override
    public RefactoringType getRefactoringType() {
        if (this.extractedClass.isSubTypeOf(this.classDiff.getOriginalClass()) || this.extractedClass.isSubTypeOf(this.classDiff.getNextClass())) {
            return RefactoringType.EXTRACT_SUBCLASS;
        }
        return RefactoringType.EXTRACT_CLASS;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    public UMLClass getExtractedClass() {
        return this.extractedClass;
    }

    public UMLClass getOriginalClass() {
        return this.classDiff.getOriginalClass();
    }

    public Set<UMLOperation> getExtractedOperations() {
        return this.extractedOperations;
    }

    public Set<UMLAttribute> getExtractedAttributes() {
        return this.extractedAttributes;
    }

    public UMLAttribute getAttributeOfExtractedClassTypeInOriginalClass() {
        return this.attributeOfExtractedClassTypeInOriginalClass;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOriginalClass().getLocationInfo().getFilePath(), (Object)this.getOriginalClass().getQualifiedName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getExtractedClass().getLocationInfo().getFilePath(), (Object)this.getExtractedClass().getQualifiedName()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.classDiff.getOriginalClass().codeRange().setDescription("original type declaration").setCodeElement(this.classDiff.getOriginalClass().getQualifiedName()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.extractedClass.codeRange().setDescription("extracted type declaration").setCodeElement(this.extractedClass.getQualifiedName()));
        return ranges;
    }
}

