/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff.refactoring;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jetbrains.research.kotlinrminer.common.RefactoringType;
import org.jetbrains.research.kotlinrminer.common.replacement.Replacement;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeFragment;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeMapping;
import org.jetbrains.research.kotlinrminer.ide.decomposition.CompositeStatementObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.OperationInvocation;
import org.jetbrains.research.kotlinrminer.ide.decomposition.StatementObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.UMLOperationBodyMapper;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;

public class ExtractOperationRefactoring
implements Refactoring {
    private final UMLOperation extractedOperation;
    private final UMLOperation sourceOperationBeforeExtraction;
    private final UMLOperation sourceOperationAfterExtraction;
    private final List<OperationInvocation> extractedOperationInvocations;
    private final Set<Replacement> replacements;
    private final Set<AbstractCodeFragment> extractedCodeFragmentsFromSourceOperation;
    private final Set<AbstractCodeFragment> extractedCodeFragmentsToExtractedOperation;
    private final UMLOperationBodyMapper bodyMapper;

    public ExtractOperationRefactoring(UMLOperationBodyMapper bodyMapper, UMLOperation sourceOperationAfterExtraction, List<OperationInvocation> operationInvocations) {
        this.bodyMapper = bodyMapper;
        this.extractedOperation = bodyMapper.getOperation2();
        this.sourceOperationBeforeExtraction = bodyMapper.getOperation1();
        this.sourceOperationAfterExtraction = sourceOperationAfterExtraction;
        this.extractedOperationInvocations = operationInvocations;
        this.replacements = bodyMapper.getReplacements();
        this.extractedCodeFragmentsFromSourceOperation = new LinkedHashSet<AbstractCodeFragment>();
        this.extractedCodeFragmentsToExtractedOperation = new LinkedHashSet<AbstractCodeFragment>();
        for (AbstractCodeMapping mapping : bodyMapper.getMappings()) {
            this.extractedCodeFragmentsFromSourceOperation.add(mapping.getFragment1());
            this.extractedCodeFragmentsToExtractedOperation.add(mapping.getFragment2());
        }
    }

    public ExtractOperationRefactoring(UMLOperationBodyMapper bodyMapper, UMLOperation extractedOperation, UMLOperation sourceOperationBeforeExtraction, UMLOperation sourceOperationAfterExtraction, List<OperationInvocation> operationInvocations) {
        this.bodyMapper = bodyMapper;
        this.extractedOperation = extractedOperation;
        this.sourceOperationBeforeExtraction = sourceOperationBeforeExtraction;
        this.sourceOperationAfterExtraction = sourceOperationAfterExtraction;
        this.extractedOperationInvocations = operationInvocations;
        this.replacements = bodyMapper.getReplacements();
        this.extractedCodeFragmentsFromSourceOperation = new LinkedHashSet<AbstractCodeFragment>();
        this.extractedCodeFragmentsToExtractedOperation = new LinkedHashSet<AbstractCodeFragment>();
        for (AbstractCodeMapping mapping : bodyMapper.getMappings()) {
            this.extractedCodeFragmentsFromSourceOperation.add(mapping.getFragment1());
            this.extractedCodeFragmentsToExtractedOperation.add(mapping.getFragment2());
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append(" ");
        sb.append(this.extractedOperation);
        sb.append(" extracted from ");
        sb.append(this.sourceOperationBeforeExtraction);
        sb.append(" in class ");
        sb.append(this.getClassName());
        if (this.getRefactoringType().equals((Object)RefactoringType.EXTRACT_AND_MOVE_OPERATION)) {
            sb.append(" & moved to class ");
            sb.append(this.extractedOperation.getClassName());
        }
        return sb.toString();
    }

    private String getClassName() {
        String targetClassName;
        if (this.getRefactoringType().equals((Object)RefactoringType.EXTRACT_AND_MOVE_OPERATION)) {
            return this.getSourceOperationBeforeExtraction().getClassName();
        }
        String sourceClassName = this.getSourceOperationBeforeExtraction().getClassName();
        return sourceClassName.equals(targetClassName = this.getSourceOperationAfterExtraction().getClassName()) ? sourceClassName : targetClassName;
    }

    public UMLOperationBodyMapper getBodyMapper() {
        return this.bodyMapper;
    }

    public UMLOperation getExtractedOperation() {
        return this.extractedOperation;
    }

    public UMLOperation getSourceOperationBeforeExtraction() {
        return this.sourceOperationBeforeExtraction;
    }

    public UMLOperation getSourceOperationAfterExtraction() {
        return this.sourceOperationAfterExtraction;
    }

    public List<OperationInvocation> getExtractedOperationInvocations() {
        return this.extractedOperationInvocations;
    }

    public Set<Replacement> getReplacements() {
        return this.replacements;
    }

    public Set<AbstractCodeFragment> getExtractedCodeFragmentsFromSourceOperation() {
        return this.extractedCodeFragmentsFromSourceOperation;
    }

    public Set<AbstractCodeFragment> getExtractedCodeFragmentsToExtractedOperation() {
        return this.extractedCodeFragmentsToExtractedOperation;
    }

    public CodeRange getSourceOperationCodeRangeBeforeExtraction() {
        return this.sourceOperationBeforeExtraction.codeRange();
    }

    public CodeRange getSourceOperationCodeRangeAfterExtraction() {
        return this.sourceOperationAfterExtraction.codeRange();
    }

    public CodeRange getExtractedOperationCodeRange() {
        return this.extractedOperation.codeRange();
    }

    public CodeRange getExtractedCodeRangeFromSourceOperation() {
        return CodeRange.computeRange(this.extractedCodeFragmentsFromSourceOperation);
    }

    public CodeRange getExtractedCodeRangeToExtractedOperation() {
        return CodeRange.computeRange(this.extractedCodeFragmentsToExtractedOperation);
    }

    public Set<CodeRange> getExtractedOperationInvocationCodeRanges() {
        LinkedHashSet<CodeRange> codeRanges = new LinkedHashSet<CodeRange>();
        for (OperationInvocation invocation : this.extractedOperationInvocations) {
            codeRanges.add(invocation.codeRange());
        }
        return codeRanges;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public RefactoringType getRefactoringType() {
        if (!this.getSourceOperationAfterExtraction().getClassName().equals(this.getExtractedOperation().getClassName())) {
            return RefactoringType.EXTRACT_AND_MOVE_OPERATION;
        }
        return RefactoringType.EXTRACT_OPERATION;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getSourceOperationBeforeExtraction().getLocationInfo().getFilePath(), (Object)this.getSourceOperationBeforeExtraction().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getSourceOperationAfterExtraction().getLocationInfo().getFilePath(), (Object)this.getSourceOperationAfterExtraction().getClassName()));
        pairs.add(new ImmutablePair((Object)this.getExtractedOperation().getLocationInfo().getFilePath(), (Object)this.getExtractedOperation().getClassName()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.getSourceOperationCodeRangeBeforeExtraction().setDescription("source method declaration before extraction").setCodeElement(this.sourceOperationBeforeExtraction.toString()));
        for (AbstractCodeFragment extractedCodeFragment : this.extractedCodeFragmentsFromSourceOperation) {
            ranges.add(extractedCodeFragment.codeRange().setDescription("extracted code from source method declaration"));
        }
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.getExtractedOperationCodeRange().setDescription("extracted method declaration").setCodeElement(this.extractedOperation.toString()));
        for (AbstractCodeFragment abstractCodeFragment : this.extractedCodeFragmentsToExtractedOperation) {
            ranges.add(abstractCodeFragment.codeRange().setDescription("extracted code to extracted method declaration"));
        }
        ranges.add(this.getSourceOperationCodeRangeAfterExtraction().setDescription("source method declaration after extraction").setCodeElement(this.sourceOperationAfterExtraction.toString()));
        for (OperationInvocation operationInvocation : this.extractedOperationInvocations) {
            ranges.add(operationInvocation.codeRange().setDescription("extracted method invocation").setCodeElement(operationInvocation.actualString()));
        }
        for (StatementObject statementObject : this.bodyMapper.getNonMappedLeavesT2()) {
            ranges.add(statementObject.codeRange().setDescription("added statement in extracted method declaration"));
        }
        for (CompositeStatementObject compositeStatementObject : this.bodyMapper.getNonMappedInnerNodesT2()) {
            ranges.add(compositeStatementObject.codeRange().setDescription("added statement in extracted method declaration"));
        }
        return ranges;
    }
}

