/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff.refactoring;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jetbrains.research.kotlinrminer.common.RefactoringType;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLClass;

public class MoveAndRenameClassRefactoring
implements Refactoring {
    private final UMLClass originalClass;
    private final UMLClass renamedClass;

    public MoveAndRenameClassRefactoring(UMLClass originalClass, UMLClass renamedClass) {
        this.originalClass = originalClass;
        this.renamedClass = renamedClass;
    }

    @Override
    public String toString() {
        return this.getName() + " " + this.originalClass.getQualifiedName() + " moved and renamed to " + this.renamedClass.getQualifiedName();
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.MOVE_RENAME_CLASS;
    }

    public String getOriginalClassName() {
        return this.originalClass.getQualifiedName();
    }

    public String getRenamedClassName() {
        return this.renamedClass.getQualifiedName();
    }

    public UMLClass getOriginalClass() {
        return this.originalClass;
    }

    public UMLClass getRenamedClass() {
        return this.renamedClass;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOriginalClass().getLocationInfo().getFilePath(), (Object)this.getOriginalClass().getQualifiedName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getRenamedClass().getLocationInfo().getFilePath(), (Object)this.getRenamedClass().getQualifiedName()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.originalClass.codeRange().setDescription("original type declaration").setCodeElement(this.originalClass.getQualifiedName()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.renamedClass.codeRange().setDescription("moved and renamed type declaration").setCodeElement(this.renamedClass.getQualifiedName()));
        return ranges;
    }
}

