/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff.refactoring;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jetbrains.research.kotlinrminer.common.RefactoringType;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAttribute;

public class MoveAttributeRefactoring
implements Refactoring {
    protected UMLAttribute originalAttribute;
    protected UMLAttribute movedAttribute;
    private volatile int hashCode = 0;

    public MoveAttributeRefactoring(UMLAttribute originalAttribute, UMLAttribute movedAttribute) {
        this.originalAttribute = originalAttribute;
        this.movedAttribute = movedAttribute;
    }

    @Override
    public String toString() {
        return this.getName() + " " + this.getOriginalAttribute().toQualifiedString() + " from class " + this.getSourceClassName() + " to " + this.getMovedAttribute().toQualifiedString() + " from class " + this.getTargetClassName();
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.MOVE_ATTRIBUTE;
    }

    public UMLAttribute getOriginalAttribute() {
        return this.originalAttribute;
    }

    public UMLAttribute getMovedAttribute() {
        return this.movedAttribute;
    }

    public String getSourceClassName() {
        return this.originalAttribute.getClassName();
    }

    public String getTargetClassName() {
        return this.movedAttribute.getClassName();
    }

    public CodeRange getSourceAttributeCodeRangeBeforeMove() {
        return this.originalAttribute.codeRange();
    }

    public CodeRange getTargetAttributeCodeRangeAfterMove() {
        return this.movedAttribute.codeRange();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof MoveAttributeRefactoring) {
            MoveAttributeRefactoring other = (MoveAttributeRefactoring)o;
            return this.originalAttribute.equals(other.originalAttribute) && this.movedAttribute.equals(other.movedAttribute) && this.getSourceClassName().equals(other.getSourceClassName()) && this.getTargetClassName().equals(other.getTargetClassName()) && this.originalAttribute.getLocationInfo().equals(other.originalAttribute.getLocationInfo()) && this.movedAttribute.getLocationInfo().equals(other.movedAttribute.getLocationInfo());
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.originalAttribute.hashCode();
            result = 37 * result + this.movedAttribute.hashCode();
            result = 37 * result + this.getSourceClassName().hashCode();
            result = 37 * result + this.getTargetClassName().hashCode();
            result = 37 * result + this.originalAttribute.getLocationInfo().hashCode();
            this.hashCode = result = 37 * result + this.movedAttribute.getLocationInfo().hashCode();
        }
        return this.hashCode;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOriginalAttribute().getLocationInfo().getFilePath(), (Object)this.getOriginalAttribute().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getMovedAttribute().getLocationInfo().getFilePath(), (Object)this.getMovedAttribute().getClassName()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.originalAttribute.codeRange().setDescription("original attribute declaration").setCodeElement(this.originalAttribute.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.movedAttribute.codeRange().setDescription("moved attribute declaration").setCodeElement(this.movedAttribute.toString()));
        return ranges;
    }
}

