/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff.refactoring;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jetbrains.research.kotlinrminer.common.RefactoringType;
import org.jetbrains.research.kotlinrminer.common.util.PrefixSuffixUtils;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;
import org.jetbrains.research.kotlinrminer.ide.diff.RenamePattern;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLClass;

public class MoveClassRefactoring
implements Refactoring {
    private final UMLClass originalClass;
    private final UMLClass movedClass;

    public MoveClassRefactoring(UMLClass originalClass, UMLClass movedClass) {
        this.originalClass = originalClass;
        this.movedClass = movedClass;
    }

    @Override
    public String toString() {
        return this.getName() + " " + this.originalClass.getQualifiedName() + " moved to " + this.movedClass.getQualifiedName();
    }

    public RenamePattern getRenamePattern() {
        int separatorPos = PrefixSuffixUtils.separatorPosOfCommonSuffix('.', this.originalClass.getQualifiedName(), this.movedClass.getQualifiedName());
        if (separatorPos == -1) {
            return new RenamePattern(this.originalClass.getQualifiedName(), this.movedClass.getQualifiedName());
        }
        String originalPath = this.originalClass.getQualifiedName().substring(0, this.originalClass.getQualifiedName().length() - separatorPos);
        String movedPath = this.movedClass.getQualifiedName().substring(0, this.movedClass.getQualifiedName().length() - separatorPos);
        return new RenamePattern(originalPath, movedPath);
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.MOVE_CLASS;
    }

    public String getOriginalClassName() {
        return this.originalClass.getQualifiedName();
    }

    public String getMovedClassName() {
        return this.movedClass.getQualifiedName();
    }

    public UMLClass getOriginalClass() {
        return this.originalClass;
    }

    public UMLClass getMovedClass() {
        return this.movedClass;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOriginalClass().getLocationInfo().getFilePath(), (Object)this.getOriginalClass().getQualifiedName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getMovedClass().getLocationInfo().getFilePath(), (Object)this.getMovedClass().getQualifiedName()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.originalClass.codeRange().setDescription("original type declaration").setCodeElement(this.originalClass.getQualifiedName()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.movedClass.codeRange().setDescription("moved type declaration").setCodeElement(this.movedClass.getQualifiedName()));
        return ranges;
    }
}

