/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff.refactoring;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jetbrains.research.kotlinrminer.common.RefactoringType;
import org.jetbrains.research.kotlinrminer.common.replacement.Replacement;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.decomposition.UMLOperationBodyMapper;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.MoveAttributeRefactoring;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;

public class MoveOperationRefactoring
implements Refactoring {
    protected final UMLOperation originalOperation;
    protected final UMLOperation movedOperation;
    private final Set<Replacement> replacements;

    public MoveOperationRefactoring(UMLOperationBodyMapper bodyMapper) {
        this.originalOperation = bodyMapper.getOperation1();
        this.movedOperation = bodyMapper.getOperation2();
        this.replacements = bodyMapper.getReplacements();
    }

    public MoveOperationRefactoring(UMLOperation originalOperation, UMLOperation movedOperation) {
        this.originalOperation = originalOperation;
        this.movedOperation = movedOperation;
        this.replacements = new LinkedHashSet<Replacement>();
    }

    @Override
    public String toString() {
        return this.getName() + " " + this.originalOperation + " from class " + this.originalOperation.getClassName() + " to " + this.movedOperation + " from class " + this.movedOperation.getClassName();
    }

    public boolean compatibleWith(MoveAttributeRefactoring ref) {
        if (ref.getMovedAttribute().getClassName().equals(this.movedOperation.getClassName()) && ref.getOriginalAttribute().getClassName().equals(this.originalOperation.getClassName())) {
            List<String> originalOperationVariables = this.originalOperation.getAllVariables();
            List<String> movedOperationVariables = this.movedOperation.getAllVariables();
            return originalOperationVariables.contains(ref.getOriginalAttribute().getName()) && movedOperationVariables.contains(ref.getMovedAttribute().getName());
        }
        return false;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public RefactoringType getRefactoringType() {
        if (!this.originalOperation.getName().equals(this.movedOperation.getName())) {
            return RefactoringType.MOVE_AND_RENAME_OPERATION;
        }
        return RefactoringType.MOVE_OPERATION;
    }

    public UMLOperation getOriginalOperation() {
        return this.originalOperation;
    }

    public UMLOperation getMovedOperation() {
        return this.movedOperation;
    }

    public Set<Replacement> getReplacements() {
        return this.replacements;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOriginalOperation().getLocationInfo().getFilePath(), (Object)this.getOriginalOperation().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getMovedOperation().getLocationInfo().getFilePath(), (Object)this.getMovedOperation().getClassName()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.originalOperation.codeRange().setDescription("original method declaration").setCodeElement(this.originalOperation.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.movedOperation.codeRange().setDescription("moved method declaration").setCodeElement(this.movedOperation.toString()));
        return ranges;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.movedOperation == null ? 0 : this.movedOperation.hashCode());
        result = 31 * result + (this.movedOperation == null ? 0 : this.movedOperation.getLocationInfo().hashCode());
        result = 31 * result + (this.originalOperation == null ? 0 : this.originalOperation.hashCode());
        result = 31 * result + (this.originalOperation == null ? 0 : this.originalOperation.getLocationInfo().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoveOperationRefactoring other = (MoveOperationRefactoring)obj;
        if (this.movedOperation == null) {
            if (other.movedOperation != null) {
                return false;
            }
        } else {
            if (!this.movedOperation.equals(other.movedOperation)) {
                return false;
            }
            if (!this.movedOperation.getLocationInfo().equals(other.movedOperation.getLocationInfo())) {
                return false;
            }
        }
        if (this.originalOperation == null) {
            return other.originalOperation == null;
        }
        if (!this.originalOperation.equals(other.originalOperation)) {
            return false;
        }
        return this.originalOperation.getLocationInfo().equals(other.originalOperation.getLocationInfo());
    }
}

