/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff.refactoring;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jetbrains.research.kotlinrminer.common.RefactoringType;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;
import org.jetbrains.research.kotlinrminer.ide.diff.RenamePattern;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.MoveClassRefactoring;

public class RenamePackageRefactoring
implements Refactoring {
    private final List<MoveClassRefactoring> moveClassRefactorings = new ArrayList<MoveClassRefactoring>();
    private final RenamePattern pattern;

    public RenamePackageRefactoring(MoveClassRefactoring moveClassRefactoring) {
        this.moveClassRefactorings.add(moveClassRefactoring);
        this.pattern = moveClassRefactoring.getRenamePattern();
    }

    public void addMoveClassRefactoring(MoveClassRefactoring moveClassRefactoring) {
        this.moveClassRefactorings.add(moveClassRefactoring);
    }

    public RenamePattern getPattern() {
        return this.pattern;
    }

    public List<MoveClassRefactoring> getMoveClassRefactorings() {
        return this.moveClassRefactorings;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.RENAME_PACKAGE;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append(" ");
        String originalPath = this.pattern.getBefore().endsWith(".") ? this.pattern.getBefore().substring(0, this.pattern.getBefore().length() - 1) : this.pattern.getBefore();
        sb.append(originalPath);
        sb.append(" to ");
        String movedPath = this.pattern.getAfter().endsWith(".") ? this.pattern.getAfter().substring(0, this.pattern.getAfter().length() - 1) : this.pattern.getAfter();
        sb.append(movedPath);
        return sb.toString();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        for (MoveClassRefactoring ref : this.moveClassRefactorings) {
            pairs.add((ImmutablePair<String, String>)new ImmutablePair((Object)ref.getOriginalClass().getLocationInfo().getFilePath(), (Object)ref.getOriginalClassName()));
        }
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        for (MoveClassRefactoring ref : this.moveClassRefactorings) {
            pairs.add((ImmutablePair<String, String>)new ImmutablePair((Object)ref.getMovedClass().getLocationInfo().getFilePath(), (Object)ref.getMovedClassName()));
        }
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (MoveClassRefactoring ref : this.moveClassRefactorings) {
            ranges.add(ref.getOriginalClass().codeRange().setDescription("original type declaration").setCodeElement(ref.getOriginalClass().getQualifiedName()));
        }
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (MoveClassRefactoring ref : this.moveClassRefactorings) {
            ranges.add(ref.getMovedClass().codeRange().setDescription("moved type declaration").setCodeElement(ref.getMovedClass().getQualifiedName()));
        }
        return ranges;
    }
}

