/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.research.kotlinrminer.ide.decomposition.UMLOperationBodyMapper;

public class ReplacementUtil {
    private static final String[] SPECIAL_CHARACTERS = new String[]{";", ",", ")", "=", "+", "-", ">", "<", ".", "]", " ", "(", "["};
    private static final String[] SPECIAL_ARGUMENT_CHARACTERS = new String[]{";", ",", ")", "=", "+", "-", ">", "<", ".", "]", " "};

    public static int countInstances(String completeString, String subString) {
        for (String character : SPECIAL_CHARACTERS) {
            int index = completeString.indexOf(subString + character);
            if (index == -1) continue;
            return (completeString.length() - completeString.replace(subString + character, "").length()) / (subString.length() + 1);
        }
        return 0;
    }

    public static boolean contains(String completeString, String subString) {
        for (String character : SPECIAL_CHARACTERS) {
            if (!completeString.contains(subString + character)) continue;
            return true;
        }
        return false;
    }

    public static String performArgumentReplacement(String completeString, String subString, String replacement) {
        String temp = completeString;
        for (String character : SPECIAL_ARGUMENT_CHARACTERS) {
            if (!completeString.contains(subString + character)) continue;
            temp = temp.replace(subString + character, replacement + character);
        }
        return temp;
    }

    public static String keepReservedTokens(String input) {
        StringBuilder sb = new StringBuilder();
        block0: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            for (String character : SPECIAL_CHARACTERS) {
                if (!character.equals(Character.toString(c))) continue;
                sb.append(c);
                continue block0;
            }
        }
        return sb.toString();
    }

    public static String performReplacement(String completeString, String subString, String replacement) {
        String temp = completeString;
        if (completeString.equals(subString)) {
            temp = temp.replace(subString, replacement);
            return temp;
        }
        boolean replacementDone = false;
        for (String character : SPECIAL_CHARACTERS) {
            if (!completeString.contains(subString + character)) continue;
            temp = temp.replace(subString + character, replacement + character);
            replacementDone = true;
        }
        if (!replacementDone) {
            for (String character : SPECIAL_CHARACTERS) {
                if (!completeString.contains(character + subString)) continue;
                temp = temp.replace(character + subString, character + replacement);
            }
        }
        return temp;
    }

    public static String performReplacement(String completeString1, String completeString2, String subString1, String subString2) {
        Matcher m2;
        Pattern p2;
        Matcher m1;
        Pattern p1;
        StringBuffer sb;
        String temp = completeString1;
        boolean replacementOccurred = false;
        for (String character : SPECIAL_CHARACTERS) {
            if (!temp.contains(subString1 + character) || !completeString2.contains(subString2 + character)) continue;
            sb = new StringBuffer();
            p1 = Pattern.compile(Pattern.quote(subString1 + character));
            m1 = p1.matcher(temp);
            p2 = Pattern.compile(Pattern.quote(subString2 + character));
            m2 = p2.matcher(completeString2);
            while (m1.find() && m2.find()) {
                int start2;
                String characterBeforeMatch2;
                int start1 = m1.start();
                String characterBeforeMatch1 = start1 == 0 ? "" : String.valueOf(temp.charAt(start1 - 1));
                if (!ReplacementUtil.compatibleCharacterBeforeMatch(characterBeforeMatch1, characterBeforeMatch2 = (start2 = m2.start()) == 0 ? "" : String.valueOf(completeString2.charAt(start2 - 1)))) continue;
                m1.appendReplacement(sb, Matcher.quoteReplacement(subString2 + character));
                replacementOccurred = true;
            }
            m1.appendTail(sb);
            temp = sb.toString();
        }
        if (!(replacementOccurred || UMLOperationBodyMapper.containsMethodSignatureOfAnonymousClass(completeString1) || UMLOperationBodyMapper.containsMethodSignatureOfAnonymousClass(completeString2))) {
            for (String character : SPECIAL_CHARACTERS) {
                if (!temp.contains(character + subString1) || !completeString2.contains(character + subString2)) continue;
                sb = new StringBuffer();
                p1 = Pattern.compile(Pattern.quote(character + subString1));
                m1 = p1.matcher(temp);
                p2 = Pattern.compile(Pattern.quote(character + subString2));
                m2 = p2.matcher(completeString2);
                while (m1.find() && m2.find()) {
                    String characterAfterMatch2;
                    int end1 = m1.end();
                    int end2 = m2.end();
                    String characterAfterMatch1 = end1 == temp.length() ? "" : String.valueOf(temp.charAt(end1));
                    if (!ReplacementUtil.compatibleCharacterAfterMatch(characterAfterMatch1, characterAfterMatch2 = end2 == completeString2.length() ? "" : String.valueOf(completeString2.charAt(end2)))) continue;
                    m1.appendReplacement(sb, Matcher.quoteReplacement(character + subString2));
                }
                m1.appendTail(sb);
                temp = sb.toString();
            }
        }
        return temp;
    }

    private static boolean compatibleCharacterBeforeMatch(String characterBefore1, String characterBefore2) {
        if (characterBefore1 != null && characterBefore2 != null) {
            if (characterBefore1.equals(characterBefore2)) {
                return true;
            }
            if (characterBefore1.equals(",") && characterBefore2.equals("(")) {
                return true;
            }
            if (characterBefore1.equals("(") && characterBefore2.equals(",")) {
                return true;
            }
            if (characterBefore1.equals(" ") && characterBefore2.equals("")) {
                return true;
            }
            return characterBefore1.equals("") && characterBefore2.equals(" ");
        }
        return false;
    }

    private static boolean compatibleCharacterAfterMatch(String characterAfter1, String characterAfter2) {
        if (characterAfter1 != null && characterAfter2 != null) {
            if (characterAfter1.equals(characterAfter2)) {
                return true;
            }
            if (characterAfter1.equals(",") && characterAfter2.equals(")")) {
                return true;
            }
            return characterAfter1.equals(")") && characterAfter2.equals(",");
        }
        return false;
    }

    public static boolean sameCharsBeforeAfter(String completeString1, String completeString2, String commonSubString) {
        Pattern p = Pattern.compile(Pattern.quote(commonSubString));
        Matcher m1 = p.matcher(completeString1);
        Matcher m2 = p.matcher(completeString2);
        int matches = 0;
        int compatibleMatches = 0;
        while (m1.find() && m2.find()) {
            String characterAfterMatch2;
            int start1 = m1.start();
            int start2 = m2.start();
            String characterBeforeMatch1 = start1 == 0 ? "" : String.valueOf(completeString1.charAt(start1 - 1));
            String characterBeforeMatch2 = start2 == 0 ? "" : String.valueOf(completeString2.charAt(start2 - 1));
            int end1 = m1.end();
            int end2 = m2.end();
            String characterAfterMatch1 = end1 == completeString1.length() ? "" : String.valueOf(completeString1.charAt(end1));
            String string = characterAfterMatch2 = end2 == completeString2.length() ? "" : String.valueOf(completeString2.charAt(end2));
            if (characterBeforeMatch1.equals(characterBeforeMatch2) && characterAfterMatch1.equals(characterAfterMatch2)) {
                ++compatibleMatches;
            }
            ++matches;
        }
        return matches == compatibleMatches;
    }
}

