/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.other.watchFaceService.src.app_package;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0003\u00a8\u0006\u0007"}, d2={"myDigitalWatchFaceServiceKt", "", "isInteractive", "", "packageName", "serviceClass", "useAndroidX", "intellij.android.wizardTemplate.impl"})
public final class MyDigitalWatchFaceServiceKtKt {
    @NotNull
    public static final String myDigitalWatchFaceServiceKt(boolean isInteractive, @NotNull String packageName, @NotNull String serviceClass, boolean useAndroidX) {
        String string;
        String string2;
        boolean bl;
        String it$iv;
        boolean bl2;
        String string3;
        boolean bl3;
        String string4;
        String string5;
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        Intrinsics.checkParameterIsNotNull((Object)serviceClass, (String)"serviceClass");
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = stringBuilder2.append("\npackage ").append(TemplateHelpersKt.escapeKotlinIdentifier(packageName)).append("\n\nimport android.content.BroadcastReceiver\nimport android.content.Context\nimport android.content.Intent\nimport android.content.IntentFilter\nimport android.graphics.Canvas\nimport android.graphics.Color\nimport android.graphics.Paint\nimport android.graphics.Rect\nimport android.graphics.Typeface\nimport android.os.Bundle\nimport android.os.Handler\nimport android.os.Message\nimport ").append(TemplateHelpersKt.getMaterialComponentName("android.support.v4.content.ContextCompat", useAndroidX)).append("\nimport android.support.wearable.watchface.CanvasWatchFaceService\nimport android.support.wearable.watchface.WatchFaceService\nimport android.support.wearable.watchface.WatchFaceStyle\nimport android.view.SurfaceHolder\nimport android.view.WindowInsets\n");
        boolean trim$iv = true;
        boolean skipLine$iv = true;
        boolean $i$f$renderIf = false;
        if (isInteractive) {
            stringBuilder = stringBuilder3;
            boolean bl4 = false;
            string5 = "import android.widget.Toast";
            stringBuilder3 = stringBuilder;
            string4 = string5;
            bl3 = false;
            string3 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        } else {
            string4 = "[THIS LINE SHOULD NOT BE RENDERED!]";
            bl3 = false;
            bl2 = false;
            it$iv = string4;
            bl = false;
            bl3 = false;
            string3 = string4;
            if (string3 == null) {
                string3 = "";
            }
        }
        StringBuilder stringBuilder4 = stringBuilder3.append(string3).append("\n\nimport java.lang.ref.WeakReference\nimport java.util.Calendar\nimport java.util.TimeZone\n\n/**\n * Digital watch face with seconds. In ambient mode, the seconds aren\"t displayed. On devices with\n * low-bit ambient mode, the text is drawn without anti-aliasing in ambient mode.\n *\n *\n * Important Note: Because watch face apps do not have a default Activity in\n * their project, you will need to set your Configurations to\n * \"Do not launch Activity\" for both the Wear and/or Application modules. If you\n * are unsure how to do this, please review the \"Run Starter project\" section\n * in the Google Watch Face Code Lab:\n * https://codelabs.developers.google.com/codelabs/watchface/index.html#0\n */\nclass ").append(serviceClass).append(" : CanvasWatchFaceService() {\n\n    companion object {\n        private val NORMAL_TYPEFACE = Typeface.create(Typeface.SANS_SERIF, Typeface.NORMAL)\n\n        /**\n         * Updates rate in milliseconds for interactive mode. We update once a second since seconds\n         * are displayed in interactive mode.\n         */\n        private const val INTERACTIVE_UPDATE_RATE_MS = 1000\n\n        /**\n         * Handler message id for updating the time periodically in interactive mode.\n         */\n        private const val MSG_UPDATE_TIME = 0\n    }\n\n    override fun onCreateEngine(): Engine {\n        return Engine()\n    }\n\n    private class EngineHandler(reference: ").append(serviceClass).append(".Engine) : Handler() {\n        private val mWeakReference: WeakReference<").append(serviceClass).append(".Engine> = WeakReference(reference)\n\n        override fun handleMessage(msg: Message) {\n            val engine = mWeakReference.get()\n            if (engine != null) {\n                when (msg.what) {\n                    MSG_UPDATE_TIME -> engine.handleUpdateTimeMessage()\n                }\n            }\n        }\n    }\n\n    inner class Engine : CanvasWatchFaceService.Engine() {\n\n        private lateinit var mCalendar: Calendar\n\n        private var mRegisteredTimeZoneReceiver = false\n\n        private var mXOffset: Float = 0F\n        private var mYOffset: Float = 0F\n\n        private lateinit var mBackgroundPaint: Paint\n        private lateinit var mTextPaint: Paint\n\n        /**\n         * Whether the display supports fewer bits for each color in ambient mode. When true, we\n         * disable anti-aliasing in ambient mode.\n         */\n        private var mLowBitAmbient: Boolean = false\n        private var mBurnInProtection: Boolean = false\n        private var mAmbient: Boolean = false\n\n        private val mUpdateTimeHandler: Handler = EngineHandler(this)\n\n        private val mTimeZoneReceiver: BroadcastReceiver = object : BroadcastReceiver() {\n            override fun onReceive(context: Context, intent: Intent) {\n                mCalendar.timeZone = TimeZone.getDefault()\n                invalidate()\n            }\n        }\n\n        override fun onCreate(holder: SurfaceHolder) {\n            super.onCreate(holder)\n\n            setWatchFaceStyle(WatchFaceStyle.Builder(this@").append(serviceClass).append(")\n                    ");
        trim$iv = true;
        skipLine$iv = true;
        $i$f$renderIf = false;
        if (isInteractive) {
            stringBuilder = stringBuilder4;
            boolean bl5 = false;
            string5 = ".setAcceptsTapEvents(true)";
            stringBuilder4 = stringBuilder;
            string4 = string5;
            bl3 = false;
            string2 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        } else {
            string4 = "[THIS LINE SHOULD NOT BE RENDERED!]";
            bl3 = false;
            bl2 = false;
            it$iv = string4;
            bl = false;
            bl3 = false;
            string2 = string4;
            if (string2 == null) {
                string2 = "";
            }
        }
        StringBuilder stringBuilder5 = stringBuilder4.append(string2).append("\n                    .build())\n\n            mCalendar = Calendar.getInstance()\n\n            val resources = this@").append(serviceClass).append(".resources\n            mYOffset = resources.getDimension(R.dimen.digital_y_offset)\n\n            // Initializes background.\n            mBackgroundPaint = Paint().apply {\n                color = ContextCompat.getColor(applicationContext, R.color.background)\n            }\n\n            // Initializes Watch Face.\n            mTextPaint = Paint().apply {\n                typeface = NORMAL_TYPEFACE\n                isAntiAlias = true\n                color = ContextCompat.getColor(applicationContext, R.color.digital_text)\n            }\n        }\n\n        override fun onDestroy() {\n            mUpdateTimeHandler.removeMessages(MSG_UPDATE_TIME)\n            super.onDestroy()\n        }\n\n        override fun onPropertiesChanged(properties: Bundle) {\n            super.onPropertiesChanged(properties)\n            mLowBitAmbient = properties.getBoolean(\n                    WatchFaceService.PROPERTY_LOW_BIT_AMBIENT, false)\n            mBurnInProtection = properties.getBoolean(\n                    WatchFaceService.PROPERTY_BURN_IN_PROTECTION, false)\n        }\n\n        override fun onTimeTick() {\n            super.onTimeTick()\n            invalidate()\n        }\n\n        override fun onAmbientModeChanged(inAmbientMode: Boolean) {\n            super.onAmbientModeChanged(inAmbientMode)\n            mAmbient = inAmbientMode\n\n            if (mLowBitAmbient) {\n                mTextPaint.isAntiAlias = !inAmbientMode\n            }\n\n            // Whether the timer should be running depends on whether we\"re visible (as well as\n            // whether we\"re in ambient mode), so we may need to start or stop the timer.\n            updateTimer()\n        }\n\n");
        trim$iv = true;
        skipLine$iv = true;
        $i$f$renderIf = false;
        if (isInteractive) {
            stringBuilder = stringBuilder5;
            boolean bl6 = false;
            string5 = "\n        /**\n         * Captures tap event (and tap type) and toggles the background color if the user finishes\n         * a tap.\n         */\n        override fun onTapCommand(tapType: Int, x: Int, y: Int, eventTime: Long) {\n            when (tapType) {\n                WatchFaceService.TAP_TYPE_TOUCH -> {\n                    // The user has started touching the screen.\n                }\n                WatchFaceService.TAP_TYPE_TOUCH_CANCEL -> {\n                    // The user has started a different gesture or otherwise cancelled the tap.\n                }\n                WatchFaceService.TAP_TYPE_TAP ->\n                    // The user has completed the tap gesture.\n                    // TODO: Add code to handle the tap gesture.\n                    Toast.makeText(applicationContext, R.string.message, Toast.LENGTH_SHORT)\n                            .show()\n            }\n            invalidate()\n        }\n";
            stringBuilder5 = stringBuilder;
            string4 = string5;
            bl3 = false;
            string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        } else {
            string4 = "[THIS LINE SHOULD NOT BE RENDERED!]";
            bl3 = false;
            bl2 = false;
            it$iv = string4;
            bl = false;
            bl3 = false;
            string = string4;
            if (string == null) {
                string = "";
            }
        }
        stringBuilder5.append(string).append("\n\n        override fun onDraw(canvas: Canvas, bounds: Rect) {\n            // Draw the background.\n            if (mAmbient) {\n                canvas.drawColor(Color.BLACK)\n            } else {\n                canvas.drawRect(\n                    0f, 0f, bounds.width().toFloat(), bounds.height().toFloat(), mBackgroundPaint)\n            }\n\n            // Draw H:MM in ambient mode or H:MM:SS in interactive mode.\n            val now = System.currentTimeMillis()\n            mCalendar.timeInMillis = now\n\n            val text = if (mAmbient)\n                String.format(\"%d:%02d\", mCalendar.get(Calendar.HOUR),\n                        mCalendar.get(Calendar.MINUTE))\n            else\n                String.format(\"%d:%02d:%02d\", mCalendar.get(Calendar.HOUR),\n                        mCalendar.get(Calendar.MINUTE), mCalendar.get(Calendar.SECOND))\n            canvas.drawText(text, mXOffset, mYOffset, mTextPaint)\n        }\n\n        override fun onVisibilityChanged(visible: Boolean) {\n            super.onVisibilityChanged(visible)\n\n            if (visible) {\n                registerReceiver()\n\n                // Update time zone in case it changed while we weren\"t visible.\n                mCalendar.timeZone = TimeZone.getDefault()\n                invalidate()\n            } else {\n                unregisterReceiver()\n            }\n\n            // Whether the timer should be running depends on whether we\"re visible (as well as\n            // whether we\"re in ambient mode), so we may need to start or stop the timer.\n            updateTimer()\n        }\n\n        private fun registerReceiver() {\n            if (mRegisteredTimeZoneReceiver) {\n                return\n            }\n            mRegisteredTimeZoneReceiver = true\n            val filter = IntentFilter(Intent.ACTION_TIMEZONE_CHANGED)\n            this@").append(serviceClass).append(".registerReceiver(mTimeZoneReceiver, filter)\n        }\n\n        private fun unregisterReceiver() {\n            if (!mRegisteredTimeZoneReceiver) {\n                return\n            }\n            mRegisteredTimeZoneReceiver = false\n            this@");
        stringBuilder2.append(serviceClass).append(".unregisterReceiver(mTimeZoneReceiver)\n        }\n\n        override fun onApplyWindowInsets(insets: WindowInsets) {\n            super.onApplyWindowInsets(insets)\n\n            // Load resources that have alternate values for round watches.\n            val resources = this@").append(serviceClass).append(".resources\n            val isRound = insets.isRound\n            mXOffset = resources.getDimension(\n                        if (isRound)\n                            R.dimen.digital_x_offset_round\n                        else\n                            R.dimen.digital_x_offset\n                        )\n\n            val textSize = resources.getDimension(\n                        if (isRound)\n                            R.dimen.digital_text_size_round\n                        else\n                            R.dimen.digital_text_size\n                        )\n\n            mTextPaint.textSize = textSize\n        }\n\n        /**\n         * Starts the [.mUpdateTimeHandler] timer if it should be running and isn\"t currently\n         * or stops it if it shouldn\"t be running but currently is.\n         */\n        private fun updateTimer() {\n            mUpdateTimeHandler.removeMessages(MSG_UPDATE_TIME)\n            if (shouldTimerBeRunning()) {\n                mUpdateTimeHandler.sendEmptyMessage(MSG_UPDATE_TIME)\n            }\n        }\n\n        /**\n         * Returns whether the [.mUpdateTimeHandler] timer should be running. The timer should\n         * only run when we\"re visible and in interactive mode.\n         */\n        private fun shouldTimerBeRunning(): Boolean {\n            return isVisible && !isInAmbientMode\n        }\n\n        /**\n         * Handle updating the time periodically in interactive mode.\n         */\n        fun handleUpdateTimeMessage() {\n            invalidate()\n            if (shouldTimerBeRunning()) {\n                val timeMs = System.currentTimeMillis()\n                val delayMs = INTERACTIVE_UPDATE_RATE_MS - timeMs % INTERACTIVE_UPDATE_RATE_MS\n                mUpdateTimeHandler.sendEmptyMessageDelayed(MSG_UPDATE_TIME, delayMs)\n            }\n        }\n    }\n}\n");
        return stringBuilder2.toString();
    }
}

