/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.report.HighlightedReportDescriptor;
import org.jetbrains.qodana.report.QodanaReportsService;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\tH\u0016R\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/qodana/actions/QodanaShowReportAction;", "Lcom/intellij/openapi/project/DumbAwareToggleAction;", "text", "", "reportGuid", "(Ljava/lang/String;Ljava/lang/String;)V", "getReportGuid$intellij_qodana", "()Ljava/lang/String;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.qodana"})
public final class QodanaShowReportAction
extends DumbAwareToggleAction {
    @NotNull
    private final String reportGuid;

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return false");
        Project project2 = project;
        QodanaReportsService reportService = (QodanaReportsService)project2.getService(QodanaReportsService.class);
        HighlightedReportDescriptor highlightedReportDescriptor = reportService.getHighlightedReportDescriptor();
        return Intrinsics.areEqual((Object)this.reportGuid, (Object)(highlightedReportDescriptor != null ? highlightedReportDescriptor.getReportGuid() : null));
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getProject();
        if (object == null || (object = (QodanaReportsService)object.getService(QodanaReportsService.class)) == null) {
            return;
        }
        Object reportService = object;
        if (!state) {
            HighlightedReportDescriptor highlightedReportDescriptor = ((QodanaReportsService)reportService).getHighlightedReportDescriptor();
            if (Intrinsics.areEqual((Object)this.reportGuid, (Object)(highlightedReportDescriptor != null ? highlightedReportDescriptor.getReportGuid() : null))) {
                ((QodanaReportsService)reportService).setReportToHighlight(null);
                DaemonCodeAnalyzer.getInstance((Project)e.getProject()).restart();
                return;
            }
        }
        if (state) {
            ((QodanaReportsService)reportService).setReportToHighlight(this.reportGuid);
            DaemonCodeAnalyzer.getInstance((Project)e.getProject()).restart();
        }
    }

    @NotNull
    public final String getReportGuid$intellij_qodana() {
        return this.reportGuid;
    }

    public QodanaShowReportAction(@NlsActions.ActionText @NotNull String text, @NotNull String reportGuid) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)reportGuid, (String)"reportGuid");
        super(text);
        this.reportGuid = reportGuid;
    }
}

