/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.kotlin.commonNative.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.kotlin.commonNative.KonanLog;
import com.jetbrains.kotlin.commonNative.UtilsKt;
import com.jetbrains.kotlin.commonNative.debugger.KonanEvaluator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0003J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0016J\u000e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0014J\u0016\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0014R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/kotlin/commonNative/debugger/KonanStackFrame;", "Lcom/jetbrains/cidr/execution/debugger/CidrStackFrame;", "thread", "Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;", "frame", "Lcom/jetbrains/cidr/execution/debugger/backend/LLFrame;", "suspensionCause", "Lcom/jetbrains/cidr/execution/debugger/CidrSuspensionCause;", "debugProcess", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "(Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;Lcom/jetbrains/cidr/execution/debugger/backend/LLFrame;Lcom/jetbrains/cidr/execution/debugger/CidrSuspensionCause;Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;)V", "sp", "Lcom/intellij/xdebugger/XSourcePosition;", "getSp", "()Lcom/intellij/xdebugger/XSourcePosition;", "customizePresentation", "", "component", "Lcom/intellij/ui/ColoredTextContainer;", "functionName", "", "getEvaluator", "Lcom/jetbrains/cidr/execution/debugger/CidrEvaluator;", "getSourcePosition", "prepareRuntimeTypeFor", "name", "runtimeTypeFor", "fallback", "Companion", "kotlin-ultimate.common-native"})
public final class KonanStackFrame
extends CidrStackFrame {
    @Nullable
    private final XSourcePosition sp;
    private static final Key<HashMap<String, FutureResult<String>>> TYPES_INDEX_KEY;
    private static final String KONAN_PREFIX = "kfun:";
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final XSourcePosition getSp() {
        return this.sp;
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        XSourcePosition xSourcePosition = this.sp;
        if (xSourcePosition == null) {
            xSourcePosition = super.getSourcePosition();
        }
        return xSourcePosition;
    }

    public void customizePresentation(@NotNull ColoredTextContainer component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        component2.setIcon(AllIcons.Debugger.Frame);
        if (this.hasSourceFile()) {
            component2.append(this.functionName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            XSourcePosition xSourcePosition = this.getSourcePosition();
            Intrinsics.checkNotNull((Object)xSourcePosition);
            VirtualFile virtualFile2 = xSourcePosition.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"sourcePosition!!.file");
            String string = virtualFile2.getName();
            XSourcePosition xSourcePosition2 = this.getSourcePosition();
            Intrinsics.checkNotNull((Object)xSourcePosition2);
            component2.append(" " + string + ":" + (xSourcePosition2.getLine() + 1), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        } else {
            component2.append(this.functionName(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            LLFrame lLFrame = this.getFrame();
            Intrinsics.checkNotNullExpressionValue((Object)lLFrame, (String)"frame");
            component2.append(" " + lLFrame.getProgramCounter(), SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
        }
    }

    public final void prepareRuntimeTypeFor(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Object object = this.getUserData(TYPES_INDEX_KEY);
        Intrinsics.checkNotNull((Object)object);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getUserData(TYPES_INDEX_KEY)!!");
        HashMap index2 = (HashMap)object;
        if (index2.containsKey(name2)) {
            return;
        }
        FutureResult result2 = new FutureResult();
        ((Map)index2).put(name2, result2);
        this.getProcess().postCommand(new CidrDebugProcess.VoidDebuggerCommand(this, name2, result2){
            final /* synthetic */ KonanStackFrame this$0;
            final /* synthetic */ String $name;
            final /* synthetic */ FutureResult $result;

            public final void run(@NotNull DebuggerDriver driver) {
                Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
                String string = driver.executeInterpreterCommand(this.this$0.getThreadId(), this.this$0.getFrameIndex(), "field_type " + this.$name);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"driver.executeInterprete\u2026ndex, \"field_type $name\")");
                String response = string;
                CharSequence charSequence = response;
                this.$result.set(charSequence.length() == 0 || Intrinsics.areEqual((Object)response, (Object)"<NO_FIELD_FOUND>") ? null : response);
            }
            {
                this.this$0 = konanStackFrame;
                this.$name = string;
                this.$result = futureResult;
            }
        }, true);
    }

    @NotNull
    public final String runtimeTypeFor(@NotNull String name2, @NotNull String fallback) {
        String string;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)fallback, (String)"fallback");
        HashMap hashMap = (HashMap)this.getUserData(TYPES_INDEX_KEY);
        if (hashMap == null || (hashMap = (FutureResult)hashMap.get(name2)) == null) {
            return fallback;
        }
        Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"getUserData(TYPES_INDEX_\u2026(name) ?: return fallback");
        HashMap future = hashMap;
        try {
            String string2 = (String)future.get(2000L, TimeUnit.MILLISECONDS);
            if (string2 == null) {
                string2 = fallback;
            }
            string = string2;
        }
        catch (TimeoutException e) {
            KonanLog.INSTANCE.getLOG().info("Failed to get runtime Kotlin/Native type in time for " + name2);
            string = fallback;
        }
        catch (Throwable e) {
            KonanLog.INSTANCE.getLOG().warn("Failed to get runtime Kotlin/Native type for " + name2 + ":");
            KonanLog.INSTANCE.getLOG().warn(e);
            string = fallback;
        }
        return string;
    }

    @NlsSafe
    private final String functionName() {
        String fullName;
        LLFrame lLFrame = this.getFrame();
        Intrinsics.checkNotNullExpressionValue((Object)lLFrame, (String)"frame");
        String string = lLFrame.getFunction();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"frame.function");
        String unmangledName = string;
        if (!StringsKt.startsWith$default((String)unmangledName, (String)KONAN_PREFIX, (boolean)false, (int)2, null)) {
            return unmangledName;
        }
        if (!StringsKt.contains$default((CharSequence)unmangledName, (char)'(', (boolean)false, (int)2, null)) {
            return StringsKt.removePrefix((String)unmangledName, (CharSequence)KONAN_PREFIX);
        }
        String string2 = unmangledName;
        int n = KONAN_PREFIX.length();
        int n2 = StringsKt.indexOf$default((CharSequence)unmangledName, (char)'(', (int)0, (boolean)false, (int)6, null);
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        string2 = fullName = string3;
        n = StringsKt.lastIndexOf$default((CharSequence)fullName, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
        String string4 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
        return string4;
    }

    @NotNull
    public CidrEvaluator getEvaluator() {
        return new KonanEvaluator(this);
    }

    public KonanStackFrame(@NotNull LLThread thread, @NotNull LLFrame frame, @Nullable CidrSuspensionCause suspensionCause, @NotNull CidrDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        super(debugProcess, thread, frame, suspensionCause);
        this.putUserData(TYPES_INDEX_KEY, new HashMap());
        CidrDebugProcess cidrDebugProcess = this.getProcess();
        Intrinsics.checkNotNullExpressionValue((Object)cidrDebugProcess, (String)"process");
        this.sp = UtilsKt.findSourcePosition(cidrDebugProcess, frame);
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"TypesIndex");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<TypesIndex>(\"TypesIndex\")");
        TYPES_INDEX_KEY = key;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000RS\u0010\u0005\u001aG\u0012>\u0012<\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\b \n*\u001e\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\b\u0018\u00010\u0007j\u0004\u0018\u0001`\t0\u0007j\u0002`\t0\u0006\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/kotlin/commonNative/debugger/KonanStackFrame$Companion;", "", "()V", "KONAN_PREFIX", "", "TYPES_INDEX_KEY", "Lcom/intellij/openapi/util/Key;", "Ljava/util/HashMap;", "Lcom/intellij/util/concurrency/FutureResult;", "Lcom/jetbrains/kotlin/commonNative/debugger/TypesIndex;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "kotlin-ultimate.common-native"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

