/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/DaemonCodeAnalyzerStatusService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "<set-?>", "", "daemonRunning", "getDaemonRunning", "()Z", "dispose", "", "Companion", "kotlin.core"})
public final class DaemonCodeAnalyzerStatusService
implements Disposable {
    private volatile boolean daemonRunning;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final boolean getDaemonRunning() {
        return this.daemonRunning;
    }

    public void dispose() {
    }

    public DaemonCodeAnalyzerStatusService(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        MessageBusConnection messageBusConnection = project2.getMessageBus().connect((Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect(this)");
        MessageBusConnection messageBusConnection2 = messageBusConnection;
        messageBusConnection2.subscribe(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC, (Object)new DaemonCodeAnalyzer.DaemonListener(){

            public void daemonStarting(@NotNull Collection<? extends FileEditor> fileEditors) {
                Intrinsics.checkNotNullParameter(fileEditors, (String)"fileEditors");
                daemonRunning = true;
            }

            public void daemonFinished(@NotNull Collection<? extends FileEditor> fileEditors) {
                Intrinsics.checkNotNullParameter(fileEditors, (String)"fileEditors");
                daemonRunning = false;
            }

            public void daemonCancelEventOccurred(@NotNull String reason) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                daemonRunning = false;
            }
        });
    }

    public static final /* synthetic */ boolean access$getDaemonRunning$p(DaemonCodeAnalyzerStatusService $this) {
        return $this.daemonRunning;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/DaemonCodeAnalyzerStatusService$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/DaemonCodeAnalyzerStatusService;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.core"})
    public static final class Companion {
        @NotNull
        public final DaemonCodeAnalyzerStatusService getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$getServiceSafe$iv = (ComponentManager)project2;
            boolean $i$f$getServiceSafe = false;
            Object object = $this$getServiceSafe$iv.getService(DaemonCodeAnalyzerStatusService.class);
            if (object == null) {
                String string = "Unable to locate service " + DaemonCodeAnalyzerStatusService.class.getName();
                throw new IllegalStateException(string.toString());
            }
            return (DaemonCodeAnalyzerStatusService)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

