/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.model.ModelBranch;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.reference.SoftReference;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.CachedAttributeData;
import org.jetbrains.kotlin.idea.caches.FileAttributeService;
import org.jetbrains.kotlin.load.kotlin.KotlinBinaryClassCache;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0003\u001f !B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0014\u0010\u001b\u001a\u00020\u000e*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R-\u0010\u0003\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0007*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/caches/IDEKotlinBinaryClassCache;", "", "()V", "KOTLIN_BINARY_DATA_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/reference/SoftReference;", "Lorg/jetbrains/kotlin/idea/caches/IDEKotlinBinaryClassCache$KotlinBinaryData;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "KOTLIN_IS_COMPILED_FILE_ATTRIBUTE", "", "attributeService", "Lorg/jetbrains/kotlin/idea/caches/FileAttributeService;", "createHeaderInfo", "Lorg/jetbrains/kotlin/idea/caches/IDEKotlinBinaryClassCache$KotlinBinaryClassHeaderData;", "kotlinBinaryClass", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "getKotlinBinaryClass", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileContent", "", "getKotlinBinaryClassHeaderData", "getKotlinBinaryFromCache", "isKotlinJvmCompiledFile", "", "kotlinJvmBinaryClass", "toLightHeader", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "Companion", "KotlinBinaryClassHeaderData", "KotlinBinaryData", "kotlin.core"})
public final class IDEKotlinBinaryClassCache {
    private final FileAttributeService attributeService;
    private final String KOTLIN_IS_COMPILED_FILE_ATTRIBUTE;
    private final Key<SoftReference<KotlinBinaryData>> KOTLIN_BINARY_DATA_KEY;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final boolean isKotlinJvmCompiledFile(@NotNull VirtualFile file2, @Nullable byte[] fileContent) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        String string = file2.getExtension();
        JavaClassFileType javaClassFileType = JavaClassFileType.INSTANCE;
        Intrinsics.checkNotNull((Object)javaClassFileType);
        if (Intrinsics.areEqual((Object)string, (Object)javaClassFileType.getDefaultExtension()) ^ true) {
            return false;
        }
        KotlinBinaryData kotlinBinaryData = this.getKotlinBinaryFromCache(file2);
        if (kotlinBinaryData != null) {
            KotlinBinaryData kotlinBinaryData2;
            KotlinBinaryData it = kotlinBinaryData2 = kotlinBinaryData;
            boolean bl = false;
            return it.isKotlinBinary();
        }
        return this.kotlinJvmBinaryClass(file2, fileContent) != null;
    }

    public static /* synthetic */ boolean isKotlinJvmCompiledFile$default(IDEKotlinBinaryClassCache iDEKotlinBinaryClassCache, VirtualFile virtualFile2, byte[] byArray, int n, Object object) {
        if ((n & 2) != 0) {
            byArray = null;
        }
        return iDEKotlinBinaryClassCache.isKotlinJvmCompiledFile(virtualFile2, byArray);
    }

    @Nullable
    public final KotlinJvmBinaryClass getKotlinBinaryClass(@NotNull VirtualFile file2, @Nullable byte[] fileContent) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KotlinBinaryData cached2 = this.getKotlinBinaryFromCache(file2);
        if (cached2 != null && !cached2.isKotlinBinary()) {
            return null;
        }
        return this.kotlinJvmBinaryClass(file2, fileContent);
    }

    public static /* synthetic */ KotlinJvmBinaryClass getKotlinBinaryClass$default(IDEKotlinBinaryClassCache iDEKotlinBinaryClassCache, VirtualFile virtualFile2, byte[] byArray, int n, Object object) {
        if ((n & 2) != 0) {
            byArray = null;
        }
        return iDEKotlinBinaryClassCache.getKotlinBinaryClass(virtualFile2, byArray);
    }

    private final KotlinJvmBinaryClass kotlinJvmBinaryClass(VirtualFile file2, byte[] fileContent) {
        boolean isKotlinBinaryClass;
        KotlinClassFinder.Result classFileContent;
        KotlinClassFinder.Result result2;
        if (ModelBranch.getFileBranch((VirtualFile)file2) != null) {
            return null;
        }
        try {
            result2 = KotlinBinaryClassCache.Companion.getKotlinBinaryClassOrClassFileContent(file2, fileContent);
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw (Throwable)e;
            }
            return null;
        }
        KotlinClassFinder.Result result3 = classFileContent = result2;
        KotlinJvmBinaryClass kotlinBinaryClass = result3 != null ? result3.toKotlinJvmBinaryClass() : null;
        boolean bl = isKotlinBinaryClass = kotlinBinaryClass != null;
        if (file2 instanceof VirtualFileWithId) {
            this.attributeService.writeBooleanAttribute(this.KOTLIN_IS_COMPILED_FILE_ATTRIBUTE, file2, isKotlinBinaryClass);
        }
        if (isKotlinBinaryClass) {
            KotlinJvmBinaryClass kotlinJvmBinaryClass = kotlinBinaryClass;
            Intrinsics.checkNotNull((Object)kotlinJvmBinaryClass);
            KotlinBinaryClassHeaderData headerInfo = this.createHeaderInfo(kotlinJvmBinaryClass);
            file2.putUserData(this.KOTLIN_BINARY_DATA_KEY, (Object)new SoftReference((Object)new KotlinBinaryData(isKotlinBinaryClass, file2.getTimeStamp(), headerInfo)));
        }
        return kotlinBinaryClass;
    }

    @Nullable
    public final KotlinBinaryClassHeaderData getKotlinBinaryClassHeaderData(@NotNull VirtualFile file2, @Nullable byte[] fileContent) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KotlinBinaryData kotlinBinaryData = this.getKotlinBinaryFromCache(file2);
        if (kotlinBinaryData != null) {
            KotlinBinaryData kotlinBinaryData2;
            KotlinBinaryData cached2 = kotlinBinaryData2 = kotlinBinaryData;
            boolean bl = false;
            if (!cached2.isKotlinBinary()) {
                return null;
            }
            if (cached2.getHeaderData() != null) {
                return cached2.getHeaderData();
            }
        }
        KotlinJvmBinaryClass kotlinJvmBinaryClass = this.kotlinJvmBinaryClass(file2, fileContent);
        if (kotlinJvmBinaryClass == null) {
            return null;
        }
        KotlinJvmBinaryClass kotlinBinaryClass = kotlinJvmBinaryClass;
        return this.createHeaderInfo(kotlinBinaryClass);
    }

    public static /* synthetic */ KotlinBinaryClassHeaderData getKotlinBinaryClassHeaderData$default(IDEKotlinBinaryClassCache iDEKotlinBinaryClassCache, VirtualFile virtualFile2, byte[] byArray, int n, Object object) {
        if ((n & 2) != 0) {
            byArray = null;
        }
        return iDEKotlinBinaryClassCache.getKotlinBinaryClassHeaderData(virtualFile2, byArray);
    }

    private final KotlinBinaryClassHeaderData createHeaderInfo(KotlinJvmBinaryClass kotlinBinaryClass) {
        ClassId classId = kotlinBinaryClass.getClassId();
        return this.toLightHeader(kotlinBinaryClass.getClassHeader(), classId);
    }

    private final KotlinBinaryClassHeaderData toLightHeader(KotlinClassHeader $this$toLightHeader, ClassId classId) {
        return new KotlinBinaryClassHeaderData(classId, $this$toLightHeader.getKind(), $this$toLightHeader.getMetadataVersion(), $this$toLightHeader.getMultifilePartNames(), $this$toLightHeader.getPackageName());
    }

    private final KotlinBinaryData getKotlinBinaryFromCache(VirtualFile file2) {
        CachedAttributeData<Boolean> isKotlinBinaryAttribute;
        KotlinBinaryData userData;
        SoftReference softReference = (SoftReference)file2.getUserData(this.KOTLIN_BINARY_DATA_KEY);
        KotlinBinaryData kotlinBinaryData = userData = softReference != null ? (KotlinBinaryData)softReference.get() : null;
        if (userData != null && userData.getTimestamp() == file2.getTimeStamp()) {
            return userData;
        }
        CachedAttributeData<Boolean> cachedAttributeData = isKotlinBinaryAttribute = file2 instanceof VirtualFileWithId ? this.attributeService.readBooleanAttribute(this.KOTLIN_IS_COMPILED_FILE_ATTRIBUTE, file2) : null;
        if (isKotlinBinaryAttribute != null) {
            boolean isKotlinBinary = isKotlinBinaryAttribute.getValue();
            KotlinBinaryData kotlinBinaryData2 = new KotlinBinaryData(isKotlinBinary, file2.getTimeStamp(), null);
            if (isKotlinBinary) {
                file2.putUserData(this.KOTLIN_BINARY_DATA_KEY, (Object)new SoftReference((Object)kotlinBinaryData2));
            }
            return kotlinBinaryData2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public IDEKotlinBinaryClassCache() {
        void $this$apply;
        boolean $i$f$service = false;
        Object serviceClass$iv = FileAttributeService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + ((Class)serviceClass$iv).getName() + " (classloader=" + ((Class)serviceClass$iv).getClassLoader() + ")");
        }
        this.attributeService = (FileAttributeService)object;
        String string = "kotlin-is-binary-compiled";
        serviceClass$iv = string;
        IDEKotlinBinaryClassCache iDEKotlinBinaryClassCache = this;
        boolean bl = false;
        boolean $i$f$service2 = false;
        Class<FileAttributeService> serviceClass$iv2 = FileAttributeService.class;
        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv2);
        if (object2 == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv2.getName() + " (classloader=" + serviceClass$iv2.getClassLoader() + ")");
        }
        FileAttributeService.DefaultImpls.register$default((FileAttributeService)object2, (String)$this$apply, 2, false, 4, null);
        Unit unit = Unit.INSTANCE;
        iDEKotlinBinaryClassCache.KOTLIN_IS_COMPILED_FILE_ATTRIBUTE = string;
        Key key = Key.create((String)this.KOTLIN_IS_COMPILED_FILE_ATTRIBUTE);
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<SoftReference\u2026_COMPILED_FILE_ATTRIBUTE)");
        this.KOTLIN_BINARY_DATA_KEY = key;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\r\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/caches/IDEKotlinBinaryClassCache$KotlinBinaryClassHeaderData;", "", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "kind", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader$Kind;", "metadataVersion", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;", "partNamesIfMultifileFacade", "", "", "packageName", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader$Kind;Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;Ljava/util/List;Ljava/lang/String;)V", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "getKind", "()Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader$Kind;", "getMetadataVersion", "()Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;", "getPackageName", "()Ljava/lang/String;", "getPartNamesIfMultifileFacade", "()Ljava/util/List;", "kotlin.core"})
    public static final class KotlinBinaryClassHeaderData {
        @NotNull
        private final ClassId classId;
        @NotNull
        private final KotlinClassHeader.Kind kind;
        @NotNull
        private final JvmMetadataVersion metadataVersion;
        @NotNull
        private final List<String> partNamesIfMultifileFacade;
        @Nullable
        private final String packageName;

        @NotNull
        public final ClassId getClassId() {
            return this.classId;
        }

        @NotNull
        public final KotlinClassHeader.Kind getKind() {
            return this.kind;
        }

        @NotNull
        public final JvmMetadataVersion getMetadataVersion() {
            return this.metadataVersion;
        }

        @NotNull
        public final List<String> getPartNamesIfMultifileFacade() {
            return this.partNamesIfMultifileFacade;
        }

        @Nullable
        public final String getPackageName() {
            return this.packageName;
        }

        public KotlinBinaryClassHeaderData(@NotNull ClassId classId, @NotNull KotlinClassHeader.Kind kind2, @NotNull JvmMetadataVersion metadataVersion2, @NotNull List<String> partNamesIfMultifileFacade, @Nullable String packageName2) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
            Intrinsics.checkNotNullParameter((Object)metadataVersion2, (String)"metadataVersion");
            Intrinsics.checkNotNullParameter(partNamesIfMultifileFacade, (String)"partNamesIfMultifileFacade");
            this.classId = classId;
            this.kind = kind2;
            this.metadataVersion = metadataVersion2;
            this.partNamesIfMultifileFacade = partNamesIfMultifileFacade;
            this.packageName = packageName2;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/caches/IDEKotlinBinaryClassCache$KotlinBinaryData;", "", "isKotlinBinary", "", "timestamp", "", "headerData", "Lorg/jetbrains/kotlin/idea/caches/IDEKotlinBinaryClassCache$KotlinBinaryClassHeaderData;", "(ZJLorg/jetbrains/kotlin/idea/caches/IDEKotlinBinaryClassCache$KotlinBinaryClassHeaderData;)V", "getHeaderData", "()Lorg/jetbrains/kotlin/idea/caches/IDEKotlinBinaryClassCache$KotlinBinaryClassHeaderData;", "()Z", "getTimestamp", "()J", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "kotlin.core"})
    public static final class KotlinBinaryData {
        private final boolean isKotlinBinary;
        private final long timestamp;
        @Nullable
        private final KotlinBinaryClassHeaderData headerData;

        public final boolean isKotlinBinary() {
            return this.isKotlinBinary;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        @Nullable
        public final KotlinBinaryClassHeaderData getHeaderData() {
            return this.headerData;
        }

        public KotlinBinaryData(boolean isKotlinBinary, long timestamp, @Nullable KotlinBinaryClassHeaderData headerData) {
            this.isKotlinBinary = isKotlinBinary;
            this.timestamp = timestamp;
            this.headerData = headerData;
        }

        public final boolean component1() {
            return this.isKotlinBinary;
        }

        public final long component2() {
            return this.timestamp;
        }

        @Nullable
        public final KotlinBinaryClassHeaderData component3() {
            return this.headerData;
        }

        @NotNull
        public final KotlinBinaryData copy(boolean isKotlinBinary, long timestamp, @Nullable KotlinBinaryClassHeaderData headerData) {
            return new KotlinBinaryData(isKotlinBinary, timestamp, headerData);
        }

        public static /* synthetic */ KotlinBinaryData copy$default(KotlinBinaryData kotlinBinaryData, boolean bl, long l, KotlinBinaryClassHeaderData kotlinBinaryClassHeaderData, int n, Object object) {
            if ((n & 1) != 0) {
                bl = kotlinBinaryData.isKotlinBinary;
            }
            if ((n & 2) != 0) {
                l = kotlinBinaryData.timestamp;
            }
            if ((n & 4) != 0) {
                kotlinBinaryClassHeaderData = kotlinBinaryData.headerData;
            }
            return kotlinBinaryData.copy(bl, l, kotlinBinaryClassHeaderData);
        }

        @NotNull
        public String toString() {
            return "KotlinBinaryData(isKotlinBinary=" + this.isKotlinBinary + ", timestamp=" + this.timestamp + ", headerData=" + this.headerData + ")";
        }

        public int hashCode() {
            int n = this.isKotlinBinary ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            KotlinBinaryClassHeaderData kotlinBinaryClassHeaderData = this.headerData;
            return (n * 31 + Long.hashCode(this.timestamp)) * 31 + (kotlinBinaryClassHeaderData != null ? kotlinBinaryClassHeaderData.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof KotlinBinaryData)) break block3;
                    KotlinBinaryData kotlinBinaryData = (KotlinBinaryData)object;
                    if (this.isKotlinBinary != kotlinBinaryData.isKotlinBinary || this.timestamp != kotlinBinaryData.timestamp || !Intrinsics.areEqual((Object)this.headerData, (Object)kotlinBinaryData.headerData)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/caches/IDEKotlinBinaryClassCache$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/caches/IDEKotlinBinaryClassCache;", "kotlin.core"})
    public static final class Companion {
        @NotNull
        public final IDEKotlinBinaryClassCache getInstance() {
            boolean $i$f$service = false;
            Class<IDEKotlinBinaryClassCache> serviceClass$iv = IDEKotlinBinaryClassCache.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ")");
            }
            return (IDEKotlinBinaryClassCache)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

