/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.analyzer.PackageOracle;
import org.jetbrains.kotlin.analyzer.PackageOracleFactory;
import org.jetbrains.kotlin.idea.caches.PerModulePackageCacheService;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfosKt;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.resolve.IdePackageOracleFactory$WhenMappings;
import org.jetbrains.kotlin.idea.caches.resolve.PackageOraclesKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.resolve.jvm.KotlinJavaPsiFacade;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u000b\f\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/IdePackageOracleFactory;", "Lorg/jetbrains/kotlin/analyzer/PackageOracleFactory;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "createOracle", "Lorg/jetbrains/kotlin/analyzer/PackageOracle;", "moduleInfo", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "JavaPackagesOracle", "JvmSourceOracle", "KotlinSourceFilesOracle", "kotlin.core"})
public final class IdePackageOracleFactory
implements PackageOracleFactory {
    @NotNull
    private final Project project;

    @NotNull
    public PackageOracle createOracle(@NotNull ModuleInfo moduleInfo) {
        PackageOracle packageOracle;
        block10: {
            block9: {
                Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
                if (!(moduleInfo instanceof IdeaModuleInfo)) {
                    return (PackageOracle)PackageOracle.Optimistic.INSTANCE;
                }
                if (!JvmPlatformKt.isJvm((TargetPlatform)moduleInfo.getPlatform())) break block9;
                switch (IdePackageOracleFactory$WhenMappings.$EnumSwitchMapping$0[((IdeaModuleInfo)moduleInfo).getModuleOrigin().ordinal()]) {
                    case 1: {
                        packageOracle = new JavaPackagesOracle((IdeaModuleInfo)moduleInfo, this.project);
                        break block10;
                    }
                    case 2: {
                        packageOracle = new JvmSourceOracle((IdeaModuleInfo)moduleInfo, this.project);
                        break block10;
                    }
                    case 3: {
                        packageOracle = (PackageOracle)PackageOracle.Optimistic.INSTANCE;
                        break block10;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            switch (IdePackageOracleFactory$WhenMappings.$EnumSwitchMapping$1[((IdeaModuleInfo)moduleInfo).getModuleOrigin().ordinal()]) {
                case 1: {
                    packageOracle = new KotlinSourceFilesOracle((IdeaModuleInfo)moduleInfo, this.project);
                    break;
                }
                default: {
                    packageOracle = (PackageOracle)PackageOracle.Optimistic.INSTANCE;
                }
            }
        }
        return packageOracle;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public IdePackageOracleFactory(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/IdePackageOracleFactory$JavaPackagesOracle;", "Lorg/jetbrains/kotlin/analyzer/PackageOracle;", "moduleInfo", "Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;", "project", "Lcom/intellij/openapi/project/Project;", "(Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;Lcom/intellij/openapi/project/Project;)V", "facade", "Lorg/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "packageExists", "", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "kotlin.core"})
    private static final class JavaPackagesOracle
    implements PackageOracle {
        private final GlobalSearchScope scope;
        private final KotlinJavaPsiFacade facade;

        public boolean packageExists(@NotNull FqName fqName2) {
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            return this.facade.findPackage(fqName2.asString(), this.scope) != null;
        }

        public JavaPackagesOracle(@NotNull IdeaModuleInfo moduleInfo, @NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.scope = moduleInfo.contentScope();
            ComponentManager $this$getServiceSafe$iv = (ComponentManager)project2;
            boolean $i$f$getServiceSafe = false;
            Object object = $this$getServiceSafe$iv.getService(KotlinJavaPsiFacade.class);
            if (object == null) {
                String string = "Unable to locate service " + KotlinJavaPsiFacade.class.getName();
                throw new IllegalStateException(string.toString());
            }
            this.facade = (KotlinJavaPsiFacade)object;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/IdePackageOracleFactory$KotlinSourceFilesOracle;", "Lorg/jetbrains/kotlin/analyzer/PackageOracle;", "moduleInfo", "Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;", "project", "Lcom/intellij/openapi/project/Project;", "(Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;Lcom/intellij/openapi/project/Project;)V", "cacheService", "Lorg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService;", "sourceModules", "", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleSourceInfo;", "packageExists", "", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "kotlin.core"})
    private static final class KotlinSourceFilesOracle
    implements PackageOracle {
        private final PerModulePackageCacheService cacheService;
        private final List<ModuleSourceInfo> sourceModules;
        private final Project project;

        public boolean packageExists(@NotNull FqName fqName2) {
            boolean bl;
            block5: {
                Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
                List<ModuleSourceInfo> list2 = this.sourceModules;
                if (list2 != null) {
                    Iterable $this$any$iv = list2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ModuleSourceInfo it = (ModuleSourceInfo)element$iv;
                            boolean bl2 = false;
                            if (!this.cacheService.packageExists(fqName2, it)) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                } else {
                    bl = false;
                }
            }
            return bl;
        }

        public KotlinSourceFilesOracle(@NotNull IdeaModuleInfo moduleInfo, @NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.project = project2;
            ComponentManager $this$getServiceSafe$iv = (ComponentManager)this.project;
            boolean $i$f$getServiceSafe = false;
            Object object = $this$getServiceSafe$iv.getService(PerModulePackageCacheService.class);
            if (object == null) {
                String string = "Unable to locate service " + PerModulePackageCacheService.class.getName();
                throw new IllegalStateException(string.toString());
            }
            this.cacheService = (PerModulePackageCacheService)object;
            this.sourceModules = IdeaModuleInfosKt.projectSourceModules(moduleInfo);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/IdePackageOracleFactory$JvmSourceOracle;", "Lorg/jetbrains/kotlin/analyzer/PackageOracle;", "moduleInfo", "Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;", "project", "Lcom/intellij/openapi/project/Project;", "(Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;Lcom/intellij/openapi/project/Project;)V", "javaPackagesOracle", "Lorg/jetbrains/kotlin/idea/caches/resolve/IdePackageOracleFactory$JavaPackagesOracle;", "kotlinSourceOracle", "Lorg/jetbrains/kotlin/idea/caches/resolve/IdePackageOracleFactory$KotlinSourceFilesOracle;", "packageExists", "", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "kotlin.core"})
    private static final class JvmSourceOracle
    implements PackageOracle {
        private final JavaPackagesOracle javaPackagesOracle;
        private final KotlinSourceFilesOracle kotlinSourceOracle;

        public boolean packageExists(@NotNull FqName fqName2) {
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            return this.javaPackagesOracle.packageExists(fqName2) || this.kotlinSourceOracle.packageExists(fqName2) || FqNamesUtilKt.isSubpackageOf((FqName)fqName2, (FqName)PackageOraclesKt.access$getANDROID_SYNTHETIC_PACKAGE_PREFIX$p());
        }

        public JvmSourceOracle(@NotNull IdeaModuleInfo moduleInfo, @NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.javaPackagesOracle = new JavaPackagesOracle(moduleInfo, project2);
            this.kotlinSourceOracle = new KotlinSourceFilesOracle(moduleInfo, project2);
        }
    }
}

