/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.codeStyle.NameUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.completion.AllClassesCompletion;
import org.jetbrains.kotlin.idea.completion.BasicLookupElementFactory;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsKt;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsNoResolveKt;
import org.jetbrains.kotlin.idea.completion.KotlinCompletionCharFilter;
import org.jetbrains.kotlin.idea.completion.LookupElementsCollector;
import org.jetbrains.kotlin.idea.completion.VariableOrParameterNameWithTypeCompletion;
import org.jetbrains.kotlin.idea.completion.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.idea.core.GenerateUtilsKt;
import org.jetbrains.kotlin.idea.core.KotlinIndicesHelper;
import org.jetbrains.kotlin.idea.core.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 12\u00020\u0001:\u00070123456B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ*\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u000b0!J*\u0010#\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\t2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u000b0!J(\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u000bH\u0002J \u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u000bH\u0002J \u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020-2\u0006\u0010&\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u000bH\u0002J \u0010.\u001a\u00020\u000b*\u00020/2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u000b0!H\u0002R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/idea/completion/VariableOrParameterNameWithTypeCompletion;", "", "collector", "Lorg/jetbrains/kotlin/idea/completion/LookupElementsCollector;", "lookupElementFactory", "Lorg/jetbrains/kotlin/idea/completion/BasicLookupElementFactory;", "prefixMatcher", "Lcom/intellij/codeInsight/completion/PrefixMatcher;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "withType", "", "(Lorg/jetbrains/kotlin/idea/completion/LookupElementsCollector;Lorg/jetbrains/kotlin/idea/completion/BasicLookupElementFactory;Lcom/intellij/codeInsight/completion/PrefixMatcher;Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;Z)V", "classNamePrefixMatchers", "", "lookupNamesAdded", "Ljava/util/HashSet;", "", "suggestionsByTypesAdded", "Lorg/jetbrains/kotlin/idea/completion/VariableOrParameterNameWithTypeCompletion$Type;", "userPrefixes", "addFromAllClasses", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "indicesHelper", "Lorg/jetbrains/kotlin/idea/core/KotlinIndicesHelper;", "addFromImportedClasses", "position", "Lcom/intellij/psi/PsiElement;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "visibilityFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "addFromParametersInFile", "addSuggestions", "className", "userPrefix", "type", "notImported", "addSuggestionsForClassifier", "classifier", "addSuggestionsForJavaClass", "psiClass", "Lcom/intellij/psi/PsiClass;", "isVisible", "Lorg/jetbrains/kotlin/types/KotlinType;", "ArbitraryType", "Companion", "DescriptorType", "JavaClassType", "MyLookupElement", "Type", "Weigher", "kotlin.idea"})
public final class VariableOrParameterNameWithTypeCompletion {
    private final List<String> userPrefixes;
    private final List<PrefixMatcher> classNamePrefixMatchers;
    private final HashSet<Type> suggestionsByTypesAdded;
    private final HashSet<String> lookupNamesAdded;
    private final LookupElementsCollector collector;
    private final BasicLookupElementFactory lookupElementFactory;
    private final PrefixMatcher prefixMatcher;
    private final ResolutionFacade resolutionFacade;
    private final boolean withType;
    private static final Key<Integer> PRIORITY_KEY;
    private static final OffsetKey REPLACEMENT_OFFSET;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public final void addFromImportedClasses(@NotNull PsiElement position, @NotNull BindingContext bindingContext2, @NotNull Function1<? super DeclarationDescriptor, Boolean> visibilityFilter) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkNotNullParameter(visibilityFilter, (String)"visibilityFilter");
        for (Pair pair : CollectionsKt.zip((Iterable)this.classNamePrefixMatchers, (Iterable)this.userPrefixes)) {
            void classNameMatcher;
            PrefixMatcher prefixMatcher = (PrefixMatcher)pair.component1();
            String userPrefix = (String)pair.component2();
            LexicalScope resolutionScope = ScopeUtils.getResolutionScope((PsiElement)position, (BindingContext)bindingContext2, (ResolutionFacade)this.resolutionFacade);
            Collection classifiers2 = ScopeUtilsKt.collectDescriptorsFiltered$default((HierarchicalScope)((HierarchicalScope)resolutionScope), (DescriptorKindFilter)DescriptorKindFilter.NON_SINGLETON_CLASSIFIERS, CompletionUtilsKt.asNameFilter((PrefixMatcher)classNameMatcher), (boolean)false, (int)4, null);
            for (DeclarationDescriptor classifier2 : classifiers2) {
                if (!((Boolean)visibilityFilter.invoke((Object)classifier2)).booleanValue()) continue;
                this.addSuggestionsForClassifier(classifier2, userPrefix, false);
            }
            this.collector.flushToResultSet();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addFromAllClasses(@NotNull CompletionParameters parameters2, @NotNull KotlinIndicesHelper indicesHelper2) {
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)indicesHelper2, (String)"indicesHelper");
        for (Pair pair : CollectionsKt.zip((Iterable)this.classNamePrefixMatchers, (Iterable)this.userPrefixes)) {
            void classNameMatcher;
            PrefixMatcher prefixMatcher = (PrefixMatcher)pair.component1();
            String userPrefix = (String)pair.component2();
            new AllClassesCompletion(parameters2, indicesHelper2, (PrefixMatcher)classNameMatcher, this.resolutionFacade, (Function1<? super ClassKind, Boolean>)((Function1)addFromAllClasses.1.INSTANCE), true, false).collect((Function1<? super ClassifierDescriptorWithTypeParameters, Unit>)((Function1)new Function1<ClassifierDescriptorWithTypeParameters, Unit>(this, userPrefix){
                final /* synthetic */ VariableOrParameterNameWithTypeCompletion this$0;
                final /* synthetic */ String $userPrefix;

                public final void invoke(@NotNull ClassifierDescriptorWithTypeParameters it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    VariableOrParameterNameWithTypeCompletion.access$addSuggestionsForClassifier(this.this$0, (DeclarationDescriptor)it, this.$userPrefix, true);
                }
                {
                    this.this$0 = variableOrParameterNameWithTypeCompletion;
                    this.$userPrefix = string;
                    super(1);
                }
            }), (Function1<? super PsiClass, Unit>)((Function1)new Function1<PsiClass, Unit>(this, userPrefix){
                final /* synthetic */ VariableOrParameterNameWithTypeCompletion this$0;
                final /* synthetic */ String $userPrefix;

                public final void invoke(@NotNull PsiClass it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    VariableOrParameterNameWithTypeCompletion.access$addSuggestionsForJavaClass(this.this$0, it, this.$userPrefix, true);
                }
                {
                    this.this$0 = variableOrParameterNameWithTypeCompletion;
                    this.$userPrefix = string;
                    super(1);
                }
            }));
            this.collector.flushToResultSet();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addFromParametersInFile(@NotNull PsiElement position, @NotNull ResolutionFacade resolutionFacade2, @NotNull Function1<? super DeclarationDescriptor, Boolean> visibilityFilter) {
        void action$iv;
        void $this$forEachDescendantOfType$iv;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)resolutionFacade2, (String)"resolutionFacade");
        Intrinsics.checkNotNullParameter(visibilityFilter, (String)"visibilityFilter");
        LinkedHashMap lookupElementToCount = new LinkedHashMap();
        PsiFile psiFile2 = position.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"position.containingFile");
        Object object = (PsiElement)psiFile2;
        Object object2 = (Function1)new Function1<KtParameter, Unit>(this, resolutionFacade2, visibilityFilter, lookupElementToCount){
            final /* synthetic */ VariableOrParameterNameWithTypeCompletion this$0;
            final /* synthetic */ ResolutionFacade $resolutionFacade;
            final /* synthetic */ Function1 $visibilityFilter;
            final /* synthetic */ LinkedHashMap $lookupElementToCount;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull KtParameter parameter) {
                VariableDescriptor descriptor2;
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                ProgressManager.checkCanceled();
                String name2 = parameter.getName();
                if (name2 != null && VariableOrParameterNameWithTypeCompletion.access$getPrefixMatcher$p(this.this$0).isStartMatch(name2) && (descriptor2 = (VariableDescriptor)ResolutionFacade.DefaultImpls.analyze$default((ResolutionFacade)this.$resolutionFacade, (KtElement)((KtElement)parameter), null, (int)2, null).get((ReadOnlySlice)BindingContext.VALUE_PARAMETER, (Object)parameter)) != null) {
                    KotlinType kotlinType = descriptor2.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"descriptor.type");
                    KotlinType parameterType = kotlinType;
                    if (VariableOrParameterNameWithTypeCompletion.access$isVisible(this.this$0, parameterType, this.$visibilityFilter)) {
                        void count;
                        LookupElement lookupElement2 = MyLookupElement.Companion.create(name2, new ArbitraryType(parameterType), VariableOrParameterNameWithTypeCompletion.access$getWithType$p(this.this$0), VariableOrParameterNameWithTypeCompletion.access$getLookupElementFactory$p(this.this$0));
                        Intrinsics.checkNotNull((Object)lookupElement2);
                        LookupElement lookupElement3 = lookupElement2;
                        Pair pair = (Pair)this.$lookupElementToCount.get(lookupElement3);
                        if (pair == null) {
                            pair = new Pair((Object)0, (Object)name2);
                        }
                        Pair pair2 = pair;
                        int n = ((Number)pair2.component1()).intValue();
                        String s = (String)pair2.component2();
                        ((Map)this.$lookupElementToCount).put(lookupElement3, new Pair((Object)((int)(count + true)), (Object)s));
                    }
                }
            }
            {
                this.this$0 = variableOrParameterNameWithTypeCompletion;
                this.$resolutionFacade = resolutionFacade2;
                this.$visibilityFilter = function1;
                this.$lookupElementToCount = linkedHashMap;
                super(1);
            }
        };
        boolean $i$f$forEachDescendantOfType22 = false;
        $this$forEachDescendantOfType$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor((Function1)action$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(@NotNull PsiElement element3) {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                PsiElement it = element3;
                boolean bl = false;
                if (!(it instanceof KtExpression) || it instanceof KtDeclaration) {
                    super.visitElement(element3);
                }
                if (element3 instanceof KtParameter) {
                    this.$action.invoke((Object)element3);
                }
            }
        });
        Map $i$f$forEachDescendantOfType22 = lookupElementToCount;
        object2 = $i$f$forEachDescendantOfType22.entrySet().iterator();
        while (object2.hasNext()) {
            void count;
            void lookupElement2;
            Pair countAndName;
            Object object3 = object = (Map.Entry)object2.next();
            $i$f$forEachDescendantOfType22 = (LookupElement)object3.getKey();
            object3 = object;
            Pair pair = countAndName = (Pair)object3.getValue();
            int n = ((Number)pair.component1()).intValue();
            String name2 = (String)pair.component2();
            lookupElement2.putUserData(PRIORITY_KEY, (Object)((int)(-count)));
            if (this.withType || !this.lookupNamesAdded.contains(name2)) {
                LookupElementsCollector.addElement$default(this.collector, (LookupElement)lookupElement2, false, 2, null);
            }
            this.lookupNamesAdded.add(name2);
        }
    }

    private final void addSuggestionsForClassifier(DeclarationDescriptor classifier2, String userPrefix, boolean notImported) {
        String string = classifier2.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"classifier.name.asString()");
        DeclarationDescriptor declarationDescriptor = classifier2;
        if (declarationDescriptor == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassifierDescriptor");
        }
        this.addSuggestions(string, userPrefix, new DescriptorType((ClassifierDescriptor)declarationDescriptor), notImported);
    }

    private final void addSuggestionsForJavaClass(PsiClass psiClass2, String userPrefix, boolean notImported) {
        String string = psiClass2.getName();
        Intrinsics.checkNotNull((Object)string);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"psiClass.name!!");
        this.addSuggestions(string, userPrefix, new JavaClassType(psiClass2), notImported);
    }

    private final void addSuggestions(String className2, String userPrefix, Type type2, boolean notImported) {
        ProgressManager.checkCanceled();
        if (this.suggestionsByTypesAdded.contains(type2)) {
            return;
        }
        CharSequence charSequence = userPrefix;
        List<String> nameSuggestions2 = KotlinNameSuggester.INSTANCE.getCamelNames(className2, (Function1<? super String, Boolean>)((Function1)addSuggestions.nameSuggestions.1.INSTANCE), charSequence.length() == 0);
        for (String name2 : nameSuggestions2) {
            LookupElement lookupElement2;
            String parameterName2 = userPrefix + name2;
            if (!this.prefixMatcher.isStartMatch(parameterName2) || (lookupElement2 = MyLookupElement.Companion.create(parameterName2, type2, this.withType, this.lookupElementFactory)) == null) continue;
            lookupElement2.putUserData(PRIORITY_KEY, (Object)userPrefix.length());
            if (this.withType || !this.lookupNamesAdded.contains(parameterName2)) {
                this.collector.addElement(lookupElement2, notImported);
            }
            this.suggestionsByTypesAdded.add(type2);
            this.lookupNamesAdded.add(parameterName2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isVisible(KotlinType $this$isVisible, Function1<? super DeclarationDescriptor, Boolean> visibilityFilter) {
        boolean bl;
        if (KotlinTypeKt.isError((KotlinType)$this$isVisible)) {
            return false;
        }
        ClassifierDescriptor classifierDescriptor = $this$isVisible.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) return false;
        Intrinsics.checkNotNullExpressionValue((Object)classifierDescriptor, (String)"constructor.declarationDescriptor ?: return false");
        ClassifierDescriptor classifier2 = classifierDescriptor;
        if ((Boolean)visibilityFilter.invoke((Object)classifier2) == false) return false;
        Iterable $this$all$iv = $this$isVisible.getArguments();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            TypeProjection it = (TypeProjection)element$iv;
            boolean bl2 = false;
            if (!it.isStarProjection()) {
                KotlinType kotlinType = it.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"it.type");
                if (!this.isVisible(kotlinType, visibilityFilter)) return false;
            }
            bl = true;
        } while (bl);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public VariableOrParameterNameWithTypeCompletion(@NotNull LookupElementsCollector collector2, @NotNull BasicLookupElementFactory lookupElementFactory2, @NotNull PrefixMatcher prefixMatcher, @NotNull ResolutionFacade resolutionFacade2, boolean withType) {
        String string;
        Object object;
        int index2;
        Object object2;
        int item$iv$iv;
        Iterator iterator;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        boolean $i$f$map;
        Iterable $this$map$iv;
        List list2;
        char c;
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        Intrinsics.checkNotNullParameter((Object)lookupElementFactory2, (String)"lookupElementFactory");
        Intrinsics.checkNotNullParameter((Object)prefixMatcher, (String)"prefixMatcher");
        Intrinsics.checkNotNullParameter((Object)resolutionFacade2, (String)"resolutionFacade");
        this.collector = collector2;
        this.lookupElementFactory = lookupElementFactory2;
        this.prefixMatcher = prefixMatcher;
        this.resolutionFacade = resolutionFacade2;
        this.withType = withType;
        String string2 = this.prefixMatcher.getPrefix();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"prefixMatcher.prefix");
        String prefix = string2;
        Object[] prefixWords = NameUtil.splitNameIntoWords((String)prefix);
        CharSequence charSequence = prefix;
        if (charSequence.length() == 0 || Character.isUpperCase(c = prefix.charAt(0))) {
            list2 = CollectionsKt.emptyList();
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)prefixWords, (String)"prefixWords");
            $this$map$iv = (Iterable)ArraysKt.getIndices((Object[])prefixWords);
            $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                object2 = destination$iv$iv;
                boolean bl = false;
                object = index2 == 0 ? prefix : CollectionsKt.joinToString$default((Iterable)ArraysKt.drop((Object[])prefixWords, (int)index2), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
                object2.add(object);
            }
            list2 = (List)destination$iv$iv;
        }
        List nameSuggestionPrefixes = list2;
        $this$map$iv = (Iterable)CollectionsKt.getIndices((Collection)nameSuggestionPrefixes);
        object2 = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            index2 = item$iv$iv = ((IntIterator)iterator).nextInt();
            object = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)prefixWords, (String)"prefixWords");
            string = CollectionsKt.joinToString$default((Iterable)ArraysKt.take((Object[])prefixWords, (int)it), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            object.add(string);
        }
        object = (List)destination$iv$iv;
        ((VariableOrParameterNameWithTypeCompletion)object2).userPrefixes = object;
        $this$map$iv = nameSuggestionPrefixes;
        object2 = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            String it = (String)item$iv$iv2;
            object = destination$iv$iv;
            boolean bl = false;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.US");
            string = new CamelHumpMatcher(StringsKt.capitalize((String)it, (Locale)locale), false);
            object.add(string);
        }
        ((VariableOrParameterNameWithTypeCompletion)object2).classNamePrefixMatchers = object = (List)destination$iv$iv;
        this.suggestionsByTypesAdded = new HashSet();
        this.lookupNamesAdded = new HashSet();
    }

    static {
        Companion = new Companion(null);
        PRIORITY_KEY = new Key("ParameterNameAndTypeCompletion.PRIORITY_KEY");
        REPLACEMENT_OFFSET = OffsetKey.create((String)"ParameterNameAndTypeCompletion.REPLACEMENT_OFFSET");
    }

    public static final /* synthetic */ void access$addSuggestionsForClassifier(VariableOrParameterNameWithTypeCompletion $this, DeclarationDescriptor classifier2, String userPrefix, boolean notImported) {
        $this.addSuggestionsForClassifier(classifier2, userPrefix, notImported);
    }

    public static final /* synthetic */ void access$addSuggestionsForJavaClass(VariableOrParameterNameWithTypeCompletion $this, PsiClass psiClass2, String userPrefix, boolean notImported) {
        $this.addSuggestionsForJavaClass(psiClass2, userPrefix, notImported);
    }

    public static final /* synthetic */ PrefixMatcher access$getPrefixMatcher$p(VariableOrParameterNameWithTypeCompletion $this) {
        return $this.prefixMatcher;
    }

    public static final /* synthetic */ boolean access$isVisible(VariableOrParameterNameWithTypeCompletion $this, KotlinType $this$access_u24isVisible, Function1 visibilityFilter) {
        return $this.isVisible($this$access_u24isVisible, (Function1<? super DeclarationDescriptor, Boolean>)visibilityFilter);
    }

    public static final /* synthetic */ boolean access$getWithType$p(VariableOrParameterNameWithTypeCompletion $this) {
        return $this.withType;
    }

    public static final /* synthetic */ BasicLookupElementFactory access$getLookupElementFactory$p(VariableOrParameterNameWithTypeCompletion $this) {
        return $this.lookupElementFactory;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\"\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH&J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/completion/VariableOrParameterNameWithTypeCompletion$Type;", "", "idString", "", "(Ljava/lang/String;)V", "createTypeLookupElement", "Lcom/intellij/codeInsight/lookup/LookupElement;", "lookupElementFactory", "Lorg/jetbrains/kotlin/idea/completion/BasicLookupElementFactory;", "equals", "", "other", "hashCode", "", "kotlin.idea"})
    private static abstract class Type {
        private final String idString;

        @Nullable
        public abstract LookupElement createTypeLookupElement(@NotNull BasicLookupElementFactory var1);

        public boolean equals(@Nullable Object other) {
            return other instanceof Type && Intrinsics.areEqual((Object)((Type)other).idString, (Object)this.idString);
        }

        public int hashCode() {
            return this.idString.hashCode();
        }

        public Type(@NotNull String idString) {
            Intrinsics.checkNotNullParameter((Object)idString, (String)"idString");
            this.idString = idString;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/completion/VariableOrParameterNameWithTypeCompletion$DescriptorType;", "Lorg/jetbrains/kotlin/idea/completion/VariableOrParameterNameWithTypeCompletion$Type;", "classifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;)V", "createTypeLookupElement", "Lcom/intellij/codeInsight/lookup/LookupElement;", "lookupElementFactory", "Lorg/jetbrains/kotlin/idea/completion/BasicLookupElementFactory;", "kotlin.idea"})
    private static final class DescriptorType
    extends Type {
        private final ClassifierDescriptor classifier;

        @Override
        @NotNull
        public LookupElement createTypeLookupElement(@NotNull BasicLookupElementFactory lookupElementFactory2) {
            Intrinsics.checkNotNullParameter((Object)lookupElementFactory2, (String)"lookupElementFactory");
            return BasicLookupElementFactory.createLookupElement$default(lookupElementFactory2, (DeclarationDescriptor)this.classifier, true, false, false, 12, null);
        }

        public DescriptorType(@NotNull ClassifierDescriptor classifier2) {
            Intrinsics.checkNotNullParameter((Object)classifier2, (String)"classifier");
            super(IdeDescriptorRenderers.SOURCE_CODE.renderClassifierName(classifier2));
            this.classifier = classifier2;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/completion/VariableOrParameterNameWithTypeCompletion$JavaClassType;", "Lorg/jetbrains/kotlin/idea/completion/VariableOrParameterNameWithTypeCompletion$Type;", "psiClass", "Lcom/intellij/psi/PsiClass;", "(Lcom/intellij/psi/PsiClass;)V", "createTypeLookupElement", "Lcom/intellij/codeInsight/lookup/LookupElement;", "lookupElementFactory", "Lorg/jetbrains/kotlin/idea/completion/BasicLookupElementFactory;", "kotlin.idea"})
    private static final class JavaClassType
    extends Type {
        private final PsiClass psiClass;

        @Override
        @NotNull
        public LookupElement createTypeLookupElement(@NotNull BasicLookupElementFactory lookupElementFactory2) {
            Intrinsics.checkNotNullParameter((Object)lookupElementFactory2, (String)"lookupElementFactory");
            return BasicLookupElementFactory.createLookupElementForJavaClass$default(lookupElementFactory2, this.psiClass, true, false, 4, null);
        }

        public JavaClassType(@NotNull PsiClass psiClass2) {
            Intrinsics.checkNotNullParameter((Object)psiClass2, (String)"psiClass");
            String string = psiClass2.getQualifiedName();
            Intrinsics.checkNotNull((Object)string);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"psiClass.qualifiedName!!");
            super(string);
            this.psiClass = psiClass2;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/completion/VariableOrParameterNameWithTypeCompletion$ArbitraryType;", "Lorg/jetbrains/kotlin/idea/completion/VariableOrParameterNameWithTypeCompletion$Type;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/types/KotlinType;)V", "createTypeLookupElement", "Lcom/intellij/codeInsight/lookup/LookupElement;", "lookupElementFactory", "Lorg/jetbrains/kotlin/idea/completion/BasicLookupElementFactory;", "kotlin.idea"})
    private static final class ArbitraryType
    extends Type {
        private final KotlinType type;

        @Override
        @Nullable
        public LookupElement createTypeLookupElement(@NotNull BasicLookupElementFactory lookupElementFactory2) {
            Intrinsics.checkNotNullParameter((Object)lookupElementFactory2, (String)"lookupElementFactory");
            return CompletionUtilsKt.createLookupElementForType(lookupElementFactory2, this.type);
        }

        public ArbitraryType(@NotNull KotlinType type2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            super(IdeDescriptorRenderers.SOURCE_CODE.renderType(type2));
            this.type = type2;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB'\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0004H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/completion/VariableOrParameterNameWithTypeCompletion$MyLookupElement;", "Lcom/intellij/codeInsight/lookup/LookupElementDecorator;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "parameterName", "", "type", "Lorg/jetbrains/kotlin/idea/completion/VariableOrParameterNameWithTypeCompletion$Type;", "typeLookupElement", "shouldInsertType", "", "(Ljava/lang/String;Lorg/jetbrains/kotlin/idea/completion/VariableOrParameterNameWithTypeCompletion$Type;Lcom/intellij/codeInsight/lookup/LookupElement;Z)V", "lookupString", "equals", "other", "", "getAllLookupStrings", "", "getDelegateInsertHandler", "Lcom/intellij/codeInsight/completion/InsertHandler;", "getLookupString", "hashCode", "", "renderElement", "", "presentation", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "Companion", "kotlin.idea"})
    private static final class MyLookupElement
    extends LookupElementDecorator<LookupElement> {
        private final String lookupString;
        private final String parameterName;
        private final Type type;
        private final boolean shouldInsertType;
        @NotNull
        public static final Companion Companion = new Companion(null);

        @NotNull
        public String getLookupString() {
            return this.lookupString;
        }

        @NotNull
        public Set<String> getAllLookupStrings() {
            return SetsKt.setOf((Object)this.lookupString);
        }

        public void renderElement(@NotNull LookupElementPresentation presentation) {
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            super.renderElement(presentation);
            if (this.shouldInsertType) {
                presentation.setItemText(this.parameterName + ": " + presentation.getItemText());
            } else {
                CompletionUtilsKt.prependTailText(presentation, ": " + presentation.getItemText(), true);
                presentation.setItemText(this.parameterName);
            }
        }

        @NotNull
        public InsertHandler<LookupElement> getDelegateInsertHandler() {
            return new InsertHandler(this){
                final /* synthetic */ MyLookupElement this$0;

                public final void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement element3) {
                    Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                    if (context2.getCompletionChar() == '\t') {
                        OffsetMap offsetMap = context2.getOffsetMap();
                        Intrinsics.checkNotNullExpressionValue((Object)offsetMap, (String)"context.offsetMap");
                        OffsetKey offsetKey = VariableOrParameterNameWithTypeCompletion.Companion.getREPLACEMENT_OFFSET();
                        Intrinsics.checkNotNullExpressionValue((Object)offsetKey, (String)"REPLACEMENT_OFFSET");
                        Integer replacementOffset = CompletionUtilsKt.tryGetOffset(offsetMap, offsetKey);
                        if (replacementOffset != null) {
                            int tailOffset = context2.getTailOffset();
                            context2.getDocument().deleteString(tailOffset, replacementOffset.intValue());
                            Document document = context2.getDocument();
                            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"context.document");
                            CharSequence charSequence = document.getCharsSequence();
                            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"context.document.charsSequence");
                            CharSequence chars = charSequence;
                            int offset2 = HandlerUtilsKt.skipSpaces(chars, tailOffset);
                            if (HandlerUtilsKt.isCharAt(chars, offset2, ',')) {
                                ++offset2;
                                offset2 = HandlerUtilsKt.skipSpaces(chars, offset2);
                                Editor editor2 = context2.getEditor();
                                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"context.editor");
                                GenerateUtilsKt.moveCaret$default(editor2, offset2, null, 2, null);
                            }
                        }
                    }
                    PsiFile psiFile2 = context2.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"context.file");
                    KotlinCodeStyleSettings settings2 = CodeStyleUtilsKt.getKotlinCustomSettings(psiFile2);
                    String spaceBefore = settings2.SPACE_BEFORE_TYPE_COLON ? " " : "";
                    String spaceAfter = settings2.SPACE_AFTER_TYPE_COLON ? " " : "";
                    int startOffset = context2.getStartOffset();
                    if (MyLookupElement.access$getShouldInsertType$p(this.this$0)) {
                        String text2 = MyLookupElement.access$getParameterName$p(this.this$0) + spaceBefore + ":" + spaceAfter;
                        context2.getDocument().insertString(startOffset, (CharSequence)text2);
                        context2.getOffsetMap().addOffset(CompletionInitializationContext.START_OFFSET, startOffset + text2.length());
                        element3.handleInsert(context2);
                    } else {
                        context2.getDocument().replaceString(startOffset, context2.getTailOffset(), (CharSequence)MyLookupElement.access$getParameterName$p(this.this$0));
                        context2.commitDocument();
                    }
                }
                {
                    this.this$0 = myLookupElement;
                }
            };
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof MyLookupElement && Intrinsics.areEqual((Object)this.parameterName, (Object)((MyLookupElement)((Object)other)).parameterName) && Intrinsics.areEqual((Object)this.type, (Object)((MyLookupElement)((Object)other)).type) && this.shouldInsertType == ((MyLookupElement)((Object)other)).shouldInsertType;
        }

        public int hashCode() {
            return this.parameterName.hashCode();
        }

        private MyLookupElement(String parameterName2, Type type2, LookupElement typeLookupElement, boolean shouldInsertType) {
            super(typeLookupElement);
            Object object;
            this.parameterName = parameterName2;
            this.type = type2;
            this.shouldInsertType = shouldInsertType;
            if (this.shouldInsertType) {
                LookupElement lookupElement2 = this.getDelegate();
                Intrinsics.checkNotNullExpressionValue((Object)lookupElement2, (String)"delegate");
                object = ": " + lookupElement2.getLookupString();
            } else {
                object = "";
            }
            this.lookupString = this.parameterName + (String)object;
        }

        public static final /* synthetic */ boolean access$getShouldInsertType$p(MyLookupElement $this) {
            return $this.shouldInsertType;
        }

        public static final /* synthetic */ String access$getParameterName$p(MyLookupElement $this) {
            return $this.parameterName;
        }

        public /* synthetic */ MyLookupElement(String parameterName2, Type type2, LookupElement typeLookupElement, boolean shouldInsertType, DefaultConstructorMarker $constructor_marker) {
            this(parameterName2, type2, typeLookupElement, shouldInsertType);
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/completion/VariableOrParameterNameWithTypeCompletion$MyLookupElement$Companion;", "", "()V", "create", "Lcom/intellij/codeInsight/lookup/LookupElement;", "parameterName", "", "type", "Lorg/jetbrains/kotlin/idea/completion/VariableOrParameterNameWithTypeCompletion$Type;", "shouldInsertType", "", "factory", "Lorg/jetbrains/kotlin/idea/completion/BasicLookupElementFactory;", "kotlin.idea"})
        public static final class Companion {
            @Nullable
            public final LookupElement create(@NotNull String parameterName2, @NotNull Type type2, boolean shouldInsertType, @NotNull BasicLookupElementFactory factory2) {
                Intrinsics.checkNotNullParameter((Object)parameterName2, (String)"parameterName");
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
                LookupElement lookupElement2 = type2.createTypeLookupElement(factory2);
                if (lookupElement2 == null) {
                    return null;
                }
                LookupElement typeLookupElement = lookupElement2;
                MyLookupElement lookupElement3 = new MyLookupElement(parameterName2, type2, typeLookupElement, shouldInsertType, null);
                if (!shouldInsertType) {
                    lookupElement3.putUserData(KotlinCompletionCharFilter.Companion.getSUPPRESS_ITEM_SELECTION_BY_CHARS_ON_TYPING(), Unit.INSTANCE);
                }
                lookupElement3.putUserData(KotlinCompletionCharFilter.Companion.getHIDE_LOOKUP_ON_COLON(), Unit.INSTANCE);
                return CompletionUtilsNoResolveKt.suppressAutoInsertion((LookupElement)lookupElement3);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/completion/VariableOrParameterNameWithTypeCompletion$Weigher;", "Lcom/intellij/codeInsight/lookup/LookupElementWeigher;", "()V", "weigh", "", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "context", "Lcom/intellij/codeInsight/lookup/WeighingContext;", "(Lcom/intellij/codeInsight/lookup/LookupElement;Lcom/intellij/codeInsight/lookup/WeighingContext;)Ljava/lang/Integer;", "kotlin.idea"})
    public static final class Weigher
    extends LookupElementWeigher {
        @NotNull
        public static final Weigher INSTANCE;

        @NotNull
        public Integer weigh(@NotNull LookupElement element3, @NotNull WeighingContext context2) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Integer n = (Integer)element3.getUserData(PRIORITY_KEY);
            return n != null ? n : 0;
        }

        private Weigher() {
            super("kotlin.parameterNameAndTypePriority");
        }

        static {
            Weigher weigher;
            INSTANCE = weigher = new Weigher();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/completion/VariableOrParameterNameWithTypeCompletion$Companion;", "", "()V", "PRIORITY_KEY", "Lcom/intellij/openapi/util/Key;", "", "REPLACEMENT_OFFSET", "Lcom/intellij/codeInsight/completion/OffsetKey;", "kotlin.jvm.PlatformType", "getREPLACEMENT_OFFSET", "()Lcom/intellij/codeInsight/completion/OffsetKey;", "kotlin.idea"})
    public static final class Companion {
        public final OffsetKey getREPLACEMENT_OFFSET() {
            return REPLACEMENT_OFFSET;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

