/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.dependencies;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import com.intellij.psi.impl.compiled.ClsFieldImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.compiled.ClsMethodImpl;
import com.intellij.psi.util.MethodSignatureUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/dependencies/ScriptDependencySourceNavigationPolicyForJavaClasses;", "Lcom/intellij/psi/impl/compiled/ClsCustomNavigationPolicy;", "()V", "getNavigationElement", "Lcom/intellij/psi/PsiClass;", "clsClass", "Lcom/intellij/psi/impl/compiled/ClsClassImpl;", "Lcom/intellij/psi/PsiElement;", "clsField", "Lcom/intellij/psi/impl/compiled/ClsFieldImpl;", "file", "Lcom/intellij/psi/impl/compiled/ClsFileImpl;", "clsMethod", "Lcom/intellij/psi/impl/compiled/ClsMethodImpl;", "kotlin.core"})
public final class ScriptDependencySourceNavigationPolicyForJavaClasses
implements ClsCustomNavigationPolicy {
    @Nullable
    public PsiClass getNavigationElement(@NotNull ClsClassImpl clsClass) {
        Object[] objectArray;
        ClsClassImpl containingClass2;
        Intrinsics.checkNotNullParameter((Object)clsClass, (String)"clsClass");
        PsiClass psiClass2 = clsClass.getContainingClass();
        if (!(psiClass2 instanceof ClsClassImpl)) {
            psiClass2 = null;
        }
        if ((containingClass2 = (ClsClassImpl)psiClass2) != null) {
            PsiClass psiClass3 = this.getNavigationElement(containingClass2);
            return psiClass3 != null ? psiClass3.findInnerClassByName(clsClass.getName(), false) : null;
        }
        PsiFile psiFile2 = clsClass.getContainingFile();
        if (!(psiFile2 instanceof ClsFileImpl)) {
            psiFile2 = null;
        }
        ClsFileImpl clsFileImpl = (ClsFileImpl)psiFile2;
        if (clsFileImpl == null) {
            return null;
        }
        ClsFileImpl clsFileImpl2 = clsFileImpl;
        PsiElement psiElement2 = this.getNavigationElement(clsFileImpl2);
        if (!(psiElement2 instanceof PsiClassOwner)) {
            psiElement2 = null;
        }
        return (objectArray = (Object[])psiElement2) != null && (objectArray = objectArray.getClasses()) != null ? (PsiClass)ArraysKt.singleOrNull((Object[])objectArray) : null;
    }

    @Nullable
    public PsiElement getNavigationElement(@NotNull ClsMethodImpl clsMethod) {
        PsiMethod psiMethod;
        block3: {
            Intrinsics.checkNotNullParameter((Object)clsMethod, (String)"clsMethod");
            PsiClass psiClass2 = clsMethod.getContainingClass();
            if (psiClass2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.impl.compiled.ClsClassImpl");
            }
            PsiClass psiClass3 = this.getNavigationElement((ClsClassImpl)psiClass2);
            if (psiClass3 == null) {
                return null;
            }
            PsiClass clsClass = psiClass3;
            PsiMethod[] psiMethodArray = clsClass.findMethodsByName(clsMethod.getName(), false);
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"clsClass.findMethodsByName(clsMethod.name, false)");
            PsiMethod[] $this$firstOrNull$iv = psiMethodArray;
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                PsiMethod element$iv;
                PsiMethod it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!MethodSignatureUtil.areParametersErasureEqual((PsiMethod)it, (PsiMethod)((PsiMethod)clsMethod))) continue;
                psiMethod = element$iv;
                break block3;
            }
            psiMethod = null;
        }
        return (PsiElement)psiMethod;
    }

    @Nullable
    public PsiElement getNavigationElement(@NotNull ClsFieldImpl clsField) {
        Intrinsics.checkNotNullParameter((Object)clsField, (String)"clsField");
        PsiClass psiClass2 = clsField.getContainingClass();
        if (psiClass2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.impl.compiled.ClsClassImpl");
        }
        PsiClass psiClass3 = this.getNavigationElement((ClsClassImpl)psiClass2);
        if (psiClass3 == null) {
            return null;
        }
        PsiClass srcClass = psiClass3;
        return (PsiElement)srcClass.findFieldByName(clsField.getName(), false);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public PsiElement getNavigationElement(@NotNull ClsFileImpl file2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        VirtualFile virtualFile2 = file2.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"file.virtualFile");
        VirtualFile virtualFile3 = virtualFile2;
        Project project2 = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"file.project");
        Project project3 = project2;
        ScriptConfigurationManager kotlinScriptConfigurationManager = ScriptConfigurationManager.Companion.getInstance(project3);
        if (!kotlinScriptConfigurationManager.getAllScriptsDependenciesClassFilesScope().contains(virtualFile3)) {
            return null;
        }
        Object[] objectArray = file2.getClasses();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"file.classes");
        Object object = ArraysKt.first((Object[])objectArray);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.impl.compiled.ClsClassImpl");
        }
        String sourceFileName = ((ClsClassImpl)object).getSourceFileName();
        String string = file2.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.packageName");
        String packageName2 = string;
        CharSequence charSequence = packageName2;
        String relativePath = charSequence.length() == 0 ? sourceFileName : StringsKt.replace$default((String)packageName2, (char)'.', (char)'/', (boolean)false, (int)4, null) + "/" + sourceFileName;
        Iterable $this$filter$iv = kotlinScriptConfigurationManager.getAllScriptDependenciesSources();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!it.isValid()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (VirtualFile root : (List)destination$iv$iv) {
            PsiFile sourcePsi;
            VirtualFile sourceFile2 = root.findFileByRelativePath(relativePath);
            if (sourceFile2 == null || !sourceFile2.isValid() || !((sourcePsi = file2.getManager().findFile(sourceFile2)) instanceof PsiClassOwner)) continue;
            return (PsiElement)sourcePsi;
        }
        return null;
    }
}

