/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.classLoading;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.impl.ClassLoadingUtils;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Lambda;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.NoStrataPositionManagerHelperKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.BaseExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluationBundle;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassLoadingAdapter;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoad;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.ReflectionCallClassPatcher;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0002\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J&\u0010\r\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u0015\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/OrdinaryClassLoadingAdapter;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassLoadingAdapter;", "()V", "defineClass", "", "name", "", "bytes", "", "context", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "classLoader", "Lcom/sun/jdi/ClassLoaderReference;", "defineClasses", "classes", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassToLoad;", "isApplicable", "", "info", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassLoadingAdapter$Companion$ClassInfoForEvaluator;", "loadClasses", "ClassBytes", "Companion", "kotlin.jvm-debugger.evaluation"})
public final class OrdinaryClassLoadingAdapter
implements ClassLoadingAdapter {
    @Deprecated
    private static final List<ClassBytes> LAMBDA_SUPERCLASSES;
    @NotNull
    private static final Companion Companion;

    @Override
    public boolean isApplicable(@NotNull ExecutionContext context2, @NotNull ClassLoadingAdapter.Companion.ClassInfoForEvaluator info2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        return info2.isCompilingEvaluatorPreferred() && context2.getClassLoader() != null && !NoStrataPositionManagerHelperKt.isDexDebug((DebugProcess)context2.getDebugProcess());
    }

    @Override
    @NotNull
    public ClassLoaderReference loadClasses(@NotNull ExecutionContext context2, @NotNull Collection<ClassToLoad> classes2) {
        ClassLoaderReference classLoaderReference;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(classes2, (String)"classes");
        DebugProcessImpl process2 = context2.getDebugProcess();
        try {
            classLoaderReference = ClassLoadingUtils.getClassLoader((EvaluationContext)((EvaluationContext)context2.getEvaluationContext()), (DebugProcess)((DebugProcess)process2));
        }
        catch (Exception e) {
            throw (Throwable)new EvaluateException(KotlinDebuggerEvaluationBundle.message("error.creating.class.loader", e.toString()), (Throwable)e);
        }
        ClassLoaderReference classLoader2 = classLoaderReference;
        try {
            ClassLoaderReference classLoaderReference2 = classLoader2;
            Intrinsics.checkNotNullExpressionValue((Object)classLoaderReference2, (String)"classLoader");
            this.defineClasses(classes2, context2, classLoaderReference2);
        }
        catch (Exception e) {
            throw (Throwable)new EvaluateException(KotlinDebuggerEvaluationBundle.message("error.class.definition", e.toString()), (Throwable)e);
        }
        return classLoader2;
    }

    /*
     * WARNING - void declaration
     */
    private final void defineClasses(Collection<ClassToLoad> classes2, ExecutionContext context2, ClassLoaderReference classLoader2) {
        Collection collection;
        if (classes2.size() == 1) {
            collection = classes2;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = LAMBDA_SUPERCLASSES;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ClassBytes classBytes = (ClassBytes)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                ClassToLoad classToLoad = new ClassToLoad(it.getName(), StringsKt.replace$default((String)it.getName(), (char)'.', (char)'/', (boolean)false, (int)4, null) + ".class", it.getBytes());
                collection2.add(classToLoad);
            }
            List lambdaSuperclasses = (List)destination$iv$iv;
            collection = CollectionsKt.plus((Collection)lambdaSuperclasses, (Iterable)classes2);
        }
        Collection classesToLoad = collection;
        for (ClassToLoad classToLoad : classesToLoad) {
            void className2;
            String $i$f$map = classToLoad.component1();
            byte[] bytes2 = classToLoad.component3();
            byte[] patchedBytes = Companion.patchClass(bytes2, Companion.useMagicAccessor(context2));
            this.defineClass((String)className2, patchedBytes, context2, classLoader2);
        }
    }

    private final void defineClass(String name2, byte[] bytes2, ExecutionContext context2, ClassLoaderReference classLoader2) {
        try {
            VirtualMachineProxyImpl vm = context2.getVm();
            ReferenceType referenceType = classLoader2.referenceType();
            if (referenceType == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.sun.jdi.ClassType");
            }
            ClassType classLoaderType = (ClassType)referenceType;
            Method defineMethod = classLoaderType.concreteMethodByName("defineClass", "(Ljava/lang/String;[BII)Ljava/lang/Class;");
            StringReference nameObj = vm.mirrorOf(name2);
            List args = CollectionsKt.listOf((Object[])new Value[]{nameObj, this.mirrorOfByteArray(bytes2, context2), vm.mirrorOf(0), vm.mirrorOf(bytes2.length)});
            BaseExecutionContext baseExecutionContext = context2;
            ObjectReference objectReference = classLoader2;
            Method method = defineMethod;
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"defineMethod");
            BaseExecutionContext.invokeMethod$default(baseExecutionContext, objectReference, method, args, 0, 8, null);
        }
        catch (Exception e) {
            throw (Throwable)new EvaluateException("Error during class " + name2 + " definition: " + e, (Throwable)e);
        }
    }

    static {
        Companion = new Companion(null);
        LAMBDA_SUPERCLASSES = CollectionsKt.listOf((Object)new ClassBytes("kotlin.jvm.internal.Lambda"));
    }

    @Override
    @NotNull
    public ArrayReference mirrorOfByteArray(@NotNull byte[] bytes2, @NotNull ExecutionContext context2) {
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return ClassLoadingAdapter.DefaultImpls.mirrorOfByteArray(this, bytes2, context2);
    }

    public static final /* synthetic */ Companion access$Companion() {
        return Companion;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/OrdinaryClassLoadingAdapter$ClassBytes;", "", "name", "", "(Ljava/lang/String;)V", "bytes", "", "getBytes", "()[B", "bytes$delegate", "Lkotlin/Lazy;", "getName", "()Ljava/lang/String;", "kotlin.jvm-debugger.evaluation"})
    private static final class ClassBytes {
        @NotNull
        private final Lazy bytes$delegate;
        @NotNull
        private final String name;

        @NotNull
        public final byte[] getBytes() {
            Lazy lazy = this.bytes$delegate;
            ClassBytes classBytes = this;
            Object var3_3 = null;
            return (byte[])lazy.getValue();
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public ClassBytes(@NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            this.name = name2;
            this.bytes$delegate = LazyKt.lazy((Function0)((Function0)new Function0<byte[]>(this){
                final /* synthetic */ ClassBytes this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @NotNull
                public final byte[] invoke() {
                    byte[] byArray;
                    InputStream inputStream = this.this$0.getClass().getClassLoader().getResourceAsStream(StringsKt.replace$default((String)this.this$0.getName(), (char)'.', (char)'/', (boolean)false, (int)4, null) + ".class");
                    if (inputStream == null) {
                        throw (Throwable)new EvaluateException(KotlinDebuggerEvaluationBundle.message("error.cant.find.class", this.this$0.getName()));
                    }
                    InputStream inputStream2 = inputStream;
                    Closeable closeable = inputStream2;
                    Throwable throwable = null;
                    try {
                        InputStream it = (InputStream)closeable;
                        boolean bl = false;
                        byArray = ByteStreamsKt.readBytes((InputStream)it);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    return byArray;
                }
                {
                    this.this$0 = classBytes;
                    super(0);
                }
            }));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/OrdinaryClassLoadingAdapter$Companion;", "", "()V", "LAMBDA_SUPERCLASSES", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/OrdinaryClassLoadingAdapter$ClassBytes;", "generateLambdaToString", "", "classVisitor", "Lorg/jetbrains/org/objectweb/asm/ClassVisitor;", "patchClass", "", "bytes", "useMagicAccessor", "", "context", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "kotlin.jvm-debugger.evaluation"})
    private static final class Companion {
        @NotNull
        public final byte[] patchClass(@NotNull byte[] bytes2, boolean useMagicAccessor) {
            Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
            ClassWriter classWriter = new ClassWriter(0);
            ClassVisitor classVisitor2 = new ClassVisitor(useMagicAccessor, classWriter, 589824, (ClassVisitor)classWriter){
                private String superName;
                final /* synthetic */ boolean $useMagicAccessor;
                final /* synthetic */ ClassWriter $classWriter;

                public void visit(int version2, int access, @NotNull String name2, @Nullable String sig, @Nullable String superName, @Nullable String[] interfaces) {
                    Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                    String newSuperName = superName;
                    if (this.$useMagicAccessor && Intrinsics.areEqual((Object)"java/lang/Object", (Object)newSuperName)) {
                        newSuperName = "sun/reflect/MagicAccessorImpl";
                    }
                    this.superName = newSuperName;
                    super.visit(version2, access, name2, sig, newSuperName, interfaces);
                }

                public void visitEnd() {
                    if (Intrinsics.areEqual((Object)this.superName, (Object)"kotlin/jvm/internal/Lambda")) {
                        org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.OrdinaryClassLoadingAdapter$Companion.access$generateLambdaToString(OrdinaryClassLoadingAdapter.access$Companion(), this);
                    }
                }
                {
                    this.$useMagicAccessor = $captured_local_variable$0;
                    this.$classWriter = $captured_local_variable$1;
                    super($super_call_param$2, $super_call_param$3);
                }
            };
            new ClassReader(bytes2).accept(classVisitor2, 0);
            byte[] byArray = classWriter.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"classWriter.toByteArray()");
            return byArray;
        }

        private final void generateLambdaToString(ClassVisitor classVisitor2) {
            InstructionAdapter instructionAdapter;
            Type stringBuilderType = Type.getType(StringBuilder.class);
            Type lambdaType = Type.getType(Lambda.class);
            MethodVisitor methodVisitor = classVisitor2.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
            InstructionAdapter $this$apply = instructionAdapter = new InstructionAdapter(methodVisitor);
            boolean bl = false;
            $this$apply.visitCode();
            $this$apply.anew(stringBuilderType);
            $this$apply.dup();
            Type type2 = stringBuilderType;
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"stringBuilderType");
            $this$apply.invokespecial(type2.getInternalName(), "<init>", "()V", false);
            Type type3 = lambdaType;
            Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"lambdaType");
            $this$apply.aconst((Object)(type3.getClassName() + "#"));
            $this$apply.invokevirtual(stringBuilderType.getInternalName(), "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
            $this$apply.load(0, lambdaType);
            $this$apply.invokevirtual("java/lang/Object", "hashCode", "()I", false);
            $this$apply.invokevirtual(stringBuilderType.getInternalName(), "append", "(I)Ljava/lang/StringBuilder;", false);
            $this$apply.invokevirtual(stringBuilderType.getInternalName(), "toString", "()Ljava/lang/String;", false);
            $this$apply.areturn(Type.getType(String.class));
            $this$apply.visitMaxs(2, 1);
            $this$apply.visitEnd();
        }

        public final boolean useMagicAccessor(@NotNull ExecutionContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            if (ReflectionCallClassPatcher.INSTANCE.isEnabled()) {
                return false;
            }
            String string = context2.getVm().version();
            if (string == null || (string = StringsKt.substringBefore$default((String)string, (char)'_', null, (int)2, null)) == null) {
                return false;
            }
            String rawVersion = string;
            JavaSdkVersion javaSdkVersion = JavaSdkVersion.fromVersionString((String)rawVersion);
            if (javaSdkVersion == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)javaSdkVersion, (String)"JavaSdkVersion.fromVersi\u2026wVersion) ?: return false");
            JavaSdkVersion javaVersion = javaSdkVersion;
            return !javaVersion.isAtLeast(JavaSdkVersion.JDK_1_9);
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$generateLambdaToString(Companion $this, ClassVisitor classVisitor2) {
            $this.generateLambdaToString(classVisitor2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

