/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.navigation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDynamicType;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

public class MemberMatching {
    @Nullable
    private static KtTypeReference getReceiverType(@NotNull KtNamedDeclaration propertyOrFunction) {
        if (propertyOrFunction == null) {
            MemberMatching.$$$reportNull$$$0(0);
        }
        if (propertyOrFunction instanceof KtCallableDeclaration) {
            return ((KtCallableDeclaration)propertyOrFunction).getReceiverTypeReference();
        }
        throw new IllegalArgumentException("Not a callable declaration: " + propertyOrFunction.getClass().getName());
    }

    @NotNull
    private static List<KtParameter> getValueParameters(@NotNull KtNamedDeclaration propertyOrFunction) {
        if (propertyOrFunction == null) {
            MemberMatching.$$$reportNull$$$0(1);
        }
        if (propertyOrFunction instanceof KtCallableDeclaration) {
            List list2 = ((KtCallableDeclaration)propertyOrFunction).getValueParameters();
            if (list2 == null) {
                MemberMatching.$$$reportNull$$$0(2);
            }
            return list2;
        }
        throw new IllegalArgumentException("Not a callable declaration: " + propertyOrFunction.getClass().getName());
    }

    private static String getTypeShortName(@NotNull KtTypeReference typeReference2) {
        if (typeReference2 == null) {
            MemberMatching.$$$reportNull$$$0(3);
        }
        KtTypeElement typeElement = typeReference2.getTypeElement();
        assert (typeElement != null);
        return (String)typeElement.accept((KtVisitor)new KtVisitor<String, Void>(){

            public String visitDeclaration(@NotNull KtDeclaration declaration2, Void data2) {
                if (declaration2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                throw new IllegalStateException("This visitor shouldn't be invoked for " + declaration2.getClass());
            }

            public String visitUserType(@NotNull KtUserType type2, Void data2) {
                if (type2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                KtSimpleNameExpression referenceExpression = type2.getReferenceExpression();
                assert (referenceExpression != null);
                return referenceExpression.getReferencedName();
            }

            public String visitFunctionType(@NotNull KtFunctionType type2, Void data2) {
                if (type2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return StandardNames.getFunctionName((int)(type2.getParameters().size() + (type2.getReceiverTypeReference() != null ? 1 : 0)));
            }

            public String visitNullableType(@NotNull KtNullableType nullableType, Void data2) {
                if (nullableType == null) {
                    1.$$$reportNull$$$0(3);
                }
                KtTypeElement innerType = nullableType.getInnerType();
                assert (innerType != null) : "No inner type: " + nullableType;
                return (String)innerType.accept((KtVisitor)this, null);
            }

            public String visitDynamicType(@NotNull KtDynamicType type2, Void data2) {
                if (type2 == null) {
                    1.$$$reportNull$$$0(4);
                }
                return "dynamic";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "declaration";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "nullableType";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/idea/decompiler/navigation/MemberMatching$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitDeclaration";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitUserType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFunctionType";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNullableType";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitDynamicType";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, null);
    }

    private static boolean typesHaveSameShortName(@NotNull KtTypeReference a, @NotNull KtTypeReference b) {
        if (a == null) {
            MemberMatching.$$$reportNull$$$0(4);
        }
        if (b == null) {
            MemberMatching.$$$reportNull$$$0(5);
        }
        return MemberMatching.getTypeShortName(a).equals(MemberMatching.getTypeShortName(b));
    }

    static boolean sameReceiverPresenceAndParametersCount(@NotNull KtNamedDeclaration a, @NotNull KtNamedDeclaration b) {
        if (a == null) {
            MemberMatching.$$$reportNull$$$0(6);
        }
        if (b == null) {
            MemberMatching.$$$reportNull$$$0(7);
        }
        boolean sameReceiverPresence = MemberMatching.getReceiverType(a) == null == (MemberMatching.getReceiverType(b) == null);
        boolean sameParametersCount = MemberMatching.getValueParameters(a).size() == MemberMatching.getValueParameters(b).size();
        return sameReceiverPresence && sameParametersCount;
    }

    static boolean receiverAndParametersShortTypesMatch(@NotNull KtNamedDeclaration a, @NotNull KtNamedDeclaration b) {
        KtTypeReference bReceiver;
        KtTypeReference aReceiver;
        if (a == null) {
            MemberMatching.$$$reportNull$$$0(8);
        }
        if (b == null) {
            MemberMatching.$$$reportNull$$$0(9);
        }
        if ((aReceiver = MemberMatching.getReceiverType(a)) == null != ((bReceiver = MemberMatching.getReceiverType(b)) == null)) {
            return false;
        }
        if (aReceiver != null && !MemberMatching.typesHaveSameShortName(aReceiver, bReceiver)) {
            return false;
        }
        List<KtParameter> aParameters = MemberMatching.getValueParameters(a);
        List<KtParameter> bParameters = MemberMatching.getValueParameters(b);
        if (aParameters.size() != bParameters.size()) {
            return false;
        }
        for (int i = 0; i < aParameters.size(); ++i) {
            KtTypeReference aType = aParameters.get(i).getTypeReference();
            KtTypeReference bType = bParameters.get(i).getTypeReference();
            assert (aType != null);
            assert (bType != null);
            if (MemberMatching.typesHaveSameShortName(aType, bType)) continue;
            return false;
        }
        return true;
    }

    static boolean receiversMatch(@NotNull KtNamedDeclaration declaration2, @NotNull CallableDescriptor descriptor2) {
        if (declaration2 == null) {
            MemberMatching.$$$reportNull$$$0(10);
        }
        if (descriptor2 == null) {
            MemberMatching.$$$reportNull$$$0(11);
        }
        KtTypeReference declarationReceiver = MemberMatching.getReceiverType(declaration2);
        ReceiverParameterDescriptor descriptorReceiver = descriptor2.getExtensionReceiverParameter();
        if (declarationReceiver == null && descriptorReceiver == null) {
            return true;
        }
        if (declarationReceiver != null && descriptorReceiver != null) {
            return declarationReceiver.getText().equals(DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(descriptorReceiver.getType()));
        }
        return false;
    }

    static boolean valueParametersTypesMatch(@NotNull KtNamedDeclaration declaration2, @NotNull CallableDescriptor descriptor2) {
        if (declaration2 == null) {
            MemberMatching.$$$reportNull$$$0(12);
        }
        if (descriptor2 == null) {
            MemberMatching.$$$reportNull$$$0(13);
        }
        List<KtParameter> declarationParameters = MemberMatching.getValueParameters(declaration2);
        List descriptorParameters = descriptor2.getValueParameters();
        if (descriptorParameters.size() != declarationParameters.size()) {
            return false;
        }
        for (int i = 0; i < descriptorParameters.size(); ++i) {
            KotlinType typeToRender;
            boolean varargInDescriptor;
            ValueParameterDescriptor descriptorParameter = (ValueParameterDescriptor)descriptorParameters.get(i);
            KtParameter declarationParameter = declarationParameters.get(i);
            KtTypeReference typeReference2 = declarationParameter.getTypeReference();
            if (typeReference2 == null) {
                return false;
            }
            KtModifierList modifierList = declarationParameter.getModifierList();
            boolean varargInDeclaration = modifierList != null && modifierList.hasModifier(KtTokens.VARARG_KEYWORD);
            boolean bl = varargInDescriptor = descriptorParameter.getVarargElementType() != null;
            if (varargInDeclaration != varargInDescriptor) {
                return false;
            }
            String declarationTypeText = typeReference2.getText();
            KotlinType kotlinType = typeToRender = varargInDeclaration ? descriptorParameter.getVarargElementType() : descriptorParameter.getType();
            assert (typeToRender != null);
            String descriptorParameterText = DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(typeToRender);
            if (declarationTypeText.equals(descriptorParameterText)) continue;
            return false;
        }
        return true;
    }

    static boolean typeParametersMatch(@NotNull KtTypeParameterListOwner typeParameterListOwner, @NotNull List<TypeParameterDescriptor> typeParameterDescriptors) {
        List decompiledParameters;
        if (typeParameterListOwner == null) {
            MemberMatching.$$$reportNull$$$0(14);
        }
        if (typeParameterDescriptors == null) {
            MemberMatching.$$$reportNull$$$0(15);
        }
        if ((decompiledParameters = typeParameterListOwner.getTypeParameters()).size() != typeParameterDescriptors.size()) {
            return false;
        }
        HashMultimap decompiledParameterToBounds = HashMultimap.create();
        for (KtTypeParameter parameter : decompiledParameters) {
            KtTypeReference extendsBound = parameter.getExtendsBound();
            if (extendsBound == null) continue;
            decompiledParameterToBounds.put((Object)parameter.getNameAsName(), (Object)extendsBound.getText());
        }
        for (KtTypeConstraint typeConstraint : typeParameterListOwner.getTypeConstraints()) {
            KtSimpleNameExpression typeParameterName = typeConstraint.getSubjectTypeParameterName();
            assert (typeParameterName != null);
            KtTypeReference bound = typeConstraint.getBoundTypeReference();
            assert (bound != null);
            decompiledParameterToBounds.put((Object)typeParameterName.getReferencedNameAsName(), (Object)bound.getText());
        }
        for (int i = 0; i < decompiledParameters.size(); ++i) {
            HashSet decompiledUpperBounds;
            KtTypeParameter decompiledParameter = (KtTypeParameter)decompiledParameters.get(i);
            TypeParameterDescriptor descriptor2 = typeParameterDescriptors.get(i);
            Name name2 = decompiledParameter.getNameAsName();
            assert (name2 != null);
            if (!name2.equals((Object)descriptor2.getName())) {
                return false;
            }
            HashSet descriptorUpperBounds = Sets.newHashSet((Iterable)ContainerUtil.map((Collection)descriptor2.getUpperBounds(), type2 -> DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(type2)));
            KotlinBuiltIns builtIns = DescriptorUtilsKt.getBuiltIns((DeclarationDescriptor)descriptor2);
            HashSet hashSet = decompiledUpperBounds = decompiledParameterToBounds.get((Object)descriptor2.getName()).isEmpty() ? Sets.newHashSet((Object[])new String[]{DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType((KotlinType)builtIns.getDefaultBound())}) : Sets.newHashSet((Iterable)decompiledParameterToBounds.get((Object)descriptor2.getName()));
            if (descriptorUpperBounds.equals(decompiledUpperBounds)) continue;
            return false;
        }
        return true;
    }

    private MemberMatching() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyOrFunction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/decompiler/navigation/MemberMatching";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeReference";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameterListOwner";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameterDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/decompiler/navigation/MemberMatching";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReceiverType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getValueParameters";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypeShortName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "typesHaveSameShortName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sameReceiverPresenceAndParametersCount";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "receiverAndParametersShortTypesMatch";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "receiversMatch";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "valueParametersTypesMatch";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "typeParametersMatch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

