/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.core.GenerateUtilsKt;
import org.jetbrains.kotlin.idea.inspections.IntentionBasedInspectionKt;
import org.jetbrains.kotlin.idea.inspections.RedundantWithInspectionKt;
import org.jetbrains.kotlin.idea.inspections.UnusedLambdaExpressionBodyInspection;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiChildRange;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RemoveRedundantWithFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "kotlin.idea"})
final class RemoveRedundantWithFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        return KotlinBundle.message("remove.redundant.with.fix.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        block18: {
            PsiElement replaced2;
            PsiElement psiElement2;
            KtDeclarationWithBody declaration2;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement3 = descriptor2.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"descriptor.psiElement");
            PsiElement psiElement4 = psiElement3.getParent();
            if (!(psiElement4 instanceof KtCallExpression)) {
                psiElement4 = null;
            }
            KtCallExpression ktCallExpression = (KtCallExpression)psiElement4;
            if (ktCallExpression == null) {
                return;
            }
            KtCallExpression callExpression2 = ktCallExpression;
            List list2 = callExpression2.getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"callExpression.valueArguments");
            KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.getOrNull((List)list2, (int)1);
            if (ktValueArgument == null || (ktValueArgument = RedundantWithInspectionKt.access$lambdaExpression(ktValueArgument)) == null) {
                return;
            }
            KtValueArgument lambdaExpression2 = ktValueArgument;
            KtBlockExpression ktBlockExpression = lambdaExpression2.getBodyExpression();
            if (ktBlockExpression == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktBlockExpression, (String)"lambdaExpression.bodyExpression ?: return");
            KtBlockExpression lambdaBody = ktBlockExpression;
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)callExpression2;
            boolean $i$f$getStrictParentOfType = false;
            KtDeclarationWithBody ktDeclarationWithBody = declaration2 = (KtDeclarationWithBody)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtDeclarationWithBody.class, (boolean)true);
            if ((ktDeclarationWithBody != null ? ktDeclarationWithBody.getEqualsToken() : null) != null && Intrinsics.areEqual((Object)KtPsiUtil.deparenthesize((KtExpression)declaration2.getBodyExpression()), (Object)callExpression2)) {
                KtExpression ktExpression;
                KtExpression singleReturnedExpression;
                List list3 = lambdaBody.getStatements();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"lambdaBody.statements");
                Object object = CollectionsKt.singleOrNull((List)list3);
                if (!(object instanceof KtReturnExpression)) {
                    object = null;
                }
                KtReturnExpression ktReturnExpression = (KtReturnExpression)object;
                Object object2 = singleReturnedExpression = ktReturnExpression != null ? ktReturnExpression.getReturnedExpression() : null;
                if (singleReturnedExpression != null) {
                    PsiElement psiElement5;
                    PsiElement $this$replaced$iv = (PsiElement)callExpression2;
                    boolean $i$f$replaced = false;
                    if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)((PsiElement)singleReturnedExpression))) {
                        psiElement5 = (PsiElement)singleReturnedExpression;
                    } else {
                        PsiElement result$iv = $this$replaced$iv.replace((PsiElement)singleReturnedExpression);
                        PsiElement psiElement6 = result$iv;
                        if (!(psiElement6 instanceof KtExpression)) {
                            psiElement6 = null;
                        }
                        if ((psiElement5 = (PsiElement)((KtExpression)psiElement6)) == null) {
                            PsiElement psiElement7 = result$iv;
                            if (psiElement7 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                            }
                            KtExpression ktExpression2 = ((KtParenthesizedExpression)psiElement7).getExpression();
                            if (ktExpression2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                            }
                            psiElement5 = (PsiElement)ktExpression2;
                        }
                    }
                    ktExpression = (KtExpression)psiElement5;
                } else {
                    UnusedLambdaExpressionBodyInspection.Companion.replaceBlockExpressionWithLambdaBody(declaration2, lambdaBody);
                    ktExpression = declaration2.getBodyExpression();
                }
                psiElement2 = (PsiElement)ktExpression;
            } else {
                PsiElement psiElement8;
                PsiChildRange psiChildRange;
                PsiChildRange it = psiChildRange = PsiUtilsKt.getAllChildren((PsiElement)((PsiElement)lambdaBody));
                boolean bl = false;
                Object object = !it.isEmpty() ? psiChildRange : null;
                if (object != null) {
                    PsiChildRange range = psiChildRange = object;
                    boolean bl2 = false;
                    psiElement8 = callExpression2.getParent().addRangeAfter(range.getFirst(), range.getLast(), (PsiElement)callExpression2);
                } else {
                    psiElement8 = null;
                }
                PsiElement result2 = psiElement8;
                callExpression2.delete();
                psiElement2 = replaced2 = result2;
            }
            if (replaced2 == null) break block18;
            Editor editor2 = IntentionBasedInspectionKt.findExistingEditor(replaced2);
            if (editor2 != null) {
                GenerateUtilsKt.moveCaret$default(editor2, PsiUtilsKt.getStartOffset((PsiElement)replaced2), null, 2, null);
            }
        }
    }
}

