/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.UnusedUnaryOperatorInspectionKt;
import org.jetbrains.kotlin.idea.util.SafeAnalyzeKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/UnusedUnaryOperatorInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "RemoveUnaryOperatorFix", "kotlin.idea"})
public final class UnusedUnaryOperatorInspection
extends AbstractKotlinInspection {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return VisitorWrappersKt.prefixExpressionVisitor((Function1)((Function1)new Function1<KtPrefixExpression, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtPrefixExpression prefix) {
                Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
                if (prefix.getBaseExpression() == null) {
                    return;
                }
                IElementType operationToken = prefix.getOperationToken();
                if (Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.PLUS) ^ true && Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.MINUS) ^ true) {
                    return;
                }
                if (UnusedUnaryOperatorInspectionKt.access$isInAnnotationEntry$p(prefix)) {
                    return;
                }
                BindingContext context2 = SafeAnalyzeKt.safeAnalyzeNonSourceRootCode((KtElement)prefix, BodyResolveMode.PARTIAL_WITH_CFA);
                if (Intrinsics.areEqual((Object)context2, (Object)BindingContext.EMPTY) || BindingContextUtilsKt.isUsedAsExpression((KtExpression)((KtExpression)prefix), (BindingContext)context2)) {
                    return;
                }
                ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)prefix.getOperationReference()), (BindingContext)context2);
                Object object = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
                if (!(object instanceof DeclarationDescriptor)) {
                    object = null;
                }
                DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)object;
                if (declarationDescriptor == null) {
                    return;
                }
                DeclarationDescriptor operatorDescriptor = declarationDescriptor;
                if (!KotlinBuiltIns.isUnderKotlinPackage((DeclarationDescriptor)operatorDescriptor)) {
                    return;
                }
                this.$holder.registerProblem((PsiElement)prefix, KotlinBundle.message("unused.unary.operator", new Object[0]), new LocalQuickFix[]{new RemoveUnaryOperatorFix()});
            }
            {
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/UnusedUnaryOperatorInspection$RemoveUnaryOperatorFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "kotlin.idea"})
    private static final class RemoveUnaryOperatorFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return KotlinBundle.message("remove.unary.operator.fix.text", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (!(psiElement2 instanceof KtPrefixExpression)) {
                psiElement2 = null;
            }
            KtPrefixExpression ktPrefixExpression = (KtPrefixExpression)psiElement2;
            if (ktPrefixExpression == null) {
                return;
            }
            KtPrefixExpression prefixExpression = ktPrefixExpression;
            KtExpression ktExpression = prefixExpression.getBaseExpression();
            if (ktExpression == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"prefixExpression.baseExpression ?: return");
            KtExpression baseExpression = ktExpression;
            prefixExpression.replace((PsiElement)baseExpression);
        }
    }
}

