/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.migration;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.idea.configuration.KotlinMigrationProjectServiceKt;
import org.jetbrains.kotlin.idea.configuration.MigrationInfo;
import org.jetbrains.kotlin.idea.inspections.migration.AbstractDiagnosticBasedMigrationInspection;
import org.jetbrains.kotlin.idea.inspections.migration.NonExhaustiveWhenStatementMigrationInspection;
import org.jetbrains.kotlin.idea.quickfix.migration.MigrationFix;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0016\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R,\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/migration/NonExhaustiveWhenStatementMigrationInspection;", "Lorg/jetbrains/kotlin/idea/inspections/migration/AbstractDiagnosticBasedMigrationInspection;", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "Lorg/jetbrains/kotlin/idea/quickfix/migration/MigrationFix;", "()V", "diagnosticFactory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory2;", "", "", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "getDiagnosticFactory", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory2;", "customHighlightRangeIn", "Lcom/intellij/openapi/util/TextRange;", "element", "customIntentionFactory", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "isApplicable", "", "migrationInfo", "Lorg/jetbrains/kotlin/idea/configuration/MigrationInfo;", "kotlin.idea"})
public final class NonExhaustiveWhenStatementMigrationInspection
extends AbstractDiagnosticBasedMigrationInspection<KtWhenExpression>
implements MigrationFix {
    @Override
    public boolean isApplicable(@NotNull MigrationInfo migrationInfo) {
        Intrinsics.checkNotNullParameter((Object)migrationInfo, (String)"migrationInfo");
        return KotlinMigrationProjectServiceKt.isLanguageVersionUpdate(migrationInfo, LanguageVersion.KOTLIN_1_5, LanguageVersion.KOTLIN_1_6);
    }

    @NotNull
    public DiagnosticFactory2<KtWhenExpression, String, List<WhenMissingCase>> getDiagnosticFactory() {
        DiagnosticFactory2 diagnosticFactory2 = Errors.NON_EXHAUSTIVE_WHEN_STATEMENT;
        Intrinsics.checkNotNullExpressionValue((Object)diagnosticFactory2, (String)"Errors.NON_EXHAUSTIVE_WHEN_STATEMENT");
        return diagnosticFactory2;
    }

    @Override
    @NotNull
    public Function1<Diagnostic, IntentionAction> customIntentionFactory() {
        return customIntentionFactory.1.INSTANCE;
    }

    @Override
    @NotNull
    public TextRange customHighlightRangeIn(@NotNull KtWhenExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiElement psiElement2 = element3.getWhenKeyword();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.whenKeyword");
        TextRange textRange = psiElement2.getTextRangeInParent();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"element.whenKeyword.textRangeInParent");
        return textRange;
    }

    public NonExhaustiveWhenStatementMigrationInspection() {
        super(KtWhenExpression.class);
    }
}

