/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.rename.RenameProcessor;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.intentions.ConvertTestFunctionToSpacedIntention;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.js.JsPlatformKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u000f\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0004H&J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0004H\u0004J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\u0006\u0010\u000e\u001a\u00020\u0004H&J\b\u0010\u0014\u001a\u00020\u0010H\u0016J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0004H\u0002\u0082\u0001\u0002\u0018\u0019\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertTestFunctionToSpacedIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "case", "", "(Ljava/lang/String;)V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "convert", "name", "isApplicableName", "", "isSnakeCase", "split", "", "startInWriteAction", "startRename", "newName", "Companion", "Lorg/jetbrains/kotlin/idea/intentions/ConvertCamelCaseTestFunctionToSpacedIntention;", "Lorg/jetbrains/kotlin/idea/intentions/ConvertSnakeCaseTestFunctionToSpacedIntention;", "kotlin.idea"})
public abstract class ConvertTestFunctionToSpacedIntention
extends SelfTargetingRangeIntention<KtNamedFunction> {
    private static final Regex SNAKE_CASE_REGEX;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public abstract List<String> split(@NotNull String var1);

    public abstract boolean isApplicableName(@NotNull String var1);

    protected final boolean isSnakeCase(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        CharSequence charSequence = name2;
        Regex regex = SNAKE_CASE_REGEX;
        return regex.containsMatchIn(charSequence);
    }

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtNamedFunction element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        TargetPlatform platform2 = PlatformKt.getPlatform((KtElement)element3);
        if (TargetPlatformKt.isCommon((TargetPlatform)platform2) || JsPlatformKt.isJs((TargetPlatform)platform2)) {
            return null;
        }
        PsiElement psiElement2 = element3.getNameIdentifier();
        if (psiElement2 == null || (psiElement2 = psiElement2.getTextRange()) == null) {
            return null;
        }
        PsiElement range = psiElement2;
        String string = element3.getName();
        if (string == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.name ?: return null");
        String name2 = string;
        if (!this.isApplicableName(name2)) {
            return null;
        }
        String newName2 = this.convert(name2);
        if (Intrinsics.areEqual((Object)newName2, (Object)KtPsiUtilKt.quoteIfNeeded((String)name2))) {
            return null;
        }
        PsiMethod psiMethod = (PsiMethod)CollectionsKt.firstOrNull((List)LightClassUtilsKt.toLightMethods((PsiElement)((PsiElement)element3)));
        if (psiMethod == null) {
            return null;
        }
        PsiMethod lightMethod = psiMethod;
        if (!TestFrameworks.getInstance().isTestMethod(lightMethod)) {
            return null;
        }
        this.setTextGetter(KotlinBundle.lazyMessage("rename.to.01", newName2));
        return range;
    }

    private final String convert(String name2) {
        return KtPsiUtilKt.quoteIfNeeded((String)CollectionsKt.joinToString$default((Iterable)this.split(name2), (CharSequence)" ", null, null, (int)0, null, (Function1)convert.1.INSTANCE, (int)30, null));
    }

    private final void startRename(KtNamedFunction element3, String newName2) {
        new RenameProcessor(element3.getProject(), (PsiElement)element3, newName2, false, false).run();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void applyTo(@NotNull KtNamedFunction element3, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiElement psiElement2 = element3.getNameIdentifier();
        if (psiElement2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.nameIdentifier ?: return");
        PsiElement nameIdentifier = psiElement2;
        String string = element3.getName();
        if (string == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.name ?: return");
        String oldName = string;
        String oldId = KtPsiUtilKt.quoteIfNeeded((String)oldName);
        String newId = this.convert(oldName);
        if (editor2 != null) {
            TemplateBuilderImpl builder = new TemplateBuilderImpl(nameIdentifier);
            builder.replaceElement(nameIdentifier, newId);
            Template template2 = (Template)ApplicationUtilsKt.runWriteAction((Function0)new Function0<Template>(builder){
                final /* synthetic */ TemplateBuilderImpl $builder;

                public final Template invoke() {
                    return this.$builder.buildInlineTemplate();
                }
                {
                    this.$builder = templateBuilderImpl;
                    super(0);
                }
            });
            TemplateManager.getInstance((Project)element3.getProject()).startTemplate(editor2, template2, (TemplateEditingListener)new TemplateEditingAdapter(this, editor2, oldId, element3, newId){
                private String chosenId;
                private TextRange range;
                final /* synthetic */ ConvertTestFunctionToSpacedIntention this$0;
                final /* synthetic */ Editor $editor;
                final /* synthetic */ String $oldId;
                final /* synthetic */ KtNamedFunction $element;
                final /* synthetic */ String $newId;

                public void beforeTemplateFinished(@NotNull TemplateState state, @Nullable Template template2) {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                    Template template3 = template2;
                    if (!(template3 instanceof TemplateImpl)) {
                        template3 = null;
                    }
                    if ((object = (TemplateImpl)template3) == null || (object = object.getVariableNameAt(0)) == null) {
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"(template as? TemplateIm\u2026riableNameAt(0) ?: return");
                    Object varName = object;
                    Object object2 = state.getVariableValue((String)varName);
                    if (object2 == null || (object2 = object2.getText()) == null || (object2 = KtPsiUtilKt.quoteIfNeeded((String)object2)) == null) {
                        return;
                    }
                    this.chosenId = object2;
                    this.range = state.getVariableRange((String)varName);
                }

                public void templateFinished(@NotNull Template template2, boolean brokenOff) {
                    Intrinsics.checkNotNullParameter((Object)template2, (String)"template");
                    TextRange textRange = this.range;
                    if (textRange != null) {
                        TextRange textRange2;
                        TextRange it = textRange2 = textRange;
                        boolean bl = false;
                        Document document = this.$editor.getDocument();
                        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
                        Document doc = document;
                        ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(doc, it, this){
                            final /* synthetic */ Document $doc;
                            final /* synthetic */ TextRange $it;
                            final /* synthetic */ applyTo.1 this$0;
                            {
                                this.$doc = document;
                                this.$it = textRange;
                                this.this$0 = var3_3;
                                super(0);
                            }

                            public final void invoke() {
                                this.$doc.replaceString(this.$it.getStartOffset(), this.$it.getEndOffset(), (CharSequence)this.this$0.$oldId);
                            }
                        });
                        PsiDocumentManager.getInstance((Project)this.$element.getProject()).commitDocument(doc);
                    }
                    if (!brokenOff && Intrinsics.areEqual((Object)this.chosenId, (Object)this.$oldId) ^ true) {
                        ConvertTestFunctionToSpacedIntention.access$startRename(this.this$0, this.$element, this.chosenId);
                    }
                }
                {
                    this.this$0 = this$0;
                    this.$editor = $captured_local_variable$1;
                    this.$oldId = $captured_local_variable$2;
                    this.$element = $captured_local_variable$3;
                    this.$newId = $captured_local_variable$4;
                    this.chosenId = $captured_local_variable$4;
                }
            });
        } else {
            this.startRename(element3, newId);
        }
    }

    private ConvertTestFunctionToSpacedIntention(String string) {
        super(KtNamedFunction.class, KotlinBundle.lazyMessage("replace.0.name.with.spaces", string), null, 4, null);
    }

    static {
        Companion = new Companion(null);
        String string = ".+_.+";
        SNAKE_CASE_REGEX = new Regex(string);
    }

    public static final /* synthetic */ void access$startRename(ConvertTestFunctionToSpacedIntention $this, KtNamedFunction element3, String newName2) {
        $this.startRename(element3, newName2);
    }

    public /* synthetic */ ConvertTestFunctionToSpacedIntention(String string, DefaultConstructorMarker $constructor_marker) {
        this(string);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertTestFunctionToSpacedIntention$Companion;", "", "()V", "SNAKE_CASE_REGEX", "Lkotlin/text/Regex;", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

