/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.usageView.UsageInfo;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.analysis.AnalyzerUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.FrontendIndependentPsiUtilsKt;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtContainerNodeForControlStructureBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J!\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0014\u001a\u00020\u000e*\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0004H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ReplaceExplicitFunctionLiteralParamWithItIntention;", "Lcom/intellij/codeInsight/intention/PsiElementBaseIntentionAction;", "()V", "getFamilyName", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "startInWriteAction", "targetFunctionLiteral", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "caretOffset", "", "usesName", "name", "ParamRenamingProcessor", "kotlin.idea"})
public final class ReplaceExplicitFunctionLiteralParamWithItIntention
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("replace.explicit.lambda.parameter.with.it", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isAvailable(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiElement element3) {
        void $this$anyDescendantOfType$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        KtFunctionLiteral ktFunctionLiteral = this.targetFunctionLiteral(element3, caretModel.getOffset());
        if (ktFunctionLiteral == null) {
            return false;
        }
        KtFunctionLiteral functionLiteral = ktFunctionLiteral;
        List list2 = functionLiteral.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"functionLiteral.valueParameters");
        KtParameter ktParameter = (KtParameter)CollectionsKt.singleOrNull((List)list2);
        if (ktParameter == null) {
            return false;
        }
        KtParameter parameter = ktParameter;
        if (parameter.getTypeReference() != null) {
            return false;
        }
        if (parameter.getDestructuringDeclaration() != null) {
            return false;
        }
        PsiElement psiElement2 = (PsiElement)functionLiteral;
        Function1 predicate$iv = (Function1)new Function1<KtFunctionLiteral, Boolean>(this, element3){
            final /* synthetic */ ReplaceExplicitFunctionLiteralParamWithItIntention this$0;
            final /* synthetic */ PsiElement $element;

            public final boolean invoke(@NotNull KtFunctionLiteral literal) {
                Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
                String string = this.$element.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.text");
                return ReplaceExplicitFunctionLiteralParamWithItIntention.access$usesName(this.this$0, literal, string) && (!literal.hasParameterSpecification() || ReplaceExplicitFunctionLiteralParamWithItIntention.access$usesName(this.this$0, literal, "it"));
            }
            {
                this.this$0 = replaceExplicitFunctionLiteralParamWithItIntention;
                this.$element = psiElement2;
                super(1);
            }
        };
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(@NotNull PsiElement element3) {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                if (element3 instanceof KtFunctionLiteral && ((Boolean)this.$predicate.invoke((Object)element3)).booleanValue()) {
                    this.$result.element = element3;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element3;
                boolean bl = false;
                super.visitElement(element3);
            }
        });
        boolean bl = (PsiElement)result$iv$iv$iv.element != null;
        if (bl) {
            return false;
        }
        PsiElement psiElement3 = functionLiteral.getParent();
        if (!(psiElement3 instanceof KtLambdaExpression)) {
            psiElement3 = null;
        }
        KtLambdaExpression ktLambdaExpression2 = (KtLambdaExpression)psiElement3;
        if (ktLambdaExpression2 == null) {
            return false;
        }
        KtLambdaExpression lambda2 = ktLambdaExpression2;
        PsiElement lambdaParent = lambda2.getParent();
        if (lambdaParent instanceof KtWhenEntry || lambdaParent instanceof KtContainerNodeForControlStructureBody) {
            return false;
        }
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)lambda2;
        boolean $i$f$getStrictParentOfType = false;
        KtCallExpression call = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallExpression.class, (boolean)true);
        if (call != null) {
            KtQualifiedExpression ktQualifiedExpression;
            KtExpression newCallOrQualified;
            int n;
            block18: {
                List list3 = call.getValueArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"call.valueArguments");
                List $this$indexOfFirst$iv = list3;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    KtValueArgument it = (KtValueArgument)item$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)it.getArgumentExpression(), (Object)lambda2)) {
                        n = index$iv;
                        break block18;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int argumentIndex = n;
            KtExpression callOrQualified = KtPsiUtilKt.getQualifiedExpressionForSelectorOrThis((KtExpression)((KtExpression)call));
            KtExpression $this$safeAs$iv = newCallOrQualified = (KtExpression)FrontendIndependentPsiUtilsKt.copied((PsiElement)callOrQualified);
            boolean $i$f$safeAs = false;
            KtExpression ktExpression = $this$safeAs$iv;
            if (!(ktExpression instanceof KtQualifiedExpression)) {
                ktExpression = null;
            }
            if ((ktQualifiedExpression = (KtQualifiedExpression)ktExpression) == null || (ktQualifiedExpression = UtilsKt.getCallExpression(ktQualifiedExpression)) == null) {
                KtExpression ktExpression2 = newCallOrQualified;
                if (!(ktExpression2 instanceof KtCallExpression)) {
                    ktExpression2 = null;
                }
                ktQualifiedExpression = (KtCallExpression)ktExpression2;
            }
            if (ktQualifiedExpression == null) {
                return false;
            }
            KtQualifiedExpression newCall2 = ktQualifiedExpression;
            List list4 = newCall2.getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"newCall.valueArguments");
            KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.getOrNull((List)list4, (int)argumentIndex);
            if (ktValueArgument == null) {
                List list5 = newCall2.getLambdaArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"newCall.lambdaArguments");
                ktValueArgument = (KtValueArgument)CollectionsKt.singleOrNull((List)list5);
            }
            if (ktValueArgument == null) {
                return false;
            }
            KtValueArgument newArgument = ktValueArgument;
            newArgument.replace((PsiElement)KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, (boolean)false, (int)2, null).createLambdaExpression("", "TODO()"));
            BindingContext newContext = AnalyzerUtilKt.analyzeAsReplacement$default((KtExpression)newCallOrQualified, (KtExpression)callOrQualified, (BindingContext)ResolutionUtils.analyze((KtElement)((KtElement)callOrQualified), (BodyResolveMode)BodyResolveMode.PARTIAL), null, null, null, (int)28, null);
            ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)newCallOrQualified), (BindingContext)newContext);
            if ((resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null) == null) {
                return false;
            }
        }
        this.setText(KotlinBundle.message("replace.explicit.parameter.0.with.it", String.valueOf(parameter.getName())));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean usesName(KtFunctionLiteral $this$usesName, String name2) {
        void $this$anyDescendantOfType$iv;
        PsiElement psiElement2 = (PsiElement)$this$usesName;
        Function1 predicate$iv = (Function1)new Function1<KtSimpleNameExpression, Boolean>(name2){
            final /* synthetic */ String $name;

            public final boolean invoke(@NotNull KtSimpleNameExpression nameExpr) {
                Intrinsics.checkNotNullParameter((Object)nameExpr, (String)"nameExpr");
                return Intrinsics.areEqual((Object)nameExpr.getReferencedName(), (Object)this.$name);
            }
            {
                this.$name = string;
                super(1);
            }
        };
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(@NotNull PsiElement element3) {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                if (element3 instanceof KtSimpleNameExpression && ((Boolean)this.$predicate.invoke((Object)element3)).booleanValue()) {
                    this.$result.element = element3;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element3;
                boolean bl = false;
                super.visitElement(element3);
            }
        });
        return (PsiElement)result$iv$iv$iv.element != null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        int caretOffset = caretModel.getOffset();
        CaretModel caretModel2 = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel2, (String)"editor.caretModel");
        KtFunctionLiteral ktFunctionLiteral = this.targetFunctionLiteral(element3, caretModel2.getOffset());
        if (ktFunctionLiteral == null) {
            return;
        }
        KtFunctionLiteral functionLiteral = ktFunctionLiteral;
        KtParameterList ktParameterList = functionLiteral.getValueParameterList();
        if (ktParameterList == null || (ktParameterList = ktParameterList.getTextRange()) == null) {
            return;
        }
        boolean cursorInParameterList = ktParameterList.containsOffset(caretOffset);
        new ParamRenamingProcessor(editor2, functionLiteral, cursorInParameterList).run();
    }

    /*
     * WARNING - void declaration
     */
    private final KtFunctionLiteral targetFunctionLiteral(PsiElement element3, int caretOffset) {
        void $this$getParentOfType$iv;
        void $this$getParentOfType$iv2;
        PsiElement psiElement2 = element3;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        KtNameReferenceExpression expression2 = (KtNameReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv2, KtNameReferenceExpression.class, (boolean)strict$iv);
        if (expression2 != null) {
            Object object = CollectionsKt.singleOrNull((Iterable)ReferenceUtilKt.resolveMainReferenceToDescriptors((KtElement)expression2));
            if (!(object instanceof ParameterDescriptor)) {
                object = null;
            }
            ParameterDescriptor parameterDescriptor = (ParameterDescriptor)object;
            if (parameterDescriptor == null) {
                return null;
            }
            ParameterDescriptor target2 = parameterDescriptor;
            DeclarationDescriptor declarationDescriptor = target2.getContainingDeclaration();
            if (!(declarationDescriptor instanceof AnonymousFunctionDescriptor)) {
                declarationDescriptor = null;
            }
            AnonymousFunctionDescriptor anonymousFunctionDescriptor = (AnonymousFunctionDescriptor)declarationDescriptor;
            if (anonymousFunctionDescriptor == null) {
                return null;
            }
            AnonymousFunctionDescriptor functionDescriptor2 = anonymousFunctionDescriptor;
            PsiElement psiElement3 = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)((DeclarationDescriptor)functionDescriptor2));
            if (!(psiElement3 instanceof KtFunctionLiteral)) {
                psiElement3 = null;
            }
            return (KtFunctionLiteral)psiElement3;
        }
        PsiElement functionDescriptor2 = element3;
        boolean strict$iv2 = true;
        boolean $i$f$getParentOfType2 = false;
        KtFunctionLiteral ktFunctionLiteral = (KtFunctionLiteral)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtFunctionLiteral.class, (boolean)strict$iv2);
        if (ktFunctionLiteral == null) {
            return null;
        }
        KtFunctionLiteral functionLiteral = ktFunctionLiteral;
        PsiElement psiElement4 = functionLiteral.getArrow();
        if (psiElement4 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"functionLiteral.arrow ?: return null");
        PsiElement arrow2 = psiElement4;
        if (caretOffset > PsiUtilsKt.getEndOffset((PsiElement)arrow2)) {
            return null;
        }
        return functionLiteral;
    }

    public static final /* synthetic */ boolean access$usesName(ReplaceExplicitFunctionLiteralParamWithItIntention $this, KtFunctionLiteral $this$access_u24usesName, String name2) {
        return $this.usesName($this$access_u24usesName, name2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012H\u0016\u00a2\u0006\u0002\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ReplaceExplicitFunctionLiteralParamWithItIntention$ParamRenamingProcessor;", "Lcom/intellij/refactoring/rename/RenameProcessor;", "editor", "Lcom/intellij/openapi/editor/Editor;", "functionLiteral", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "cursorWasInParameterList", "", "(Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;Z)V", "getCursorWasInParameterList", "()Z", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getFunctionLiteral", "()Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "performRefactoring", "", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)V", "kotlin.idea"})
    private static final class ParamRenamingProcessor
    extends RenameProcessor {
        @NotNull
        private final Editor editor;
        @NotNull
        private final KtFunctionLiteral functionLiteral;
        private final boolean cursorWasInParameterList;

        public void performRefactoring(@NotNull UsageInfo[] usages2) {
            Intrinsics.checkNotNullParameter((Object)usages2, (String)"usages");
            super.performRefactoring(usages2);
            PsiElement psiElement2 = this.functionLiteral.getArrow();
            if (psiElement2 == null) {
                return;
            }
            this.functionLiteral.deleteChildRange((PsiElement)this.functionLiteral.getValueParameterList(), psiElement2);
            if (this.cursorWasInParameterList) {
                KtBlockExpression ktBlockExpression = this.functionLiteral.getBodyExpression();
                if (ktBlockExpression == null) {
                    return;
                }
                this.editor.getCaretModel().moveToOffset(ktBlockExpression.getTextOffset());
            }
            Project project2 = this.functionLiteral.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"functionLiteral.project");
            Project project3 = project2;
            PsiDocumentManager.getInstance((Project)project3).doPostponedOperationsAndUnblockDocument(this.editor.getDocument());
            CodeStyleManager.getInstance((Project)project3).adjustLineIndent(this.functionLiteral.getContainingFile(), this.functionLiteral.getTextRange());
        }

        @NotNull
        public final Editor getEditor() {
            return this.editor;
        }

        @NotNull
        public final KtFunctionLiteral getFunctionLiteral() {
            return this.functionLiteral;
        }

        public final boolean getCursorWasInParameterList() {
            return this.cursorWasInParameterList;
        }

        public ParamRenamingProcessor(@NotNull Editor editor2, @NotNull KtFunctionLiteral functionLiteral, boolean cursorWasInParameterList) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)functionLiteral, (String)"functionLiteral");
            Project project2 = editor2.getProject();
            Intrinsics.checkNotNull((Object)project2);
            List list2 = functionLiteral.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"functionLiteral.valueParameters");
            super(project2, (PsiElement)CollectionsKt.single((List)list2), "it", false, false);
            this.editor = editor2;
            this.functionLiteral = functionLiteral;
            this.cursorWasInParameterList = cursorWasInParameterList;
        }
    }
}

