/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.j2k;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.j2k.ReferenceSearcher;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0003\u001a.\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\b\u00a2\u0006\u0002\b\u00070\u0004\u00a2\u0006\u0002\b\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/j2k/IdeaReferenceSearcher;", "Lorg/jetbrains/kotlin/j2k/ReferenceSearcher;", "()V", "findLocalUsages", "", "Lcom/intellij/psi/PsiReference;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "element", "Lcom/intellij/psi/PsiElement;", "scope", "findUsagesForExternalCodeProcessing", "searchJava", "", "searchKotlin", "hasInheritors", "class", "Lcom/intellij/psi/PsiClass;", "hasOverrides", "method", "Lcom/intellij/psi/PsiMethod;", "kotlin.j2k.idea"})
public final class IdeaReferenceSearcher
implements ReferenceSearcher {
    @NotNull
    public static final IdeaReferenceSearcher INSTANCE;

    @Override
    @NotNull
    public Collection<PsiReference> findLocalUsages(@NotNull PsiElement element3, @NotNull PsiElement scope2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Collection collection = ReferencesSearch.search((PsiElement)element3, (SearchScope)((SearchScope)new LocalSearchScope(scope2))).findAll();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"ReferencesSearch.search(\u2026chScope(scope)).findAll()");
        return collection;
    }

    @Override
    public boolean hasInheritors(@NotNull PsiClass psiClass2) {
        Intrinsics.checkNotNullParameter((Object)psiClass2, (String)"class");
        Query query = ClassInheritorsSearch.search((PsiClass)psiClass2, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"ClassInheritorsSearch.search(`class`, false)");
        return CollectionsKt.any((Iterable)((Iterable)query));
    }

    @Override
    public boolean hasOverrides(@NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Query query = OverridingMethodsSearch.search((PsiMethod)method, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"OverridingMethodsSearch.search(method, false)");
        return CollectionsKt.any((Iterable)((Iterable)query));
    }

    @Override
    @NotNull
    public Collection<PsiReference> findUsagesForExternalCodeProcessing(@NotNull PsiElement element3, boolean searchJava, boolean searchKotlin) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        ArrayList<LanguageFileType> fileTypes = new ArrayList<LanguageFileType>();
        if (searchJava) {
            JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)javaLanguage, (String)"JavaLanguage.INSTANCE");
            LanguageFileType languageFileType = javaLanguage.getAssociatedFileType();
            Intrinsics.checkNotNull((Object)languageFileType);
            fileTypes.add(languageFileType);
        }
        if (searchKotlin) {
            KotlinLanguage kotlinLanguage = KotlinLanguage.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)kotlinLanguage, (String)"KotlinLanguage.INSTANCE");
            LanguageFileType languageFileType = kotlinLanguage.getAssociatedFileType();
            Intrinsics.checkNotNull((Object)languageFileType);
            fileTypes.add(languageFileType);
        }
        Collection $this$toTypedArray$iv = fileTypes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        FileType[] fileTypeArray = thisCollection$iv.toArray(new FileType[0]);
        if (fileTypeArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)GlobalSearchScope.projectScope((Project)element3.getProject()), (FileType[])Arrays.copyOf(fileTypeArray, fileTypeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.getSco\u2026fileTypes.toTypedArray())");
        GlobalSearchScope searchScope2 = globalSearchScope;
        Collection collection = ReferencesSearch.search((PsiElement)element3, (SearchScope)((SearchScope)searchScope2)).findAll();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"ReferencesSearch.search(\u2026t, searchScope).findAll()");
        return collection;
    }

    private IdeaReferenceSearcher() {
    }

    static {
        IdeaReferenceSearcher ideaReferenceSearcher;
        INSTANCE = ideaReferenceSearcher = new IdeaReferenceSearcher();
    }
}

