/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.cutPaste;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.util.RangeUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.cutPaste.MoveDeclarationsEditorCookie;
import org.jetbrains.kotlin.idea.refactoring.cutPaste.MoveDeclarationsIntentionAction;
import org.jetbrains.kotlin.idea.refactoring.cutPaste.MoveDeclarationsProcessor;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/cutPaste/MoveDeclarationsPassFactory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "()V", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "MyPass", "Registrar", "kotlin.idea"})
public final class MoveDeclarationsPassFactory
implements TextEditorHighlightingPassFactory {
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Project project2 = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"file.project");
        return new MyPass(project2, file2, editor2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/cutPaste/MoveDeclarationsPassFactory$Registrar;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactoryRegistrar;", "()V", "registerHighlightingPassFactory", "", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.idea"})
    public static final class Registrar
    implements TextEditorHighlightingPassFactoryRegistrar {
        public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)new MoveDeclarationsPassFactory(), TextEditorHighlightingPassRegistrar.Anchor.BEFORE, 3, true, true);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/cutPaste/MoveDeclarationsPassFactory$MyPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;)V", "buildHighlightingInfo", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "doApplyInformationToEditor", "", "doCollectInformation", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "kotlin.idea"})
    private static final class MyPass
    extends TextEditorHighlightingPass {
        private final Project project;
        private final PsiFile file;
        private final Editor editor;

        public void doCollectInformation(@NotNull ProgressIndicator progress2) {
            Intrinsics.checkNotNullParameter((Object)progress2, (String)"progress");
        }

        public void doApplyInformationToEditor() {
            HighlightInfo info2 = this.buildHighlightingInfo();
            Document document = this.myDocument;
            Intrinsics.checkNotNull((Object)document);
            UpdateHighlightersUtil.setHighlightersToEditor((Project)this.project, (Document)document, (int)0, (int)this.file.getTextLength(), (Collection)CollectionsKt.listOfNotNull((Object)info2), (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
        }

        private final HighlightInfo buildHighlightingInfo() {
            MoveDeclarationsEditorCookie moveDeclarationsEditorCookie = (MoveDeclarationsEditorCookie)this.editor.getUserData(MoveDeclarationsEditorCookie.Companion.getKEY());
            if (moveDeclarationsEditorCookie == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)moveDeclarationsEditorCookie, (String)"editor.getUserData(MoveD\u2026ookie.KEY) ?: return null");
            MoveDeclarationsEditorCookie cookie = moveDeclarationsEditorCookie;
            long l = cookie.getModificationCount();
            PsiModificationTracker psiModificationTracker = PsiModificationTracker.SERVICE.getInstance((Project)this.project);
            Intrinsics.checkNotNullExpressionValue((Object)psiModificationTracker, (String)"PsiModificationTracker.S\u2026VICE.getInstance(project)");
            if (l != psiModificationTracker.getModificationCount()) {
                return null;
            }
            MoveDeclarationsProcessor processor2 = MoveDeclarationsProcessor.Companion.build(this.editor, cookie);
            if (processor2 == null) {
                this.editor.putUserData(MoveDeclarationsEditorCookie.Companion.getKEY(), null);
                return null;
            }
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION);
            TextRange textRange = RangeUtilsKt.getRange(cookie.getBounds());
            Intrinsics.checkNotNull((Object)textRange);
            HighlightInfo highlightInfo = builder.range(textRange).createUnconditionally();
            Intrinsics.checkNotNullExpressionValue((Object)highlightInfo, (String)"HighlightInfo.newHighlig\u2026 .createUnconditionally()");
            HighlightInfo info2 = highlightInfo;
            QuickFixAction.registerQuickFixAction((HighlightInfo)info2, (IntentionAction)((IntentionAction)new MoveDeclarationsIntentionAction(processor2, cookie.getBounds(), cookie.getModificationCount())));
            return info2;
        }

        public MyPass(@NotNull Project project2, @NotNull PsiFile file2, @NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            super(project2, editor2.getDocument(), true);
            this.project = project2;
            this.file = file2;
            this.editor = editor2;
        }
    }
}

